/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.util;

import com.fs.starfarer.api.Global;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.ShaderModPlugin;
import org.dark.shaders.util.TextureEntry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextureData {
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private static boolean loadMaterial = false;
    private static boolean loadNormal = false;
    private static boolean loadSurface = false;
    private static final Map<String, TextureEntry> materialData = new HashMap<String, TextureEntry>(1000);
    private static final Map<String, TextureEntry> normalData = new HashMap<String, TextureEntry>(1000);
    private static final Map<String, TextureEntry> surfaceData = new HashMap<String, TextureEntry>(1000);

    public static TextureEntry getTextureData(String key, TextureDataType map, ObjectType type, int frame) {
        String typeStr;
        if (key == null) {
            return null;
        }
        switch (type) {
            case SHIP: {
                typeStr = "$$$ship";
                break;
            }
            case TURRET: {
                typeStr = "$$$turret";
                break;
            }
            case TURRET_BARREL: {
                typeStr = "$$$turretbarrel";
                break;
            }
            case TURRET_UNDER: {
                typeStr = "$$$turretunder";
                break;
            }
            case TURRET_COVER_SMALL: {
                typeStr = "$$$turretcoversmall";
                break;
            }
            case TURRET_COVER_MEDIUM: {
                typeStr = "$$$turretcovermedium";
                break;
            }
            case TURRET_COVER_LARGE: {
                typeStr = "$$$turretcoverlarge";
                break;
            }
            case HARDPOINT: {
                typeStr = "$$$hardpoint";
                break;
            }
            case HARDPOINT_BARREL: {
                typeStr = "$$$hardpointbarrel";
                break;
            }
            case HARDPOINT_UNDER: {
                typeStr = "$$$hardpointunder";
                break;
            }
            case HARDPOINT_COVER_SMALL: {
                typeStr = "$$$hardpointcoversmall";
                break;
            }
            case HARDPOINT_COVER_MEDIUM: {
                typeStr = "$$$hardpointcovermedium";
                break;
            }
            case HARDPOINT_COVER_LARGE: {
                typeStr = "$$$hardpointcoverlarge";
                break;
            }
            case MISSILE: {
                typeStr = "$$$missile";
                break;
            }
            case ASTEROID: {
                typeStr = "$$$asteroid";
                break;
            }
            default: {
                return null;
            }
        }
        if (map == TextureDataType.MATERIAL_MAP && loadMaterial) {
            return materialData.get(key + typeStr + frame);
        }
        if (map == TextureDataType.NORMAL_MAP && loadNormal) {
            return normalData.get(key + typeStr + frame);
        }
        if (map == TextureDataType.SURFACE_MAP && loadSurface) {
            return surfaceData.get(key + typeStr + frame);
        }
        return null;
    }

    public static void readTextureDataCSV(String localPath) {
        try {
            JSONArray textureData = Global.getSettings().loadCSV(localPath);
            block52: for (int i = 0; i < textureData.length(); ++i) {
                JSONObject entry;
                if (i % 10 == 0) {
                    ShaderModPlugin.refresh();
                }
                if ((entry = textureData.getJSONObject(i)).optString("id").isEmpty() || entry.optString("type").isEmpty() || entry.optString("map").isEmpty() || entry.optString("path").isEmpty()) continue;
                boolean success = true;
                String type = "";
                switch (entry.getString("type")) {
                    case "ship": {
                        type = "$$$ship";
                        break;
                    }
                    case "turret": {
                        type = "$$$turret";
                        break;
                    }
                    case "turretbarrel": {
                        type = "$$$turretbarrel";
                        break;
                    }
                    case "turretunder": {
                        type = "$$$turretunder";
                        break;
                    }
                    case "turretcoversmall": {
                        type = "$$$turretcoversmall";
                        break;
                    }
                    case "turretcovermedium": {
                        type = "$$$turretcovermedium";
                        break;
                    }
                    case "turretcoverlarge": {
                        type = "$$$turretcoverlarge";
                        break;
                    }
                    case "hardpoint": {
                        type = "$$$hardpoint";
                        break;
                    }
                    case "hardpointbarrel": {
                        type = "$$$hardpointbarrel";
                        break;
                    }
                    case "hardpointunder": {
                        type = "$$$hardpointunder";
                        break;
                    }
                    case "hardpointcoversmall": {
                        type = "$$$hardpointcoversmall";
                        break;
                    }
                    case "hardpointcovermedium": {
                        type = "$$$hardpointcovermedium";
                        break;
                    }
                    case "hardpointcoverlarge": {
                        type = "$$$hardpointcoverlarge";
                        break;
                    }
                    case "missile": {
                        type = "$$$missile";
                        break;
                    }
                    case "asteroid": {
                        type = "$$$asteroid";
                        break;
                    }
                    default: {
                        success = false;
                    }
                }
                if (!success) continue;
                String path = entry.getString("path");
                switch (entry.getString("map")) {
                    case "material": {
                        if (!loadMaterial) continue block52;
                        if (Global.getSettings().getSprite(path) == null || Global.getSettings().getSprite(path).getHeight() < 1.0f) {
                            try {
                                Global.getSettings().loadTexture(path);
                            }
                            catch (IOException e) {
                                Global.getLogger(TextureData.class).log((Priority)Level.ERROR, (Object)("Texture loading failed at " + path + "! " + e.getMessage()));
                                continue block52;
                            }
                        }
                        materialData.put(entry.getString("id") + type + entry.optInt("frame", 0), new TextureEntry(Global.getSettings().getSprite(path), (float)entry.optDouble("magnitude", 1.0)));
                        continue block52;
                    }
                    case "normal": {
                        if (!loadNormal) continue block52;
                        if (Global.getSettings().getSprite(path) == null || Global.getSettings().getSprite(path).getHeight() < 1.0f) {
                            try {
                                Global.getSettings().loadTexture(path);
                            }
                            catch (IOException e) {
                                Global.getLogger(TextureData.class).log((Priority)Level.ERROR, (Object)("Texture loading failed at " + path + "! " + e.getMessage()));
                                continue block52;
                            }
                        }
                        normalData.put(entry.getString("id") + type + entry.optInt("frame", 0), new TextureEntry(Global.getSettings().getSprite(path), (float)entry.optDouble("magnitude", 1.0)));
                        continue block52;
                    }
                    case "surface": {
                        if (!loadSurface) continue block52;
                        if (Global.getSettings().getSprite(path) == null || Global.getSettings().getSprite(path).getHeight() < 1.0f) {
                            try {
                                Global.getSettings().loadTexture(path);
                            }
                            catch (IOException e) {
                                Global.getLogger(TextureData.class).log((Priority)Level.ERROR, (Object)("Texture loading failed at " + path + "! " + e.getMessage()));
                                continue block52;
                            }
                        }
                        surfaceData.put(entry.getString("id") + type + entry.optInt("frame", 0), new TextureEntry(Global.getSettings().getSprite(path), (float)entry.optDouble("magnitude", 1.0)));
                        continue block52;
                    }
                }
            }
        }
        catch (IOException | JSONException e) {
            Global.getLogger(TextureData.class).log((Priority)Level.ERROR, (Object)("Texture data loading failed for " + localPath + "! " + e.getMessage()));
        }
    }

    public static void readTextureDataCSVNoOverwrite(String localPath) {
        try {
            JSONArray textureData = Global.getSettings().loadCSV(localPath);
            block52: for (int i = 0; i < textureData.length(); ++i) {
                JSONObject entry;
                if (i % 10 == 0) {
                    ShaderModPlugin.refresh();
                }
                if ((entry = textureData.getJSONObject(i)).optString("id").isEmpty() || entry.optString("type").isEmpty() || entry.optString("map").isEmpty() || entry.optString("path").isEmpty()) continue;
                boolean success = true;
                String type = "";
                switch (entry.getString("type")) {
                    case "ship": {
                        type = "$$$ship";
                        break;
                    }
                    case "turret": {
                        type = "$$$turret";
                        break;
                    }
                    case "turretbarrel": {
                        type = "$$$turretbarrel";
                        break;
                    }
                    case "turretunder": {
                        type = "$$$turretunder";
                        break;
                    }
                    case "turretcoversmall": {
                        type = "$$$turretcoversmall";
                        break;
                    }
                    case "turretcovermedium": {
                        type = "$$$turretcovermedium";
                        break;
                    }
                    case "turretcoverlarge": {
                        type = "$$$turretcoverlarge";
                        break;
                    }
                    case "hardpoint": {
                        type = "$$$hardpoint";
                        break;
                    }
                    case "hardpointbarrel": {
                        type = "$$$hardpointbarrel";
                        break;
                    }
                    case "hardpointunder": {
                        type = "$$$hardpointunder";
                        break;
                    }
                    case "hardpointcoversmall": {
                        type = "$$$hardpointcoversmall";
                        break;
                    }
                    case "hardpointcovermedium": {
                        type = "$$$hardpointcovermedium";
                        break;
                    }
                    case "hardpointcoverlarge": {
                        type = "$$$hardpointcoverlarge";
                        break;
                    }
                    case "missile": {
                        type = "$$$missile";
                        break;
                    }
                    case "asteroid": {
                        type = "$$$asteroid";
                        break;
                    }
                    default: {
                        success = false;
                    }
                }
                if (!success) continue;
                String path = entry.getString("path");
                switch (entry.getString("map")) {
                    case "material": {
                        if (!loadMaterial) continue block52;
                        if (Global.getSettings().getSprite(path) == null || Global.getSettings().getSprite(path).getHeight() < 1.0f) {
                            try {
                                Global.getSettings().loadTexture(path);
                            }
                            catch (IOException e) {
                                Global.getLogger(TextureData.class).log((Priority)Level.ERROR, (Object)("Texture loading failed at " + path + "! " + e.getMessage()));
                                continue block52;
                            }
                        }
                        if (materialData.containsKey(entry.getString("id") + type + entry.optInt("frame", 0))) continue block52;
                        materialData.put(entry.getString("id") + type + entry.optInt("frame", 0), new TextureEntry(Global.getSettings().getSprite(path), (float)entry.optDouble("magnitude", 1.0)));
                        continue block52;
                    }
                    case "normal": {
                        if (!loadNormal) continue block52;
                        if (Global.getSettings().getSprite(path) == null || Global.getSettings().getSprite(path).getHeight() < 1.0f) {
                            try {
                                Global.getSettings().loadTexture(path);
                            }
                            catch (IOException e) {
                                Global.getLogger(TextureData.class).log((Priority)Level.ERROR, (Object)("Texture loading failed at " + path + "! " + e.getMessage()));
                                continue block52;
                            }
                        }
                        if (normalData.containsKey(entry.getString("id") + type + entry.optInt("frame", 0))) continue block52;
                        normalData.put(entry.getString("id") + type + entry.optInt("frame", 0), new TextureEntry(Global.getSettings().getSprite(path), (float)entry.optDouble("magnitude", 1.0)));
                        continue block52;
                    }
                    case "surface": {
                        if (!loadSurface) continue block52;
                        if (Global.getSettings().getSprite(path) == null || Global.getSettings().getSprite(path).getHeight() < 1.0f) {
                            try {
                                Global.getSettings().loadTexture(path);
                            }
                            catch (IOException e) {
                                Global.getLogger(TextureData.class).log((Priority)Level.ERROR, (Object)("Texture loading failed at " + path + "! " + e.getMessage()));
                                continue block52;
                            }
                        }
                        if (surfaceData.containsKey(entry.getString("id") + type + entry.optInt("frame", 0))) continue block52;
                        surfaceData.put(entry.getString("id") + type + entry.optInt("frame", 0), new TextureEntry(Global.getSettings().getSprite(path), (float)entry.optDouble("magnitude", 1.0)));
                        continue block52;
                    }
                }
            }
        }
        catch (IOException | JSONException e) {
            Global.getLogger(TextureData.class).log((Priority)Level.ERROR, (Object)("Texture data loading failed for " + localPath + "! " + e.getMessage()));
        }
    }

    private static void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        boolean enableShaders = settings.getBoolean("enableShaders");
        if (!enableShaders) {
            loadMaterial = false;
            loadNormal = false;
            loadSurface = false;
            return;
        }
        boolean enabled = settings.getBoolean("enableLights");
        if (enabled) {
            loadMaterial = settings.getBoolean("loadMaterial");
            loadNormal = settings.getBoolean("enableNormal");
            loadSurface = loadNormal ? settings.getBoolean("loadSurface") : false;
        } else {
            loadMaterial = false;
            loadNormal = false;
            loadSurface = false;
        }
    }

    static {
        Global.getLogger(TextureData.class).setLevel(Level.ERROR);
        try {
            TextureData.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(TextureData.class).log((Priority)Level.ERROR, (Object)("Failed to load shader settings: " + e.getMessage()));
        }
    }

    public static enum ObjectType {
        SHIP,
        TURRET,
        TURRET_BARREL,
        TURRET_UNDER,
        TURRET_COVER_SMALL,
        TURRET_COVER_MEDIUM,
        TURRET_COVER_LARGE,
        HARDPOINT,
        HARDPOINT_BARREL,
        HARDPOINT_UNDER,
        HARDPOINT_COVER_SMALL,
        HARDPOINT_COVER_MEDIUM,
        HARDPOINT_COVER_LARGE,
        MISSILE,
        ASTEROID;

    }

    public static enum TextureDataType {
        MATERIAL_MAP,
        NORMAL_MAP,
        SURFACE_MAP;

    }
}

