/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BoundsAPI;
import com.fs.starfarer.api.combat.CombatAsteroidAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MissileRenderDataAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.graphics.util.Tessellate;
import org.dark.shaders.ShaderModPlugin;
import org.dark.shaders.util.ShaderAPI;
import org.dark.shaders.util.TextureData;
import org.dark.shaders.util.TextureEntry;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.vector.Vector2f;

public final class ShaderLib {
    public static final Comparator<ShipAPI> SHIP_DRAW_ORDER = new Comparator<ShipAPI>(){

        @Override
        public int compare(ShipAPI ship1, ShipAPI ship2) {
            if ((ship1.isFighter() || ship1.isDrone()) && !ship2.isFighter() && !ship2.isDrone()) {
                return 1;
            }
            if (!ship1.isFighter() && !ship1.isDrone() && (ship2.isFighter() || ship2.isDrone())) {
                return -1;
            }
            if (ship1.getParentStation() == ship2) {
                if (ship1.getHullSpec().getHints().contains(ShipHullSpecAPI.ShipTypeHints.UNDER_PARENT)) {
                    return -1;
                }
                return 1;
            }
            if (ship2.getParentStation() == ship1) {
                if (ship2.getHullSpec().getHints().contains(ShipHullSpecAPI.ShipTypeHints.UNDER_PARENT)) {
                    return 1;
                }
                return -1;
            }
            if (ship1.getParentStation() != null && ship1.getParentStation() == ship2.getParentStation()) {
                if (ship1.getHullSpec().getHints().contains(ShipHullSpecAPI.ShipTypeHints.UNDER_PARENT) && !ship2.getHullSpec().getHints().contains(ShipHullSpecAPI.ShipTypeHints.UNDER_PARENT)) {
                    return -1;
                }
                if (!ship1.getHullSpec().getHints().contains(ShipHullSpecAPI.ShipTypeHints.UNDER_PARENT) && ship2.getHullSpec().getHints().contains(ShipHullSpecAPI.ShipTypeHints.UNDER_PARENT)) {
                    return 1;
                }
                List children = ship1.getParentStation().getChildModulesCopy();
                return Integer.compare(children.indexOf(ship1), children.indexOf(ship2));
            }
            return ship1.getHullSpec().getHullId().compareTo(ship2.getHullSpec().getHullId());
        }
    };
    private static final Comparator<ShaderAPI> LOAD_ORDER = new Comparator<ShaderAPI>(){

        @Override
        public int compare(ShaderAPI shader1, ShaderAPI shader2) {
            int ro2;
            int ro1;
            if (null == shader1.getRenderOrder()) {
                ro1 = 3;
            } else {
                switch (shader1.getRenderOrder()) {
                    case OBJECT_SPACE: {
                        ro1 = 0;
                        break;
                    }
                    case WORLD_SPACE: {
                        ro1 = 1;
                        break;
                    }
                    case DISTORTED_SPACE: {
                        ro1 = 2;
                        break;
                    }
                    default: {
                        ro1 = 3;
                    }
                }
            }
            if (null == shader2.getRenderOrder()) {
                ro2 = 3;
            } else {
                switch (shader2.getRenderOrder()) {
                    case OBJECT_SPACE: {
                        ro2 = 0;
                        break;
                    }
                    case WORLD_SPACE: {
                        ro2 = 1;
                        break;
                    }
                    case DISTORTED_SPACE: {
                        ro2 = 2;
                        break;
                    }
                    default: {
                        ro2 = 3;
                    }
                }
            }
            if (ro1 < ro2) {
                return -1;
            }
            if (ro2 < ro1) {
                return 1;
            }
            return 0;
        }
    };
    private static int RTTSizeX = 2048;
    private static int RTTSizeY = 2048;
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private static boolean auxiliaryBuffer64Bit = false;
    private static int auxiliaryBufferId;
    private static int auxiliaryBufferTex;
    private static boolean buffersAllowed;
    private static int displayHeight;
    private static int displayWidth;
    private static int foregroundBufferId;
    private static int foregroundBufferTex;
    private static boolean isFirstFrame;
    private static boolean isForegroundEmpty;
    private static boolean isForegroundRendered;
    private static int screenTex;
    private static final List<ShaderAPI> shaders;
    private static boolean shadersAllowed;
    private static float squareTrans;
    private static double texCXRatio;
    private static double texCYRatio;
    private static boolean useFramebufferARB;
    private static boolean useFramebufferCore;
    private static boolean useFramebufferEXT;
    static boolean enabled;
    static boolean extraClear;
    static boolean initialized;
    static int reloadKey;
    static int toggleKey;

    public static void addShaderAPI(ShaderAPI shader) {
        for (ShaderAPI sdr : shaders) {
            if (!sdr.getClass().equals(shader.getClass())) continue;
            return;
        }
        shaders.add(shader);
    }

    public static boolean areBuffersAllowed() {
        return buffersAllowed;
    }

    public static boolean areShadersAllowed() {
        return shadersAllowed;
    }

    public static void beginDraw(int shader) {
        GL20.glUseProgram((int)shader);
        GL11.glPushAttrib((int)1048575);
        GL11.glViewport((int)0, (int)0, (int)((int)(Global.getSettings().getScreenWidth() * Display.getPixelScaleFactor())), (int)((int)(Global.getSettings().getScreenHeight() * Display.getPixelScaleFactor())));
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)displayWidth, (double)0.0, (double)displayHeight, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glEnable((int)3553);
    }

    public static float clampAngle(float degrees) {
        float degreesPredicate = degrees % 360.0f;
        if (degreesPredicate > 180.0f) {
            degreesPredicate -= 360.0f;
        } else if (degreesPredicate < -180.0f) {
            degreesPredicate += 360.0f;
        }
        return degreesPredicate;
    }

    public static void copyScreen(int texture, int textureUnit) {
        GL13.glActiveTexture((int)textureUnit);
        GL11.glBindTexture((int)3553, (int)texture);
        if (isFirstFrame) {
            GL11.glCopyTexImage2D((int)3553, (int)0, (int)6408, (int)0, (int)0, (int)RTTSizeX, (int)RTTSizeY, (int)0);
            isFirstFrame = false;
        } else {
            GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)RTTSizeX, (int)RTTSizeY);
        }
    }

    public static void drawScreenQuad(float scale) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)0.0, (double)(1.0 - texCYRatio));
        GL11.glVertex2d((double)0.0, (double)((float)displayHeight * scale));
        GL11.glTexCoord2d((double)(1.0 - texCXRatio), (double)(1.0 - texCYRatio));
        GL11.glVertex2d((double)((float)displayWidth * scale), (double)((float)displayHeight * scale));
        GL11.glTexCoord2d((double)(1.0 - texCXRatio), (double)0.0);
        GL11.glVertex2d((double)((float)displayWidth * scale), (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glEnd();
    }

    public static void exitDraw() {
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5890);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)screenTex);
        GL20.glUseProgram((int)0);
    }

    public static double fastCos(double radians) {
        return ShaderLib.fastSin(radians + 1.5707963267948966);
    }

    public static double fastSin(double radians) {
        double radiansPredicate = ShaderLib.reduceSinAngle(radians);
        if (Math.abs(radiansPredicate) <= 0.7853981633974483) {
            return Math.sin(radiansPredicate);
        }
        return Math.cos(1.5707963267948966 - radiansPredicate);
    }

    public static int getAuxiliaryBufferId() {
        if (buffersAllowed) {
            return auxiliaryBufferId;
        }
        return 0;
    }

    public static int getAuxiliaryBufferTexture() {
        if (buffersAllowed) {
            return auxiliaryBufferTex;
        }
        return 0;
    }

    public static int getForegroundTexture(ViewportAPI viewport) {
        if (Global.getCombatEngine() == null) {
            return 0;
        }
        if (!isForegroundRendered) {
            ShaderLib.renderForeground(viewport);
        }
        return foregroundBufferTex;
    }

    public static int getInternalHeight() {
        return RTTSizeY;
    }

    public static int getInternalWidth() {
        return RTTSizeX;
    }

    public static String getProgramLogInfo(int obj) {
        return GL20.glGetProgramInfoLog((int)obj, (int)GL20.glGetProgrami((int)obj, (int)35716));
    }

    public static int getScreenTexture() {
        return screenTex;
    }

    public static ShaderAPI getShaderAPI(Class<? extends ShaderAPI> shaderAPI) {
        for (ShaderAPI sdr : shaders) {
            if (!sdr.getClass().equals(shaderAPI)) continue;
            return sdr;
        }
        return null;
    }

    public static List<ShaderAPI> getShaderAPIsCopy() {
        Collections.sort(shaders, LOAD_ORDER);
        return Collections.unmodifiableList(shaders);
    }

    public static String getShaderLogInfo(int obj) {
        return GL20.glGetShaderInfoLog((int)obj, (int)GL20.glGetShaderi((int)obj, (int)35716));
    }

    public static float getSquareTransform() {
        return squareTrans;
    }

    public static Vector2f getTextureDataNormalization(float minValue, float maxValue) {
        Vector2f tempVec = new Vector2f(0.01f, 0.0f);
        if (Math.abs(maxValue - minValue) >= 0.01f) {
            tempVec.x = maxValue - minValue;
        }
        tempVec.y = minValue;
        return tempVec;
    }

    public static float getVisibleU() {
        return 1.0f - (float)texCXRatio;
    }

    public static float getVisibleV() {
        return 1.0f - (float)texCYRatio;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        Global.getLogger(ShaderLib.class).setLevel(Level.ERROR);
        displayWidth = (int)Global.getSettings().getScreenWidth();
        if (displayWidth <= 1024) {
            RTTSizeX = 1024;
        } else if (displayWidth <= 2048) {
            RTTSizeX = 2048;
        } else if (displayWidth <= 4096) {
            RTTSizeX = 4096;
        } else if (displayWidth <= 8192) {
            RTTSizeX = 8192;
        } else if (displayWidth <= 16384) {
            RTTSizeX = 16384;
        } else if (displayWidth <= 32768) {
            RTTSizeX = 32768;
        }
        texCXRatio = (double)(RTTSizeX - displayWidth) / (double)RTTSizeX;
        displayHeight = (int)Global.getSettings().getScreenHeight();
        if (displayHeight <= 1024) {
            RTTSizeY = 1024;
        } else if (displayHeight <= 2048) {
            RTTSizeY = 2048;
        } else if (displayHeight <= 4096) {
            RTTSizeY = 4096;
        } else if (displayHeight <= 8192) {
            RTTSizeY = 8192;
        } else if (displayHeight <= 16384) {
            RTTSizeY = 16384;
        } else if (displayHeight <= 32768) {
            RTTSizeY = 32768;
        }
        texCYRatio = (double)(RTTSizeY - displayHeight) / (double)RTTSizeY;
        squareTrans = (float)RTTSizeX / (float)RTTSizeY;
        if (GLContext.getCapabilities().GL_EXT_framebuffer_object || GLContext.getCapabilities().OpenGL30 || GLContext.getCapabilities().GL_ARB_framebuffer_object) {
            if (GLContext.getCapabilities().OpenGL30) {
                useFramebufferCore = true;
            } else if (GLContext.getCapabilities().GL_ARB_framebuffer_object) {
                useFramebufferARB = true;
            } else {
                useFramebufferEXT = true;
            }
            buffersAllowed = true;
        } else {
            buffersAllowed = false;
            Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)"GPU does not support Framebuffer Objects! Some shaders disabled!");
        }
        if (GLContext.getCapabilities().OpenGL20) {
            shadersAllowed = true;
        } else {
            shadersAllowed = false;
            Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)"GPU does not support OpenGL 2.0! Shaders disabled!");
        }
        try {
            ShaderLib.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)("Failed to load shader settings: " + e.getMessage()));
            enabled = false;
            return;
        }
        if (shadersAllowed) {
            screenTex = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)screenTex);
            GL11.glTexImage2D((int)3553, (int)0, (int)32849, (int)RTTSizeX, (int)RTTSizeY, (int)0, (int)6407, (int)5121, (ByteBuffer)null);
            if (useFramebufferEXT) {
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            } else if (useFramebufferARB) {
                ARBFramebufferObject.glGenerateMipmap((int)3553);
            } else {
                GL30.glGenerateMipmap((int)3553);
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        if (buffersAllowed && shadersAllowed) {
            foregroundBufferTex = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)foregroundBufferTex);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)RTTSizeX, (int)RTTSizeY, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            if (useFramebufferEXT) {
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            } else if (useFramebufferARB) {
                ARBFramebufferObject.glGenerateMipmap((int)3553);
            } else {
                GL30.glGenerateMipmap((int)3553);
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            foregroundBufferId = useFramebufferCore ? ShaderLib.makeFramebuffer(36064, foregroundBufferTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0) : (useFramebufferARB ? ShaderLib.makeFramebuffer(36064, foregroundBufferTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0) : ShaderLib.makeFramebuffer(36064, foregroundBufferTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0));
            if (foregroundBufferId == 0) {
                buffersAllowed = false;
                Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)"Foreground framebuffer object error!  ShaderLib features disabled!");
            }
            auxiliaryBufferTex = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)auxiliaryBufferTex);
            if (auxiliaryBuffer64Bit) {
                GL11.glTexImage2D((int)3553, (int)0, (int)32859, (int)ShaderLib.getInternalWidth(), (int)ShaderLib.getInternalHeight(), (int)0, (int)6408, (int)5123, (ByteBuffer)null);
            } else {
                GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)ShaderLib.getInternalWidth(), (int)ShaderLib.getInternalHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            }
            if (useFramebufferEXT) {
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            } else if (useFramebufferARB) {
                ARBFramebufferObject.glGenerateMipmap((int)3553);
            } else {
                GL30.glGenerateMipmap((int)3553);
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            auxiliaryBufferId = useFramebufferCore ? ShaderLib.makeFramebuffer(36064, auxiliaryBufferTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0) : (useFramebufferARB ? ShaderLib.makeFramebuffer(36064, auxiliaryBufferTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0) : ShaderLib.makeFramebuffer(36064, auxiliaryBufferTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0));
            if (auxiliaryBufferId == 0) {
                buffersAllowed = false;
                Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)"Auxiliary framebuffer object error!  ShaderLib features disabled!");
            }
        }
        initialized = true;
    }

    public static boolean isForegroundEmpty(ViewportAPI viewport) {
        if (Global.getCombatEngine() == null) {
            return true;
        }
        if (!isForegroundRendered) {
            ShaderLib.renderForeground(viewport);
        }
        return isForegroundEmpty;
    }

    public static boolean isOnScreen(Vector2f worldCoords, float radius) {
        return Global.getCombatEngine().getViewport().isNearViewport(worldCoords, radius);
    }

    public static boolean isOnScreen(Vector2f worldCoords1, Vector2f worldCoords2, float radius) {
        float sideU;
        if (Global.getCombatEngine().getViewport().isNearViewport(worldCoords1, radius)) {
            return true;
        }
        if (Global.getCombatEngine().getViewport().isNearViewport(worldCoords2, radius)) {
            return true;
        }
        ViewportAPI viewport = Global.getCombatEngine().getViewport();
        float sideL = viewport.getLLX() - radius;
        float sideR = viewport.getLLX() + viewport.getVisibleWidth() + radius;
        float sideB = viewport.getLLY() - radius;
        if (ShaderLib.lineIntersect(worldCoords1, worldCoords2, sideL, sideB, sideL, sideU = viewport.getLLY() + viewport.getVisibleHeight() + radius)) {
            return true;
        }
        if (ShaderLib.lineIntersect(worldCoords1, worldCoords2, sideL, sideU, sideR, sideU)) {
            return true;
        }
        if (ShaderLib.lineIntersect(worldCoords1, worldCoords2, sideR, sideU, sideR, sideB)) {
            return true;
        }
        return ShaderLib.lineIntersect(worldCoords1, worldCoords2, sideR, sideB, sideL, sideB);
    }

    public static int loadShader(String vert, String frag) {
        int fragShader;
        int vertShader;
        try {
            vertShader = ShaderLib.createShader(vert, 35633);
            fragShader = ShaderLib.createShader(frag, 35632);
        }
        catch (RuntimeException exc) {
            Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)exc.getMessage());
            return 0;
        }
        if (vertShader == 0 || fragShader == 0) {
            return 0;
        }
        int prog = GL20.glCreateProgram();
        if (prog == 0) {
            return 0;
        }
        GL20.glAttachShader((int)prog, (int)vertShader);
        GL20.glAttachShader((int)prog, (int)fragShader);
        GL20.glLinkProgram((int)prog);
        if (GL20.glGetProgrami((int)prog, (int)35714) == 0) {
            Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(prog));
            GL20.glDeleteProgram((int)prog);
            GL20.glDeleteShader((int)vertShader);
            GL20.glDeleteShader((int)fragShader);
            return 0;
        }
        return prog;
    }

    public static int makeFramebuffer(int attachment, int texture, int texWidth, int texHeight, int mipLevel) {
        if (useFramebufferCore) {
            int rbStencilId = GL30.glGenRenderbuffers();
            GL30.glBindRenderbuffer((int)36161, (int)rbStencilId);
            GL30.glRenderbufferStorage((int)36161, (int)36168, (int)texWidth, (int)texHeight);
            GL30.glBindRenderbuffer((int)36161, (int)0);
            int bufferId = GL30.glGenFramebuffers();
            GL30.glBindFramebuffer((int)36160, (int)bufferId);
            GL30.glFramebufferTexture2D((int)36160, (int)attachment, (int)3553, (int)texture, (int)mipLevel);
            GL30.glFramebufferRenderbuffer((int)36160, (int)36128, (int)36161, (int)rbStencilId);
            int status = GL30.glCheckFramebufferStatus((int)36160);
            if (status != 36053) {
                Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)("Couldn't make framebuffer! Error: " + status));
                return 0;
            }
            GL30.glBindFramebuffer((int)36160, (int)0);
            return bufferId;
        }
        if (useFramebufferARB) {
            int rbStencilId = ARBFramebufferObject.glGenRenderbuffers();
            ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)rbStencilId);
            ARBFramebufferObject.glRenderbufferStorage((int)36161, (int)36168, (int)texWidth, (int)texHeight);
            ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)0);
            int bufferId = ARBFramebufferObject.glGenFramebuffers();
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)bufferId);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)attachment, (int)3553, (int)texture, (int)mipLevel);
            ARBFramebufferObject.glFramebufferRenderbuffer((int)36160, (int)36128, (int)36161, (int)rbStencilId);
            int status = ARBFramebufferObject.glCheckFramebufferStatus((int)36160);
            if (status != 36053) {
                Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)("Couldn't make framebuffer! Error: " + status));
                return 0;
            }
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
            return bufferId;
        }
        int rbStencilId = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)rbStencilId);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)36168, (int)texWidth, (int)texHeight);
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)0);
        int bufferId = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)bufferId);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)attachment, (int)3553, (int)texture, (int)mipLevel);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36128, (int)36161, (int)rbStencilId);
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)("Couldn't make framebuffer! Error: " + status));
            return 0;
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        return bufferId;
    }

    public static void screenDraw(int texture, int textureUnit) {
        ShaderLib.copyScreen(texture, textureUnit);
        if (extraClear) {
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClear((int)16384);
        }
        ShaderLib.drawScreenQuad(1.0f);
    }

    public static Vector2f transformScreenToUV(Vector2f screenCoords) {
        Vector2f tempVec = new Vector2f();
        tempVec.x = screenCoords.x / (float)RTTSizeX;
        tempVec.y = screenCoords.y / (float)RTTSizeY;
        return tempVec;
    }

    public static Vector2f transformWorldToScreen(Vector2f worldCoords) {
        Vector2f tempVec = new Vector2f();
        tempVec.x = Global.getCombatEngine().getViewport().convertWorldXtoScreenX(worldCoords.x);
        tempVec.y = Global.getCombatEngine().getViewport().convertWorldYtoScreenY(worldCoords.y);
        return tempVec;
    }

    public static float unitsToUV(float units) {
        return units / ((float)RTTSizeY * Global.getCombatEngine().getViewport().getViewMult());
    }

    public static boolean useBufferARB() {
        return useFramebufferARB;
    }

    public static boolean useBufferCore() {
        return useFramebufferCore;
    }

    public static boolean useBufferEXT() {
        return useFramebufferEXT;
    }

    private static int createShader(String source, int shaderType) throws RuntimeException {
        int shader = 0;
        try {
            shader = GL20.glCreateShader((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            GL20.glShaderSource((int)shader, (CharSequence)source);
            GL20.glCompileShader((int)shader);
            if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderLib.getShaderLogInfo(shader));
            }
            return shader;
        }
        catch (RuntimeException exc) {
            GL20.glDeleteShader((int)shader);
            throw exc;
        }
    }

    private static boolean equals(float a, float b) {
        return a == b || a >= b * 0.9999999f && a <= b * 1.0000001f;
    }

    private static boolean lineIntersect(Vector2f start1, Vector2f end1, float start2x, float start2y, float end2x, float end2y) {
        if (Line2D.Float.ptSegDistSq(start2x, start2y, end2x, end2y, end1.x, end1.y) <= (double)0.11111f) {
            return true;
        }
        if (Line2D.Float.ptSegDistSq(start2x, start2y, end2x, end2y, start1.x, start1.y) <= (double)0.11111f) {
            return true;
        }
        float denom = (end1.x - start1.x) * (end2y - start2y) - (end1.y - start1.y) * (end2x - start2x);
        if (ShaderLib.equals(0.0f, denom)) {
            return false;
        }
        float numer = (start1.y - start2y) * (end2x - start2x) - (start1.x - start2x) * (end2y - start2y);
        float r = numer / denom;
        float numer2 = (start1.y - start2y) * (end1.x - start1.x) - (start1.x - start2x) * (end1.y - start1.y);
        float s = numer2 / denom;
        return !(r < 0.0f || r > 1.0f || s < 0.0f || s > 1.0f);
    }

    private static void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        enabled = settings.getBoolean("enableShaders");
        toggleKey = settings.getInt("toggleKey");
        reloadKey = settings.getInt("reloadKey");
        auxiliaryBuffer64Bit = settings.getBoolean("use64BitBuffer");
        extraClear = settings.getBoolean("extraScreenClear");
        if (!enabled) {
            shadersAllowed = false;
            buffersAllowed = false;
        }
    }

    private static double reduceSinAngle(double radians) {
        double radiansPredicate = radians % Math.PI * 2.0;
        if (Math.abs(radiansPredicate) > Math.PI) {
            radiansPredicate -= Math.PI * 2;
        }
        if (Math.abs(radiansPredicate) > 1.5707963267948966) {
            radiansPredicate = Math.PI - radiansPredicate;
        }
        return radiansPredicate;
    }

    public static TextureEntry getShipTexture(ShipAPI ship, TextureData.TextureDataType type) {
        String ovdId;
        Map shipTexOvd;
        Map customData;
        TextureEntry entry = null;
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine != null && (customData = engine.getCustomData()) != null && (shipTexOvd = (Map)customData.get("SL_shipTexOvd")) != null && (ovdId = (String)shipTexOvd.get(ship)) != null) {
            entry = TextureData.getTextureData(ovdId, type, TextureData.ObjectType.SHIP, 0);
        }
        if (entry == null && (entry = TextureData.getTextureData(ship.getHullSpec().getHullId(), type, TextureData.ObjectType.SHIP, 0)) == null && (entry = TextureData.getTextureData(ship.getHullSpec().getDParentHullId(), type, TextureData.ObjectType.SHIP, 0)) == null) {
            entry = TextureData.getTextureData(ship.getHullSpec().getBaseHullId(), type, TextureData.ObjectType.SHIP, 0);
        }
        return entry;
    }

    public static void overrideShipTexture(ShipAPI ship, String id) {
        Map customData;
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine != null && (customData = engine.getCustomData()) != null) {
            WeakHashMap<ShipAPI, String> shipTexOvd = (WeakHashMap<ShipAPI, String>)customData.get("SL_shipTexOvd");
            if (shipTexOvd == null) {
                shipTexOvd = new WeakHashMap<ShipAPI, String>();
                customData.put("SL_shipTexOvd", shipTexOvd);
            }
            shipTexOvd.put(ship, id);
        }
    }

    private static void renderForeground(ViewportAPI viewport) {
        SpriteAPI sprite;
        GL11.glPushAttrib((int)1048575);
        if (useFramebufferCore) {
            GL30.glBindFramebuffer((int)36160, (int)foregroundBufferId);
        } else if (useFramebufferARB) {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)foregroundBufferId);
        } else {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)foregroundBufferId);
        }
        GL11.glViewport((int)0, (int)0, (int)((int)(Global.getSettings().getScreenWidth() * Display.getPixelScaleFactor())), (int)((int)(Global.getSettings().getScreenHeight() * Display.getPixelScaleFactor())));
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)viewport.getLLX(), (double)(viewport.getLLX() + viewport.getVisibleWidth()), (double)viewport.getLLY(), (double)(viewport.getLLY() + viewport.getVisibleHeight()), (double)-2000.0, (double)2000.0);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glClear((int)16384);
        int objectCount = 0;
        List asteroids = Global.getCombatEngine().getAsteroids();
        int size = asteroids.size();
        for (int i = 0; i < size; ++i) {
            TextureEntry entry;
            CombatEntityAPI asteroid = (CombatEntityAPI)asteroids.get(i);
            Vector2f asteroidLocation = asteroid.getLocation();
            if (!ShaderLib.isOnScreen(asteroidLocation, 100.0f)) continue;
            CombatAsteroidAPI assteroid = (CombatAsteroidAPI)asteroid;
            SpriteAPI asteroidSprite = assteroid.getSpriteAPI();
            String asteroidType = ShaderModPlugin.ASTEROID_MAP.get(asteroidSprite.getTextureId());
            if (asteroidType == null) {
                asteroidType = "nil";
            }
            if ((entry = TextureData.getTextureData(asteroidType, TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.ASTEROID, 0)) != null) {
                sprite = entry.sprite;
                sprite.setAngle(asteroidSprite.getAngle());
                sprite.setSize(asteroidSprite.getWidth(), asteroidSprite.getHeight());
                sprite.setCenter(asteroidSprite.getCenterX(), asteroidSprite.getCenterY());
                sprite.setAlphaMult(asteroidSprite.getAlphaMult());
            } else {
                sprite = asteroidSprite;
            }
            sprite.renderAtCenter(asteroidLocation.x, asteroidLocation.y);
            ++objectCount;
        }
        List ships = Global.getCombatEngine().getShips();
        Collections.sort(ships, SHIP_DRAW_ORDER);
        size = ships.size();
        for (int i = 0; i < size; ++i) {
            int j;
            SpriteAPI sprite2;
            ShipAPI ship = (ShipAPI)ships.get(i);
            Vector2f shipLocation = ship.getLocation();
            if (!ShaderLib.isOnScreen(shipLocation, 1.25f * ship.getCollisionRadius())) continue;
            TextureEntry entry = ShaderLib.getShipTexture(ship, TextureData.TextureDataType.MATERIAL_MAP);
            SpriteAPI originalSprite = ship.getSpriteAPI();
            if (entry != null) {
                sprite2 = entry.sprite;
                sprite2.setAngle(originalSprite.getAngle());
                sprite2.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                sprite2.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                sprite2.setAlphaMult(ship.getCombinedAlphaMult());
                sprite2.setColor(originalSprite.getColor());
            } else {
                sprite2 = originalSprite;
            }
            BoundsAPI bounds = ship.getVisualBounds();
            if (bounds != null) {
                bounds.update(ship.getLocation(), ship.getFacing());
                GL11.glEnable((int)2960);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3553);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glStencilFunc((int)519, (int)16, (int)255);
                GL11.glStencilOp((int)7680, (int)7680, (int)7681);
                GL11.glStencilMask((int)255);
                GL11.glClearStencil((int)0);
                GL11.glClear((int)1024);
                Tessellate.render(bounds, 1.0f, 1.0f, 1.0f, ship.getId());
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glStencilFunc((int)514, (int)16, (int)255);
                GL11.glStencilOp((int)7680, (int)7680, (int)7680);
                GL11.glStencilMask((int)0);
                sprite2.setBlendFunc(770, 771);
                sprite2.renderAtCenter(shipLocation.x, shipLocation.y);
                GL11.glDisable((int)2960);
                GL11.glStencilFunc((int)519, (int)0, (int)255);
            } else {
                sprite2.renderAtCenter(shipLocation.x, shipLocation.y);
            }
            Vector2f renderOffset = VectorUtils.rotate((Vector2f)ship.getRenderOffset(), (float)ship.getFacing(), (Vector2f)new Vector2f());
            List weapons = ship.getAllWeapons();
            List emptySlots = ship.getHullSpec().getAllWeaponSlotsCopy();
            int weaponSize = weapons.size();
            block6: for (j = 0; j < weaponSize; ++j) {
                WeaponAPI weapon = (WeaponAPI)weapons.get(j);
                if (emptySlots.remove(weapon.getSlot())) continue;
                Iterator iter = emptySlots.iterator();
                while (iter.hasNext()) {
                    Vector2f weaponLocation;
                    WeaponSlotAPI slot = (WeaponSlotAPI)iter.next();
                    Vector2f slotLocation = Vector2f.add((Vector2f)slot.computePosition((CombatEntityAPI)ship), (Vector2f)renderOffset, (Vector2f)new Vector2f());
                    if (!(MathUtils.getDistance((Vector2f)slotLocation, (Vector2f)(weaponLocation = Vector2f.add((Vector2f)weapon.getLocation(), (Vector2f)renderOffset, (Vector2f)new Vector2f()))) <= 1.0f)) continue;
                    iter.remove();
                    continue block6;
                }
            }
            if (bounds == null) {
                int slotSize = emptySlots.size();
                for (int j2 = 0; j2 < slotSize; ++j2) {
                    WeaponSlotAPI slot = (WeaponSlotAPI)emptySlots.get(j2);
                    if (slot.isDecorative() || slot.isHidden() || slot.isSystemSlot() || slot.getWeaponType() == WeaponAPI.WeaponType.LAUNCH_BAY || slot.isStationModule() || slot.isBuiltIn()) continue;
                    Vector2f slotLocation = Vector2f.add((Vector2f)slot.computePosition((CombatEntityAPI)ship), (Vector2f)renderOffset, (Vector2f)new Vector2f());
                    switch (slot.getSlotSize()) {
                        default: {
                            if (slot.isHardpoint()) {
                                entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT_COVER_SMALL, 0);
                                originalSprite = ship.getSmallHardpointCover();
                                break;
                            }
                            entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET_COVER_SMALL, 0);
                            originalSprite = ship.getSmallTurretCover();
                            break;
                        }
                        case MEDIUM: {
                            if (slot.isHardpoint()) {
                                entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT_COVER_MEDIUM, 0);
                                originalSprite = ship.getMediumHardpointCover();
                                break;
                            }
                            entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET_COVER_MEDIUM, 0);
                            originalSprite = ship.getMediumTurretCover();
                            break;
                        }
                        case LARGE: {
                            if (slot.isHardpoint()) {
                                entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT_COVER_LARGE, 0);
                                originalSprite = ship.getLargeHardpointCover();
                                break;
                            }
                            entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET_COVER_LARGE, 0);
                            originalSprite = ship.getLargeTurretCover();
                        }
                    }
                    if (originalSprite == null || originalSprite.getTextureId() == 0) continue;
                    if (entry != null) {
                        sprite2 = entry.sprite;
                        sprite2.setAngle(slot.getAngle() + ship.getFacing() - 90.0f);
                        sprite2.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite2.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite2.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        sprite2.setColor(originalSprite.getColor());
                    } else {
                        sprite2 = originalSprite;
                        sprite2.setAngle(slot.getAngle() + ship.getFacing() - 90.0f);
                    }
                    sprite2.renderAtCenter(slotLocation.x, slotLocation.y);
                }
            }
            for (j = 0; j < weaponSize; ++j) {
                WeaponAPI weapon = (WeaponAPI)weapons.get(j);
                if (weapon.getSlot().isHidden()) continue;
                Vector2f weaponLocation = Vector2f.add((Vector2f)weapon.getLocation(), (Vector2f)renderOffset, (Vector2f)new Vector2f());
                if (weapon.getUnderSpriteAPI() != null) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT_UNDER, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT_UNDER, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET_UNDER, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET_UNDER, 0));
                    originalSprite = weapon.getUnderSpriteAPI();
                    if (entry != null) {
                        sprite2 = entry.sprite;
                        sprite2.setAngle(originalSprite.getAngle());
                        sprite2.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite2.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite2.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        sprite2.setColor(originalSprite.getColor());
                    } else {
                        sprite2 = originalSprite;
                    }
                    sprite2.renderAtCenter(weaponLocation.x, weaponLocation.y);
                }
                if (weapon.getBarrelSpriteAPI() != null && weapon.isRenderBarrelBelow()) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT_BARREL, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET_BARREL, 0));
                    originalSprite = weapon.getBarrelSpriteAPI();
                    if (entry != null) {
                        sprite2 = entry.sprite;
                        sprite2.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite2.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite2.setColor(originalSprite.getColor());
                    } else {
                        sprite2 = originalSprite;
                    }
                    weapon.renderBarrel(sprite2, weaponLocation, Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                }
                if (weapon.getSprite() != null) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET, 0));
                    originalSprite = weapon.getSprite();
                    if (entry != null) {
                        sprite2 = entry.sprite;
                        sprite2.setAngle(originalSprite.getAngle());
                        sprite2.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite2.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite2.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        sprite2.setColor(originalSprite.getColor());
                    } else {
                        sprite2 = originalSprite;
                    }
                    sprite2.renderAtCenter(weaponLocation.x, weaponLocation.y);
                }
                if (weapon.getBarrelSpriteAPI() != null && !weapon.isRenderBarrelBelow()) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.HARDPOINT_BARREL, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.TURRET_BARREL, 0));
                    originalSprite = weapon.getBarrelSpriteAPI();
                    if (entry != null) {
                        sprite2 = entry.sprite;
                        sprite2.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite2.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite2.setColor(originalSprite.getColor());
                    } else {
                        sprite2 = originalSprite;
                    }
                    weapon.renderBarrel(sprite2, weaponLocation, Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                }
                if (weapon.getMissileRenderData() == null || weapon.getMissileRenderData().isEmpty() || weapon.usesAmmo() && weapon.getAmmo() <= 0) continue;
                List msls = weapon.getMissileRenderData();
                int mslSize = msls.size();
                for (int k = 0; k < mslSize; ++k) {
                    MissileRenderDataAPI msl = (MissileRenderDataAPI)msls.get(k);
                    if (msl.getMissileSpecId() == null) continue;
                    Vector2f missileLocation = msl.getMissileCenterLocation();
                    entry = TextureData.getTextureData(msl.getMissileSpecId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.MISSILE, 0);
                    originalSprite = msl.getSprite();
                    if (entry != null) {
                        sprite2 = entry.sprite;
                        sprite2.setAngle(msl.getMissileFacing() - 90.0f);
                        sprite2.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite2.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite2.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()) * msl.getBrightness());
                        sprite2.setColor(originalSprite.getColor());
                    } else {
                        sprite2 = originalSprite;
                    }
                    sprite2.renderAtCenter(missileLocation.x + renderOffset.x, missileLocation.y + renderOffset.y);
                }
            }
            ++objectCount;
        }
        List missiles = Global.getCombatEngine().getMissiles();
        size = missiles.size();
        for (int i = 0; i < size; ++i) {
            MissileAPI missile = (MissileAPI)missiles.get(i);
            Vector2f shipLocation = missile.getLocation();
            if (!ShaderLib.isOnScreen(shipLocation, 1.25f * missile.getCollisionRadius()) || missile.getProjectileSpecId() == null) continue;
            TextureEntry entry = TextureData.getTextureData(missile.getProjectileSpecId(), TextureData.TextureDataType.MATERIAL_MAP, TextureData.ObjectType.MISSILE, 0);
            SpriteAPI originalSprite = missile.getSpriteAPI();
            if (entry != null) {
                sprite = entry.sprite;
                sprite.setAngle(originalSprite.getAngle());
                sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                sprite.setAlphaMult(originalSprite.getAlphaMult());
                sprite.setColor(originalSprite.getColor());
            } else {
                sprite = originalSprite;
            }
            sprite.renderAtCenter(shipLocation.x, shipLocation.y);
            ++objectCount;
        }
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5890);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        if (useFramebufferCore) {
            GL30.glBindFramebuffer((int)36160, (int)0);
        } else if (useFramebufferARB) {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        } else {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        }
        GL11.glPopAttrib();
        GL11.glViewport((int)0, (int)0, (int)((int)(Global.getSettings().getScreenWidth() * Display.getPixelScaleFactor())), (int)((int)(Global.getSettings().getScreenHeight() * Display.getPixelScaleFactor())));
        isForegroundEmpty = objectCount <= 0;
        isForegroundRendered = true;
    }

    static List<ShaderAPI> getShaderAPIs() {
        Collections.sort(shaders, LOAD_ORDER);
        return shaders;
    }

    static void unsetForegroundRendered() {
        isForegroundRendered = false;
        isForegroundEmpty = true;
    }

    static {
        buffersAllowed = false;
        displayHeight = 1080;
        displayWidth = 1920;
        isFirstFrame = true;
        isForegroundEmpty = true;
        isForegroundRendered = false;
        shaders = new ArrayList<ShaderAPI>(10);
        shadersAllowed = false;
        squareTrans = 1.0f;
        texCXRatio = 0.0625;
        texCYRatio = 0.47265625;
        useFramebufferARB = false;
        useFramebufferCore = false;
        useFramebufferEXT = false;
        enabled = false;
        extraClear = false;
        initialized = false;
    }
}

