/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.util.ShaderAPI;
import org.dark.shaders.util.ShaderLib;

public final class ShaderHook
implements EveryFrameCombatPlugin {
    public static boolean enableShaders = true;
    private CombatEngineAPI engine;

    public void advance(float amount, List<InputEventAPI> events) {
        if (!ShaderLib.initialized) {
            return;
        }
        if (this.engine == null) {
            return;
        }
        if (!ShaderLib.enabled) {
            return;
        }
        for (InputEventAPI event : events) {
            if (event.isConsumed()) continue;
            if (event.isKeyDownEvent() && event.getEventValue() == ShaderLib.toggleKey) {
                enableShaders = !enableShaders;
                event.consume();
                break;
            }
            if (!event.isKeyDownEvent() || event.getEventValue() != ShaderLib.reloadKey) continue;
            List<ShaderAPI> shaders = ShaderLib.getShaderAPIs();
            ArrayList<ShaderAPI> newShaders = new ArrayList<ShaderAPI>(shaders.size());
            for (ShaderAPI shader : shaders) {
                shader.destroy();
                try {
                    ShaderAPI sdr = (ShaderAPI)Global.getSettings().getScriptClassLoader().loadClass(shader.getClass().getName()).newInstance();
                    newShaders.add(sdr);
                    sdr.initCombat();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)("Reload Error! " + ex));
                }
            }
            shaders.clear();
            for (ShaderAPI shader : newShaders) {
                shaders.add(shader);
            }
            event.consume();
            return;
        }
        ShaderLib.unsetForegroundRendered();
        List<ShaderAPI> shaders = ShaderLib.getShaderAPIs();
        for (ShaderAPI shader : shaders) {
            shader.advance(amount, events);
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        List<ShaderAPI> shaders = ShaderLib.getShaderAPIs();
        for (ShaderAPI shader : shaders) {
            shader.initCombat();
        }
        if (engine != null) {
            engine.addLayeredRenderingPlugin((CombatLayeredRenderingPlugin)new ShaderCombatLayerHook());
        }
    }

    public void renderInUICoords(ViewportAPI viewport) {
        if (!ShaderLib.initialized) {
            return;
        }
        if (this.engine == null) {
            return;
        }
        if (!ShaderLib.enabled || !enableShaders) {
            return;
        }
        List<ShaderAPI> shaders = ShaderLib.getShaderAPIs();
        for (ShaderAPI shader : shaders) {
            if (!shader.isEnabled() || shader.isCombat()) continue;
            shader.renderInScreenCoords(viewport);
        }
    }

    public void renderInWorldCoords(ViewportAPI viewport) {
        if (!ShaderLib.initialized) {
            return;
        }
        if (this.engine == null) {
            return;
        }
        if (!ShaderLib.enabled || !enableShaders) {
            return;
        }
        List<ShaderAPI> shaders = ShaderLib.getShaderAPIs();
        for (ShaderAPI shader : shaders) {
            if (!shader.isEnabled() || shader.isCombat()) continue;
            shader.renderInWorldCoords(viewport);
        }
    }

    public void processInputPreCoreControls(float f, List<InputEventAPI> list) {
    }

    static class ShaderCombatLayerHook
    implements CombatLayeredRenderingPlugin {
        ShaderCombatLayerHook() {
        }

        public void init() {
        }

        public void cleanup() {
        }

        public boolean isExpired() {
            return false;
        }

        public void advance(float amount) {
        }

        public EnumSet<CombatEngineLayers> getActiveLayers() {
            return EnumSet.allOf(CombatEngineLayers.class);
        }

        public float getRenderRadius() {
            return 1.0E8f;
        }

        public void render(CombatEngineLayers layer, ViewportAPI viewport) {
            if (!ShaderLib.initialized) {
                return;
            }
            if (!ShaderLib.enabled || !enableShaders) {
                return;
            }
            List<ShaderAPI> shaders = ShaderLib.getShaderAPIs();
            for (ShaderAPI shader : shaders) {
                if (!shader.isEnabled() || !shader.isCombat() || !shader.getCombatLayer().equals((Object)layer)) continue;
                shader.renderInWorldCoords(viewport);
            }
        }
    }
}

