/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.post;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.util.ShaderAPI;
import org.dark.shaders.util.ShaderHook;
import org.dark.shaders.util.ShaderLib;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class PostProcessShader
implements ShaderAPI {
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private int colorBlindness = 0;
    private boolean enabled = false;
    private boolean validatedPost = false;
    private boolean validatedPre = false;
    protected final int[] indexPost = new int[18];
    protected final int[] indexPre = new int[18];
    protected int programPost = 0;
    protected int programPre = 0;

    public static void resetDefaults() {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            ((PostProcessShader)postShader).setDefaultSettings();
        }
    }

    public static void setBlueHSL(boolean post, float hue, float saturation, float lightness) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPost[11], (float)hue, (float)saturation, (float)lightness);
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPre[11], (float)hue, (float)saturation, (float)lightness);
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setContrast(boolean post, float amount) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPost[13], (float)amount);
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPre[13], (float)amount);
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setGreenHSL(boolean post, float hue, float saturation, float lightness) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPost[9], (float)hue, (float)saturation, (float)lightness);
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPre[9], (float)hue, (float)saturation, (float)lightness);
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setHueShift(boolean post, float degrees) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPost[2], (float)(degrees / 360.0f));
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPre[2], (float)(degrees / 360.0f));
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setLightness(boolean post, float amount) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPost[5], (float)amount);
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPre[5], (float)amount);
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setMagentaHSL(boolean post, float hue, float saturation, float lightness) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPost[12], (float)hue, (float)saturation, (float)lightness);
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPre[12], (float)hue, (float)saturation, (float)lightness);
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setNoise(boolean post, float amount) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPost[14], (float)amount);
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPre[14], (float)amount);
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setRedHSL(boolean post, float hue, float saturation, float lightness) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPost[7], (float)hue, (float)saturation, (float)lightness);
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPre[7], (float)hue, (float)saturation, (float)lightness);
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setSaturation(boolean post, float amount) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPost[3], (float)amount);
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPre[3], (float)amount);
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setScanLines(boolean post, float amount, int interval, int width) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPost[15], (float)amount);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPost[16], (float)((float)interval / (float)ShaderLib.getInternalHeight()));
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPost[17], (float)((float)width / (float)ShaderLib.getInternalHeight()));
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPre[15], (float)amount);
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPre[16], (float)((float)interval / (float)ShaderLib.getInternalHeight()));
                GL20.glUniform1f((int)((PostProcessShader)postShader).indexPre[17], (float)((float)width / (float)ShaderLib.getInternalHeight()));
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setTealHSL(boolean post, float hue, float saturation, float lightness) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPost[10], (float)hue, (float)saturation, (float)lightness);
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPre[10], (float)hue, (float)saturation, (float)lightness);
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void setYellowHSL(boolean post, float hue, float saturation, float lightness) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPost[8], (float)hue, (float)saturation, (float)lightness);
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform3f((int)((PostProcessShader)postShader).indexPre[8], (float)hue, (float)saturation, (float)lightness);
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void useExponentialDarkness(boolean post, boolean value) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform1i((int)((PostProcessShader)postShader).indexPost[6], (int)(value ? 1 : 0));
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform1i((int)((PostProcessShader)postShader).indexPre[6], (int)(value ? 1 : 0));
            }
            GL20.glUseProgram((int)0);
        }
    }

    public static void useExponentialDesaturation(boolean post, boolean value) {
        ShaderAPI postShader = ShaderLib.getShaderAPI(PostProcessShader.class);
        if (postShader instanceof PostProcessShader && postShader.isEnabled()) {
            if (post) {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPost);
                GL20.glUniform1i((int)((PostProcessShader)postShader).indexPost[4], (int)(value ? 1 : 0));
            } else {
                GL20.glUseProgram((int)((PostProcessShader)postShader).programPre);
                GL20.glUniform1i((int)((PostProcessShader)postShader).indexPre[4], (int)(value ? 1 : 0));
            }
            GL20.glUseProgram((int)0);
        }
    }

    public PostProcessShader() {
        String fragShader;
        String vertShader;
        if (!ShaderLib.areShadersAllowed() || !ShaderLib.areBuffersAllowed()) {
            this.enabled = false;
            return;
        }
        Global.getLogger(PostProcessShader.class).setLevel(Level.ERROR);
        try {
            this.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(PostProcessShader.class).log((Priority)Level.ERROR, (Object)("Failed to load shader settings: " + e.getMessage()));
            this.enabled = false;
            return;
        }
        if (!this.enabled) {
            return;
        }
        try {
            vertShader = Global.getSettings().loadText("data/shaders/post/pre.vert");
            fragShader = Global.getSettings().loadText("data/shaders/post/pre.frag");
        }
        catch (IOException ex) {
            Global.getLogger(PostProcessShader.class).log((Priority)Level.ERROR, (Object)("Post Process pre-shader loading error!  Post Processing disabled!" + ex.getMessage()));
            this.enabled = false;
            return;
        }
        this.programPre = ShaderLib.loadShader(vertShader, fragShader);
        if (this.programPre == 0) {
            this.enabled = false;
            Global.getLogger(PostProcessShader.class).log((Priority)Level.ERROR, (Object)"Post Process pre-shader compile error!  Post Processing disabled!");
            return;
        }
        try {
            vertShader = Global.getSettings().loadText("data/shaders/post/post.vert");
            fragShader = Global.getSettings().loadText("data/shaders/post/post.frag");
        }
        catch (IOException ex) {
            Global.getLogger(PostProcessShader.class).log((Priority)Level.ERROR, (Object)("Post Process post-shader loading error!  Post Processing disabled!" + ex.getMessage()));
            this.enabled = false;
            return;
        }
        this.programPost = ShaderLib.loadShader(vertShader, fragShader);
        if (this.programPost == 0) {
            this.enabled = false;
            Global.getLogger(PostProcessShader.class).log((Priority)Level.ERROR, (Object)"Post Process post-shader compile error!  Post Processing disabled!");
            return;
        }
        GL20.glUseProgram((int)this.programPre);
        this.indexPre[0] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"screen");
        this.indexPre[1] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"time");
        this.indexPre[2] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"hueshift");
        this.indexPre[3] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"saturation");
        this.indexPre[4] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"expdesaturation");
        this.indexPre[5] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"lightness");
        this.indexPre[6] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"expdarkness");
        this.indexPre[7] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"redhsl");
        this.indexPre[8] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"yellowhsl");
        this.indexPre[9] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"greenhsl");
        this.indexPre[10] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"tealhsl");
        this.indexPre[11] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"bluehsl");
        this.indexPre[12] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"magentahsl");
        this.indexPre[13] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"contrast");
        this.indexPre[14] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"noise");
        this.indexPre[15] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"scanlines");
        this.indexPre[16] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"scanint");
        this.indexPre[17] = GL20.glGetUniformLocation((int)this.programPre, (CharSequence)"scanwidth");
        GL20.glUniform1i((int)this.indexPre[0], (int)0);
        GL20.glUniform1f((int)this.indexPre[2], (float)0.0f);
        GL20.glUniform1f((int)this.indexPre[3], (float)1.0f);
        GL20.glUniform1i((int)this.indexPre[4], (int)0);
        GL20.glUniform1f((int)this.indexPre[5], (float)1.0f);
        GL20.glUniform1i((int)this.indexPre[6], (int)0);
        GL20.glUniform3f((int)this.indexPre[7], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPre[8], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPre[9], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPre[10], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPre[11], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPre[12], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform1f((int)this.indexPre[13], (float)1.0f);
        GL20.glUniform1f((int)this.indexPre[14], (float)0.0f);
        GL20.glUniform1f((int)this.indexPre[15], (float)0.0f);
        GL20.glUniform1f((int)this.indexPre[16], (float)(3.0f / (float)ShaderLib.getInternalHeight()));
        GL20.glUniform1f((int)this.indexPre[17], (float)(1.0f / (float)ShaderLib.getInternalHeight()));
        GL20.glUseProgram((int)0);
        GL20.glUseProgram((int)this.programPost);
        this.indexPost[0] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"screen");
        this.indexPost[1] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"time");
        this.indexPost[2] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"hueshift");
        this.indexPost[3] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"saturation");
        this.indexPost[4] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"expdesaturation");
        this.indexPost[5] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"lightness");
        this.indexPost[6] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"expdarkness");
        this.indexPost[7] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"redhsl");
        this.indexPost[8] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"yellowhsl");
        this.indexPost[9] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"greenhsl");
        this.indexPost[10] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"tealhsl");
        this.indexPost[11] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"bluehsl");
        this.indexPost[12] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"magentahsl");
        this.indexPost[13] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"contrast");
        this.indexPost[14] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"noise");
        this.indexPost[15] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"scanlines");
        this.indexPost[16] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"scanint");
        this.indexPost[17] = GL20.glGetUniformLocation((int)this.programPost, (CharSequence)"scanwidth");
        GL20.glUniform1i((int)this.indexPost[0], (int)0);
        GL20.glUniform1f((int)this.indexPost[2], (float)0.0f);
        GL20.glUniform1f((int)this.indexPost[3], (float)1.0f);
        GL20.glUniform1i((int)this.indexPost[4], (int)0);
        GL20.glUniform1f((int)this.indexPost[5], (float)1.0f);
        GL20.glUniform1i((int)this.indexPost[6], (int)0);
        GL20.glUniform3f((int)this.indexPost[7], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPost[8], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPost[9], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPost[10], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPost[11], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPost[12], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform1f((int)this.indexPost[13], (float)1.0f);
        GL20.glUniform1f((int)this.indexPost[14], (float)0.0f);
        GL20.glUniform1f((int)this.indexPost[15], (float)0.0f);
        GL20.glUniform1f((int)this.indexPost[16], (float)(3.0f / (float)ShaderLib.getInternalHeight()));
        GL20.glUniform1f((int)this.indexPost[17], (float)(1.0f / (float)ShaderLib.getInternalHeight()));
        GL20.glUseProgram((int)0);
        this.enabled = true;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (!this.enabled || !ShaderHook.enableShaders) {
            return;
        }
        this.draw(true);
    }

    @Override
    public void destroy() {
        int i;
        IntBuffer shaders;
        IntBuffer count;
        ByteBuffer shadersbb;
        ByteBuffer countbb;
        if (this.programPre != 0) {
            countbb = ByteBuffer.allocateDirect(4);
            shadersbb = ByteBuffer.allocateDirect(8);
            count = countbb.asIntBuffer();
            shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.programPre, (IntBuffer)count, (IntBuffer)shaders);
            for (i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.programPre);
        }
        if (this.programPost != 0) {
            countbb = ByteBuffer.allocateDirect(4);
            shadersbb = ByteBuffer.allocateDirect(8);
            count = countbb.asIntBuffer();
            shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.programPost, (IntBuffer)count, (IntBuffer)shaders);
            for (i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.programPost);
        }
    }

    @Override
    public ShaderAPI.RenderOrder getRenderOrder() {
        return ShaderAPI.RenderOrder.SCREEN_SPACE;
    }

    @Override
    public void initCombat() {
        this.setDefaultSettings();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void renderInScreenCoords(ViewportAPI viewport) {
    }

    @Override
    public void renderInWorldCoords(ViewportAPI viewport) {
        if (!this.enabled) {
            return;
        }
        this.draw(false);
    }

    private void draw(boolean post) {
        if (post) {
            ShaderLib.beginDraw(this.programPost);
        } else {
            ShaderLib.beginDraw(this.programPre);
        }
        if (post) {
            GL20.glUniform1f((int)this.indexPost[1], (float)(Global.getCombatEngine().getTotalElapsedTime(true) + 1000.0f * (float)Math.random()));
        } else {
            GL20.glUniform1f((int)this.indexPre[1], (float)(Global.getCombatEngine().getTotalElapsedTime(true) + 1000.0f * (float)Math.random()));
        }
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)ShaderLib.getScreenTexture());
        if (post) {
            if (!this.validatedPost) {
                this.validatedPost = true;
                GL20.glValidateProgram((int)this.programPost);
                if (GL20.glGetProgrami((int)this.programPost, (int)35715) == 0) {
                    Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.programPost));
                    ShaderLib.exitDraw();
                    this.enabled = false;
                    return;
                }
            }
        } else if (!this.validatedPre) {
            this.validatedPre = true;
            GL20.glValidateProgram((int)this.programPre);
            if (GL20.glGetProgrami((int)this.programPre, (int)35715) == 0) {
                Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.programPre));
                ShaderLib.exitDraw();
                this.enabled = false;
                return;
            }
        }
        GL11.glDisable((int)3042);
        ShaderLib.screenDraw(ShaderLib.getScreenTexture(), 33984);
        ShaderLib.exitDraw();
    }

    private void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        this.enabled = settings.getBoolean("enablePostProcess");
        this.colorBlindness = settings.getInt("colorBlindnessMode");
    }

    private void setDefaultSettings() {
        GL20.glUseProgram((int)this.programPost);
        switch (this.colorBlindness) {
            case 1: {
                GL20.glUniform1f((int)this.indexPost[3], (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[5], (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[7], (float)-0.1f, (float)1.3f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[8], (float)0.05f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[9], (float)0.2f, (float)1.6f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[10], (float)0.05f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[11], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[12], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[13], (float)1.0f);
                break;
            }
            case 2: {
                GL20.glUniform1f((int)this.indexPost[3], (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[5], (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[7], (float)-0.05f, (float)0.5f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[8], (float)0.1f, (float)0.75f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[9], (float)0.25f, (float)1.6f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[10], (float)0.1f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[11], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[12], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[13], (float)1.0f);
                break;
            }
            case 3: {
                GL20.glUniform1f((int)this.indexPost[3], (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[5], (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[7], (float)-0.1f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[8], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[9], (float)-0.1f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[10], (float)0.0f, (float)1.3f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[11], (float)0.0f, (float)1.6f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[12], (float)0.0f, (float)1.3f, (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[13], (float)1.0f);
                break;
            }
            case 4: {
                GL20.glUniform1f((int)this.indexPost[3], (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[5], (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[7], (float)-0.1f, (float)1.3f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[8], (float)0.2f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[9], (float)0.3f, (float)1.6f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[10], (float)0.1f, (float)0.75f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[11], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[12], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[13], (float)1.0f);
                break;
            }
            case 5: {
                GL20.glUniform1f((int)this.indexPost[3], (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[5], (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[7], (float)-0.05f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[8], (float)0.3f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[9], (float)0.25f, (float)1.6f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[10], (float)0.1f, (float)0.75f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[11], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[12], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[13], (float)1.0f);
                break;
            }
            case 6: {
                GL20.glUniform1f((int)this.indexPost[3], (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[5], (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[7], (float)-0.1f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[8], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[9], (float)-0.1f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[10], (float)0.0f, (float)1.3f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[11], (float)0.1f, (float)1.6f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[12], (float)0.0f, (float)1.3f, (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[13], (float)1.0f);
                break;
            }
            case 7: {
                GL20.glUniform1f((int)this.indexPost[3], (float)2.0f);
                GL20.glUniform1f((int)this.indexPost[5], (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[7], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[8], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[9], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[10], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[11], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[12], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[13], (float)1.25f);
                break;
            }
            default: {
                GL20.glUniform1f((int)this.indexPost[3], (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[5], (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[7], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[8], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[9], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[10], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[11], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform3f((int)this.indexPost[12], (float)0.0f, (float)1.0f, (float)1.0f);
                GL20.glUniform1f((int)this.indexPost[13], (float)1.0f);
            }
        }
        GL20.glUniform1f((int)this.indexPost[2], (float)0.0f);
        GL20.glUniform1i((int)this.indexPost[4], (int)0);
        GL20.glUniform1i((int)this.indexPost[6], (int)1);
        GL20.glUniform1f((int)this.indexPost[14], (float)0.0f);
        GL20.glUniform1f((int)this.indexPost[15], (float)0.0f);
        GL20.glUniform1f((int)this.indexPost[16], (float)(3.0f / (float)ShaderLib.getInternalHeight()));
        GL20.glUniform1f((int)this.indexPost[17], (float)(1.0f / (float)ShaderLib.getInternalHeight()));
        GL20.glUseProgram((int)0);
        GL20.glUseProgram((int)this.programPre);
        GL20.glUniform1f((int)this.indexPre[2], (float)0.0f);
        GL20.glUniform1f((int)this.indexPre[3], (float)1.0f);
        GL20.glUniform1i((int)this.indexPre[4], (int)0);
        GL20.glUniform1f((int)this.indexPre[5], (float)1.0f);
        GL20.glUniform1i((int)this.indexPre[6], (int)1);
        GL20.glUniform3f((int)this.indexPre[7], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPre[8], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPre[9], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPre[10], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPre[11], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform3f((int)this.indexPre[12], (float)0.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform1f((int)this.indexPre[13], (float)1.0f);
        GL20.glUniform1f((int)this.indexPre[14], (float)0.0f);
        GL20.glUniform1f((int)this.indexPre[15], (float)0.0f);
        GL20.glUniform1f((int)this.indexPre[16], (float)(3.0f / (float)ShaderLib.getInternalHeight()));
        GL20.glUniform1f((int)this.indexPre[17], (float)(1.0f / (float)ShaderLib.getInternalHeight()));
        GL20.glUseProgram((int)0);
    }

    @Override
    public CombatEngineLayers getCombatLayer() {
        return CombatEngineLayers.JUST_BELOW_WIDGETS;
    }

    @Override
    public boolean isCombat() {
        return false;
    }
}

