/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.light;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Deque;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.util.ShaderLib;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class StandardLight
implements LightAPI {
    private static final Vector2f ZERO = new Vector2f();
    private float arcEnd = 0.0f;
    private float arcStart = 0.0f;
    private CombatEntityAPI attach = null;
    private float autoFadeOutTime = 1.0f;
    private BeamAPI beamAttach = null;
    private BeamAPI beamLink = null;
    private final Vector3f color = new Vector3f(1.0f, 1.0f, 1.0f);
    private final Deque<Boolean> damageFrames = new ArrayDeque<Boolean>(4);
    private boolean damageInLastFewFrames = false;
    private final Vector3f direction;
    private float height = 200.0f;
    private float intensity = 0.0f;
    private float intensityFade = 0.0f;
    private float intensityMax = 0.0f;
    private boolean isFadingIn = false;
    private boolean isFadingOut = false;
    private float lifetime = -1.0f;
    private boolean linkToEnd = false;
    private final Vector2f location;
    private final Vector2f location2;
    private final Vector2f offset;
    private float size = 0.0f;
    private float specularIntensity = 0.0f;
    private float specularMultiplier = 1.0f;
    private float superLifetime = 60.0f;
    private int type;
    private final Vector2f velocity;
    private final Vector2f velocity2;

    private static Vector2f computeOffset(Vector2f location, Vector2f offset, float angle) {
        float angleRads = (float)Math.toRadians(angle);
        float cos = (float)ShaderLib.fastCos(angleRads);
        float sin = (float)ShaderLib.fastSin(angleRads);
        Vector2f dest = new Vector2f(offset.x * cos - offset.y * sin, offset.x * sin + offset.y * cos);
        Vector2f.add((Vector2f)dest, (Vector2f)location, (Vector2f)dest);
        return dest;
    }

    public StandardLight() {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f();
        this.location2 = new Vector2f();
        this.offset = new Vector2f();
        this.velocity = new Vector2f();
        this.velocity2 = new Vector2f();
        this.direction = new Vector3f(0.0f, 0.0f, -1.0f);
        this.type = 0;
    }

    public StandardLight(float intensity, float size) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f();
        this.location2 = new Vector2f();
        this.offset = new Vector2f();
        this.velocity = new Vector2f();
        this.velocity2 = new Vector2f();
        this.direction = new Vector3f(0.0f, 0.0f, -1.0f);
        this.intensity = intensity;
        this.size = size;
        this.type = 0;
    }

    public StandardLight(Vector2f location, Vector2f velocity, Vector2f offset, CombatEntityAPI attach) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f((ReadableVector2f)location);
        this.location2 = new Vector2f();
        this.offset = new Vector2f((ReadableVector2f)offset);
        this.velocity = new Vector2f((ReadableVector2f)velocity);
        this.velocity2 = new Vector2f();
        this.direction = new Vector3f(0.0f, 0.0f, -1.0f);
        if (attach != null) {
            this.pAttachTo(attach);
        }
        this.type = 0;
    }

    public StandardLight(Vector2f location, Vector2f velocity, Vector2f offset, CombatEntityAPI attach, float intensity, float size) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f((ReadableVector2f)location);
        this.location2 = new Vector2f();
        this.offset = new Vector2f((ReadableVector2f)offset);
        this.velocity = new Vector2f((ReadableVector2f)velocity);
        this.velocity2 = new Vector2f();
        this.direction = new Vector3f(0.0f, 0.0f, -1.0f);
        if (attach != null) {
            this.pAttachTo(attach);
        }
        this.intensity = intensity;
        this.size = size;
        this.type = 0;
    }

    public StandardLight(Vector2f location, Vector2f velocity, BeamAPI beamLink, boolean linkToEnd) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f((ReadableVector2f)location);
        this.location2 = new Vector2f();
        this.offset = new Vector2f();
        this.velocity = new Vector2f((ReadableVector2f)velocity);
        this.velocity2 = new Vector2f();
        this.direction = new Vector3f(0.0f, 0.0f, -1.0f);
        if (beamLink != null) {
            this.pLinkToBeam(beamLink, linkToEnd);
        }
        this.type = 0;
    }

    public StandardLight(Vector2f location, Vector2f velocity, BeamAPI beamLink, boolean linkToEnd, float intensity, float size) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f((ReadableVector2f)location);
        this.location2 = new Vector2f();
        this.offset = new Vector2f();
        this.velocity = new Vector2f((ReadableVector2f)velocity);
        this.velocity2 = new Vector2f();
        this.direction = new Vector3f(0.0f, 0.0f, -1.0f);
        if (beamLink != null) {
            this.pLinkToBeam(beamLink, linkToEnd);
        }
        this.intensity = intensity;
        this.size = size;
        this.type = 0;
    }

    public StandardLight(Vector2f location, Vector2f location2, Vector2f velocity, Vector2f velocity2, BeamAPI beamAttach) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f((ReadableVector2f)location);
        this.location2 = new Vector2f((ReadableVector2f)location2);
        this.offset = new Vector2f();
        this.velocity = new Vector2f((ReadableVector2f)velocity);
        this.velocity2 = new Vector2f((ReadableVector2f)velocity2);
        this.direction = new Vector3f(0.0f, 0.0f, -1.0f);
        if (beamAttach != null) {
            this.pAttachToBeam(beamAttach);
        }
        this.type = 1;
    }

    public StandardLight(Vector2f location, Vector2f location2, Vector2f velocity, Vector2f velocity2, BeamAPI beamAttach, float intensity, float size) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f((ReadableVector2f)location);
        this.location2 = new Vector2f((ReadableVector2f)location2);
        this.offset = new Vector2f();
        this.velocity = new Vector2f((ReadableVector2f)velocity);
        this.velocity2 = new Vector2f((ReadableVector2f)velocity2);
        this.direction = new Vector3f(0.0f, 0.0f, -1.0f);
        if (beamAttach != null) {
            this.pAttachToBeam(beamAttach);
        }
        this.intensity = intensity;
        this.size = size;
        this.type = 1;
    }

    public StandardLight(Vector2f location, Vector2f velocity, float arcEnd, float arcStart) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f((ReadableVector2f)location);
        this.location2 = new Vector2f();
        this.offset = new Vector2f();
        this.velocity = new Vector2f((ReadableVector2f)velocity);
        this.velocity2 = new Vector2f();
        this.direction = new Vector3f(0.0f, 0.0f, -1.0f);
        this.pSetArc(arcStart, arcEnd);
        this.type = 2;
    }

    public StandardLight(Vector2f location, Vector2f velocity, float arcEnd, float arcStart, float intensity, float size) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f((ReadableVector2f)location);
        this.location2 = new Vector2f();
        this.offset = new Vector2f();
        this.velocity = new Vector2f((ReadableVector2f)velocity);
        this.velocity2 = new Vector2f();
        this.direction = new Vector3f(0.0f, 0.0f, -1.0f);
        this.pSetArc(arcStart, arcEnd);
        this.intensity = intensity;
        this.size = size;
        this.type = 2;
    }

    public StandardLight(Vector3f direction) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f();
        this.location2 = new Vector2f();
        this.offset = new Vector2f();
        this.velocity = new Vector2f();
        this.velocity2 = new Vector2f();
        this.direction = new Vector3f((ReadableVector3f)direction);
        this.direction.normalise();
        this.type = 3;
    }

    public StandardLight(Vector3f direction, float intensity) {
        for (int i = 0; i < 4; ++i) {
            this.damageFrames.add(false);
        }
        this.location = new Vector2f();
        this.location2 = new Vector2f();
        this.offset = new Vector2f();
        this.velocity = new Vector2f();
        this.velocity2 = new Vector2f();
        this.direction = new Vector3f((ReadableVector3f)direction);
        this.direction.normalise();
        this.intensity = intensity;
        this.type = 3;
    }

    @Override
    public boolean advance(float amount) {
        if (this.beamLink != null) {
            this.damageFrames.removeLast();
            this.damageFrames.addFirst(this.beamLink.didDamageThisFrame());
            if (this.damageFrames.contains(true)) {
                this.damageInLastFewFrames = true;
            }
        }
        if (this.attach == null && this.beamAttach == null && this.beamLink == null) {
            this.location.translate(this.velocity.x * amount, this.velocity.y * amount);
            this.location2.translate(this.velocity2.x * amount, this.velocity2.y * amount);
        }
        if (this.isFadingOut) {
            this.intensity -= this.intensityFade * amount;
        } else if (this.isFadingIn) {
            this.intensity += this.intensityFade * amount;
            if (this.intensity >= this.intensityMax) {
                this.intensity = this.intensityMax;
                this.isFadingIn = false;
            }
        } else if (this.lifetime >= 0.0f) {
            this.lifetime -= amount;
            if (this.lifetime < 0.0f) {
                this.fadeOut(this.autoFadeOutTime);
            }
        }
        if (this.superLifetime >= 0.0f) {
            this.superLifetime -= amount;
            if (this.superLifetime < 0.0f) {
                return true;
            }
        }
        if (this.type == 3) {
            return this.intensity <= 0.0f && this.specularIntensity <= 0.0f;
        }
        return this.size <= 0.0f || this.intensity <= 0.0f;
    }

    public void attachTo(CombatEntityAPI attach) {
        this.attach = attach;
        this.beamAttach = null;
        this.beamLink = null;
    }

    public void attachToBeam(BeamAPI beamAttach) {
        this.attach = null;
        this.beamAttach = beamAttach;
        this.beamLink = beamAttach;
    }

    public void fadeIn(float seconds) {
        if (seconds <= 0.0f) {
            if (this.isFadingIn) {
                this.intensity = this.intensityMax;
                this.isFadingIn = false;
                this.isFadingOut = false;
            }
        } else {
            this.intensityFade = this.intensity / seconds;
            this.intensityMax = this.intensity;
            this.intensity = 0.0f;
            this.isFadingIn = true;
            this.isFadingOut = false;
        }
    }

    public void fadeOut(float seconds) {
        if (seconds <= 0.0f) {
            this.intensity = 0.0f;
        } else {
            this.intensityFade = this.intensity / seconds;
        }
        this.isFadingOut = true;
        this.isFadingIn = false;
    }

    @Override
    public float getArcEnd() {
        return this.arcEnd;
    }

    @Override
    public float getArcStart() {
        return this.arcStart;
    }

    public CombatEntityAPI getAttachment() {
        return this.attach;
    }

    public float getAutoFadeOutTime() {
        return this.autoFadeOutTime;
    }

    public void setAutoFadeOutTime(float autoFadeOutTime) {
        this.autoFadeOutTime = autoFadeOutTime;
    }

    public BeamAPI getBeamAttachment() {
        return this.beamAttach;
    }

    public BeamAPI getBeamLink() {
        return this.beamLink;
    }

    @Override
    public Vector3f getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color.x = (float)color.getRed() / 255.0f;
        this.color.y = (float)color.getGreen() / 255.0f;
        this.color.z = (float)color.getBlue() / 255.0f;
    }

    public void setColor(Vector3f color) {
        this.color.x = color.x;
        this.color.y = color.y;
        this.color.z = color.z;
    }

    @Override
    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f direction) {
        this.direction.set((ReadableVector3f)direction);
        this.direction.normalise();
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    @Override
    public float getIntensity() {
        if (this.beamLink != null) {
            if (!this.damageInLastFewFrames && this.linkToEnd) {
                return 0.0f;
            }
            return this.intensity * this.beamLink.getBrightness();
        }
        return this.intensity;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    public void setLifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public Vector2f getLocation() {
        if (this.attach != null) {
            if (Float.compare(this.offset.x, 0.0f) != 0 || Float.compare(this.offset.y, 0.0f) != 0) {
                return StandardLight.computeOffset(this.attach.getLocation(), this.offset, this.attach.getFacing());
            }
            return this.attach.getLocation();
        }
        if (this.beamAttach != null) {
            return this.beamAttach.getFrom();
        }
        if (this.beamLink != null) {
            if (this.linkToEnd) {
                return this.beamLink.getTo();
            }
            return this.beamLink.getFrom();
        }
        return this.location;
    }

    public void setLocation(Vector2f location) {
        this.location.set((ReadableVector2f)location);
    }

    @Override
    public Vector2f getLocation2() {
        if (this.attach != null) {
            if (Float.compare(this.offset.x, 0.0f) != 0 || Float.compare(this.offset.y, 0.0f) != 0) {
                return StandardLight.computeOffset(this.attach.getLocation(), this.offset, this.attach.getFacing());
            }
            return this.attach.getLocation();
        }
        if (this.beamAttach != null) {
            return this.beamAttach.getTo();
        }
        return this.location2;
    }

    public void setLocation2(Vector2f location) {
        this.location2.set((ReadableVector2f)location);
    }

    public Vector2f getOffset() {
        return this.offset;
    }

    public void setOffset(Vector2f offset) {
        this.offset.set((ReadableVector2f)offset);
    }

    public float getRemainingLifetime() {
        return this.lifetime;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    @Override
    public float getSpecularIntensity() {
        return this.specularIntensity;
    }

    public void setSpecularIntensity(float intensity) {
        this.specularIntensity = intensity;
    }

    @Override
    public float getSpecularMult() {
        return this.specularMultiplier;
    }

    public void setSpecularMult(float multiplier) {
        this.specularMultiplier = multiplier;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Vector2f getVelocity() {
        if (this.attach != null || this.beamAttach != null || this.beamLink != null) {
            return ZERO;
        }
        return this.velocity;
    }

    public void setVelocity(Vector2f velocity) {
        if (this.attach == null && this.beamAttach == null && this.beamLink == null) {
            this.velocity.set((ReadableVector2f)velocity);
        }
    }

    public Vector2f getVelocity2() {
        if (this.attach != null || this.beamAttach != null || this.beamLink != null) {
            return ZERO;
        }
        return this.velocity2;
    }

    public void setVelocity2(Vector2f velocity) {
        if (this.attach == null && this.beamAttach == null && this.beamLink == null) {
            this.velocity2.set((ReadableVector2f)velocity);
        }
    }

    public boolean isFadingIn() {
        return this.isFadingIn;
    }

    public boolean isFadingOut() {
        return this.isFadingOut;
    }

    public void linkToBeam(BeamAPI beamLink, boolean linkToEnd) {
        this.attach = null;
        this.beamAttach = null;
        this.beamLink = beamLink;
        this.linkToEnd = linkToEnd;
    }

    public void makePermanent() {
        this.lifetime = -1.0f;
        this.superLifetime = -1.0f;
    }

    public void setArc(float start, float end) {
        this.arcStart = start;
        this.arcEnd = end;
        if (this.arcStart < -360.0f || this.arcStart > 360.0f) {
            this.arcStart %= 360.0f;
        }
        if (this.arcStart < 0.0f) {
            this.arcStart += 360.0f;
        }
        if (this.arcEnd < -360.0f || this.arcEnd > 360.0f) {
            this.arcEnd %= 360.0f;
        }
        if (this.arcEnd < 0.0f) {
            this.arcEnd += 360.0f;
        }
    }

    public void setColor(float red, float green, float blue) {
        this.color.x = red;
        this.color.y = green;
        this.color.z = blue;
    }

    public void unattach() {
        this.attach = null;
        this.beamAttach = null;
        this.beamLink = null;
    }

    private void pAttachTo(CombatEntityAPI attach) {
        this.attachTo(attach);
    }

    private void pAttachToBeam(BeamAPI beamAttach) {
        this.attachToBeam(beamAttach);
    }

    private void pLinkToBeam(BeamAPI beamLink, boolean linkToEnd) {
        this.linkToBeam(beamLink, linkToEnd);
    }

    private void pSetArc(float start, float end) {
        this.arcStart = start;
        this.arcEnd = end;
        if (this.arcStart < -360.0f || this.arcStart > 360.0f) {
            this.arcStart %= 360.0f;
        }
        if (this.arcStart < 0.0f) {
            this.arcStart += 360.0f;
        }
        if (this.arcEnd < -360.0f || this.arcEnd > 360.0f) {
            this.arcEnd %= 360.0f;
        }
        if (this.arcEnd < 0.0f) {
            this.arcEnd += 360.0f;
        }
    }
}

