/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.light;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BoundsAPI;
import com.fs.starfarer.api.combat.CombatAsteroidAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MissileRenderDataAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import java.awt.Color;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.graphics.util.Tessellate;
import org.dark.shaders.ShaderModPlugin;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightData;
import org.dark.shaders.light.LightEntry;
import org.dark.shaders.light.StandardLight;
import org.dark.shaders.util.ShaderAPI;
import org.dark.shaders.util.ShaderLib;
import org.dark.shaders.util.TextureData;
import org.dark.shaders.util.TextureEntry;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class LightShader
implements ShaderAPI {
    private static final String DATA_KEY = "shaderlib_LightShader";
    private static final Comparator<LightAPI> LIGHTSIZE = new Comparator<LightAPI>(){

        @Override
        public int compare(LightAPI light1, LightAPI light2) {
            float light2factor;
            if (light1.getType() == 3 && light2.getType() != 3) {
                return -1;
            }
            if (light1.getType() != 3 && light2.getType() == 3) {
                return 1;
            }
            float light1factor = light1.getSize();
            if (light1factor > (light2factor = light2.getSize())) {
                return -1;
            }
            if (light1factor < light2factor) {
                return 1;
            }
            return 0;
        }
    };
    private static final int MAX_LIGHTS = 372;
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private static final Vector2f ZERO = new Vector2f();
    private static final Color deadSurface = new Color(0, 100, 150);
    private static final Vector2f tempVec = new Vector2f();
    private boolean bloomEnabled = false;
    private float bloomIntensity = 2.0f;
    private int bloomMips = 3;
    private int bloomQuality = 3;
    private float bloomScale = 0.5f;
    private final FloatBuffer dataBuffer = BufferUtils.createFloatBuffer((int)4096);
    private final FloatBuffer dataBufferPre = BufferUtils.createFloatBuffer((int)4096);
    private boolean enabled = false;
    private float fighterLightMultiplier = 1.0f;
    private float flashHeight = 150.0f;
    private float flatness = 0.0f;
    private int hdrBuffer2Id = 0;
    private int hdrBuffer3Id = 0;
    private int hdrBufferId = 0;
    private int hdrTex = 0;
    private int hdrTex2 = 0;
    private int hdrTex3 = 0;
    private final int[] index = new int[13];
    private final int[] indexAux = new int[2];
    private final int[] indexBloom1 = new int[4];
    private final int[] indexBloom2 = new int[4];
    private final int[] indexBloom3 = new int[3];
    private float lastAngle;
    private float lastFlatness;
    private float lightDepth = 0.2f;
    private float lightMultiplier = 1.0f;
    private float lightSizeMultiplier = 1.0f;
    private int lightTex = 0;
    private int maxLights = 372;
    private int maxLineLights = 372;
    private int normalBufferId = 0;
    private boolean normalEnabled = false;
    private int normalTex = 0;
    private int program = 0;
    private int programAux = 0;
    private int programBloom1 = 0;
    private int programBloom2 = 0;
    private int programBloom3 = 0;
    private float specularHardness = 0.4f;
    private float specularMultiplier = 5.0f;
    private float standardHeight = 100.0f;
    private boolean validated = false;
    private boolean validatedAux = false;
    private boolean validatedBloom1 = false;
    private boolean validatedBloom2 = false;
    private boolean validatedBloom3 = false;

    public static void addLight(LightAPI light) {
        ShaderAPI lightShader = ShaderLib.getShaderAPI(LightShader.class);
        if (lightShader instanceof LightShader && lightShader.isEnabled() && light != null) {
            LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
            if (localData == null) {
                return;
            }
            List<LightAPI> lights = localData.lights;
            if (lights != null) {
                lights.add(light);
            }
        }
    }

    public static void removeLight(LightAPI light) {
        ShaderAPI lightShader = ShaderLib.getShaderAPI(LightShader.class);
        if (lightShader instanceof LightShader && lightShader.isEnabled() && light != null) {
            LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
            if (localData == null) {
                return;
            }
            List<LightAPI> lights = localData.lights;
            if (lights != null) {
                lights.remove(light);
            }
        }
    }

    public LightShader() {
        if (!ShaderLib.areShadersAllowed() || !ShaderLib.areBuffersAllowed()) {
            this.enabled = false;
            return;
        }
        Global.getLogger(LightShader.class).setLevel(Level.ERROR);
        try {
            this.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)("Failed to load shader settings: " + e.getMessage()));
            this.enabled = false;
            return;
        }
        String vendor = GL11.glGetString((int)7936);
        if (!GLContext.getCapabilities().OpenGL30 || vendor.contains("Intel")) {
            Global.getLogger(LightShader.class).log((Priority)Level.WARN, (Object)"Bloom is not supported; disabling");
            this.bloomEnabled = false;
        }
        if (!this.enabled) {
            return;
        }
        String vertShader = null;
        String fragShader = null;
        if (this.normalEnabled) {
            try {
                vertShader = Global.getSettings().loadText("data/shaders/lights/2dtangent.vert");
                fragShader = Global.getSettings().loadText("data/shaders/lights/2dtangent.frag");
            }
            catch (IOException ex) {
                Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)("Normal transform shader loading error!  Normals disabled!" + ex.getMessage()));
                this.normalEnabled = false;
            }
        }
        if (this.normalEnabled) {
            this.programAux = ShaderLib.loadShader(vertShader, fragShader);
            if (this.programAux == 0) {
                Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)"Normal transform shader compile error!  Normals disabled!");
                this.normalEnabled = false;
            }
        }
        try {
            if (this.normalEnabled) {
                vertShader = Global.getSettings().loadText("data/shaders/lights/lightsnormal.vert");
                fragShader = Global.getSettings().loadText("data/shaders/lights/lightsnormal.frag");
            } else {
                vertShader = Global.getSettings().loadText("data/shaders/lights/lights.vert");
                fragShader = Global.getSettings().loadText("data/shaders/lights/lights.frag");
            }
        }
        catch (IOException ex) {
            Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)("Lighting shader loading error!  Lighting disabled!" + ex.getMessage()));
            this.enabled = false;
            return;
        }
        this.program = ShaderLib.loadShader(vertShader, fragShader);
        if (this.program == 0) {
            this.enabled = false;
            Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)"Lighting shader compile error!  Lighting disabled!");
            return;
        }
        if (this.bloomEnabled) {
            try {
                vertShader = Global.getSettings().loadText("data/shaders/bloom/bloom1.vert");
                switch (this.bloomQuality) {
                    case 1: {
                        fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom1-5.frag");
                        break;
                    }
                    case 2: {
                        fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom1-7.frag");
                        break;
                    }
                    case 3: {
                        fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom1-9.frag");
                        break;
                    }
                    case 4: {
                        fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom1-11.frag");
                        break;
                    }
                    case 5: {
                        fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom1-13.frag");
                        break;
                    }
                }
            }
            catch (IOException ex) {
                this.bloomEnabled = false;
                Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)("Bloom shader 1 loading error!  Bloom disabled!" + ex.getMessage()));
            }
            this.programBloom1 = ShaderLib.loadShader(vertShader, fragShader);
            if (this.programBloom1 == 0) {
                this.bloomEnabled = false;
                Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)"Bloom shader 1 compile error!  Bloom disabled!");
            }
            try {
                vertShader = Global.getSettings().loadText("data/shaders/bloom/bloom2.vert");
                switch (this.bloomQuality) {
                    case 1: {
                        fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom2-5.frag");
                        break;
                    }
                    case 2: {
                        fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom2-7.frag");
                        break;
                    }
                    case 3: {
                        fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom2-9.frag");
                        break;
                    }
                    case 4: {
                        fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom2-11.frag");
                        break;
                    }
                    case 5: {
                        fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom2-13.frag");
                        break;
                    }
                }
            }
            catch (IOException ex) {
                this.bloomEnabled = false;
                Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)("Bloom shader 2 loading error!  Bloom disabled!" + ex.getMessage()));
            }
            this.programBloom2 = ShaderLib.loadShader(vertShader, fragShader);
            if (this.programBloom2 == 0) {
                this.bloomEnabled = false;
                Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)"Bloom shader 2 compile error!  Bloom disabled!");
            }
            try {
                vertShader = Global.getSettings().loadText("data/shaders/bloom/bloom3.vert");
                fragShader = Global.getSettings().loadText("data/shaders/bloom/bloom3.frag");
            }
            catch (IOException ex) {
                this.bloomEnabled = false;
                Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)("Bloom shader 3 loading error!  Bloom disabled!" + ex.getMessage()));
            }
            this.programBloom3 = ShaderLib.loadShader(vertShader, fragShader);
            if (this.programBloom3 == 0) {
                this.bloomEnabled = false;
                Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)"Bloom shader 3 compile error!  Bloom disabled!");
            }
        }
        this.lightTex = GL11.glGenTextures();
        GL11.glBindTexture((int)3552, (int)this.lightTex);
        if (ShaderLib.useBufferCore()) {
            GL11.glTexImage1D((int)3552, (int)0, (int)33326, (int)4096, (int)0, (int)6403, (int)5126, (ByteBuffer)null);
        } else {
            GL11.glTexImage1D((int)3552, (int)0, (int)33326, (int)4096, (int)0, (int)6403, (int)5126, (ByteBuffer)null);
        }
        if (this.normalEnabled) {
            this.normalTex = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)this.normalTex);
            GL11.glTexImage2D((int)3553, (int)0, (int)32849, (int)ShaderLib.getInternalWidth(), (int)ShaderLib.getInternalHeight(), (int)0, (int)6407, (int)5121, (ByteBuffer)null);
            if (ShaderLib.useBufferCore()) {
                GL30.glGenerateMipmap((int)3553);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glGenerateMipmap((int)3553);
            } else {
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            this.normalBufferId = ShaderLib.useBufferCore() ? ShaderLib.makeFramebuffer(36064, this.normalTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0) : (ShaderLib.useBufferARB() ? ShaderLib.makeFramebuffer(36064, this.normalTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0) : ShaderLib.makeFramebuffer(36064, this.normalTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0));
            if (this.normalBufferId == 0) {
                this.normalEnabled = false;
                Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)"Normals framebuffer object error!  Normals disabled!");
            }
        }
        if (this.bloomEnabled) {
            this.hdrTex = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)this.hdrTex);
            GL11.glTexImage2D((int)3553, (int)0, (int)32852, (int)ShaderLib.getInternalWidth(), (int)ShaderLib.getInternalHeight(), (int)0, (int)6407, (int)5123, (ByteBuffer)null);
            if (ShaderLib.useBufferCore()) {
                GL30.glGenerateMipmap((int)3553);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glGenerateMipmap((int)3553);
            } else {
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            this.hdrBufferId = ShaderLib.useBufferCore() ? ShaderLib.makeFramebuffer(36064, this.hdrTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0) : (ShaderLib.useBufferARB() ? ShaderLib.makeFramebuffer(36064, this.hdrTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0) : ShaderLib.makeFramebuffer(36064, this.hdrTex, ShaderLib.getInternalWidth(), ShaderLib.getInternalHeight(), 0));
            this.hdrTex2 = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)this.hdrTex2);
            GL11.glTexImage2D((int)3553, (int)0, (int)32849, (int)(ShaderLib.getInternalWidth() / (int)Math.pow(2.0, this.bloomMips - 1)), (int)(ShaderLib.getInternalHeight() / (int)Math.pow(2.0, this.bloomMips - 1)), (int)0, (int)6407, (int)5121, (ByteBuffer)null);
            if (ShaderLib.useBufferCore()) {
                GL30.glGenerateMipmap((int)3553);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glGenerateMipmap((int)3553);
            } else {
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            this.hdrBuffer2Id = ShaderLib.useBufferCore() ? ShaderLib.makeFramebuffer(36064, this.hdrTex2, ShaderLib.getInternalWidth() / (int)Math.pow(2.0, this.bloomMips - 1), ShaderLib.getInternalHeight() / (int)Math.pow(2.0, this.bloomMips - 1), 0) : (ShaderLib.useBufferARB() ? ShaderLib.makeFramebuffer(36064, this.hdrTex2, ShaderLib.getInternalWidth() / (int)Math.pow(2.0, this.bloomMips - 1), ShaderLib.getInternalHeight() / (int)Math.pow(2.0, this.bloomMips - 1), 0) : ShaderLib.makeFramebuffer(36064, this.hdrTex2, ShaderLib.getInternalWidth() / (int)Math.pow(2.0, this.bloomMips - 1), ShaderLib.getInternalHeight() / (int)Math.pow(2.0, this.bloomMips - 1), 0));
            this.hdrTex3 = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)this.hdrTex3);
            GL11.glTexImage2D((int)3553, (int)0, (int)32849, (int)(ShaderLib.getInternalWidth() / (int)Math.pow(2.0, this.bloomMips - 1)), (int)(ShaderLib.getInternalHeight() / (int)Math.pow(2.0, this.bloomMips - 1)), (int)0, (int)6407, (int)5121, (ByteBuffer)null);
            if (ShaderLib.useBufferCore()) {
                GL30.glGenerateMipmap((int)3553);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glGenerateMipmap((int)3553);
            } else {
                EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            this.hdrBuffer3Id = ShaderLib.useBufferCore() ? ShaderLib.makeFramebuffer(36064, this.hdrTex3, ShaderLib.getInternalWidth() / (int)Math.pow(2.0, this.bloomMips - 1), ShaderLib.getInternalHeight() / (int)Math.pow(2.0, this.bloomMips - 1), 0) : (ShaderLib.useBufferARB() ? ShaderLib.makeFramebuffer(36064, this.hdrTex3, ShaderLib.getInternalWidth() / (int)Math.pow(2.0, this.bloomMips - 1), ShaderLib.getInternalHeight() / (int)Math.pow(2.0, this.bloomMips - 1), 0) : ShaderLib.makeFramebuffer(36064, this.hdrTex3, ShaderLib.getInternalWidth() / (int)Math.pow(2.0, this.bloomMips - 1), ShaderLib.getInternalHeight() / (int)Math.pow(2.0, this.bloomMips - 1), 0));
            if (this.hdrBufferId == 0 || this.hdrBuffer2Id == 0 || this.hdrBuffer3Id == 0) {
                this.bloomEnabled = false;
                Global.getLogger(LightShader.class).log((Priority)Level.ERROR, (Object)"Bloom framebuffer object error!  Bloom disabled!");
            }
        }
        GL20.glUseProgram((int)this.program);
        this.index[0] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"tex");
        this.index[1] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"buf");
        this.index[2] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"data");
        this.index[3] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"trans");
        this.index[4] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"size");
        this.index[5] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"norm1");
        this.index[6] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"norm2");
        this.index[7] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"norm3");
        this.index[8] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"hdr");
        this.index[9] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"specmult");
        if (this.normalEnabled) {
            this.index[10] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"normal");
            this.index[11] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"surface");
            this.index[12] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"spechard");
        }
        GL20.glUniform1i((int)this.index[0], (int)0);
        GL20.glUniform1i((int)this.index[1], (int)1);
        GL20.glUniform1i((int)this.index[2], (int)2);
        GL20.glUniform1f((int)this.index[3], (float)ShaderLib.getSquareTransform());
        if (this.bloomEnabled) {
            GL20.glUniform1f((int)this.index[8], (float)0.0625f);
        } else {
            GL20.glUniform1f((int)this.index[8], (float)1.0f);
        }
        GL20.glUniform1f((int)this.index[9], (float)this.specularMultiplier);
        if (this.normalEnabled) {
            GL20.glUniform1i((int)this.index[10], (int)3);
            GL20.glUniform1i((int)this.index[11], (int)4);
            GL20.glUniform1f((int)this.index[12], (float)this.specularHardness);
        }
        GL20.glUseProgram((int)0);
        if (this.bloomEnabled) {
            GL20.glUseProgram((int)this.programBloom1);
            this.indexBloom1[0] = GL20.glGetUniformLocation((int)this.programBloom1, (CharSequence)"tex");
            this.indexBloom1[1] = GL20.glGetUniformLocation((int)this.programBloom1, (CharSequence)"screen");
            this.indexBloom1[2] = GL20.glGetUniformLocation((int)this.programBloom1, (CharSequence)"hdr");
            this.indexBloom1[3] = GL20.glGetUniformLocation((int)this.programBloom1, (CharSequence)"scale");
            GL20.glUniform1i((int)this.indexBloom1[0], (int)0);
            GL20.glUniform2f((int)this.indexBloom1[1], (float)(ShaderLib.getInternalWidth() / (int)Math.pow(2.0, this.bloomMips - 1)), (float)ShaderLib.getVisibleU());
            GL20.glUniform1f((int)this.indexBloom1[2], (float)16.0f);
            GL20.glUniform1f((int)this.indexBloom1[3], (float)this.bloomScale);
            GL20.glUseProgram((int)this.programBloom2);
            this.indexBloom2[0] = GL20.glGetUniformLocation((int)this.programBloom2, (CharSequence)"tex");
            this.indexBloom2[1] = GL20.glGetUniformLocation((int)this.programBloom2, (CharSequence)"screen");
            this.indexBloom2[2] = GL20.glGetUniformLocation((int)this.programBloom2, (CharSequence)"intensity");
            this.indexBloom2[3] = GL20.glGetUniformLocation((int)this.programBloom2, (CharSequence)"scale");
            GL20.glUniform1i((int)this.indexBloom2[0], (int)0);
            GL20.glUniform2f((int)this.indexBloom2[1], (float)(ShaderLib.getInternalHeight() / (int)Math.pow(2.0, this.bloomMips - 1)), (float)ShaderLib.getVisibleV());
            GL20.glUniform1f((int)this.indexBloom2[2], (float)this.bloomIntensity);
            GL20.glUniform1f((int)this.indexBloom2[3], (float)this.bloomScale);
            GL20.glUseProgram((int)this.programBloom3);
            this.indexBloom3[0] = GL20.glGetUniformLocation((int)this.programBloom3, (CharSequence)"tex");
            this.indexBloom3[1] = GL20.glGetUniformLocation((int)this.programBloom3, (CharSequence)"glow");
            this.indexBloom3[2] = GL20.glGetUniformLocation((int)this.programBloom3, (CharSequence)"hdr");
            GL20.glUniform1i((int)this.indexBloom3[0], (int)0);
            GL20.glUniform1i((int)this.indexBloom3[1], (int)1);
            GL20.glUniform1f((int)this.indexBloom3[2], (float)16.0f);
            GL20.glUseProgram((int)0);
        }
        if (this.normalEnabled) {
            GL20.glUseProgram((int)this.programAux);
            this.indexAux[0] = GL20.glGetUniformLocation((int)this.programAux, (CharSequence)"tex");
            this.indexAux[1] = GL20.glGetUniformLocation((int)this.programAux, (CharSequence)"data");
            GL20.glUniform1i((int)this.indexAux[0], (int)0);
            GL20.glUseProgram((int)0);
        }
        this.enabled = true;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (!this.enabled) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        List<LightAPI> lights = ((LocalData)engine.getCustomData().get((Object)DATA_KEY)).lights;
        if (!engine.isPaused()) {
            Iterator<LightAPI> iter3 = lights.iterator();
            while (iter3.hasNext()) {
                LightAPI light = iter3.next();
                if (!light.advance(amount)) continue;
                iter3.remove();
            }
        }
    }

    @Override
    public void destroy() {
        int i;
        IntBuffer shaders;
        IntBuffer count;
        ByteBuffer shadersbb;
        ByteBuffer countbb;
        if (this.program != 0) {
            countbb = ByteBuffer.allocateDirect(4);
            shadersbb = ByteBuffer.allocateDirect(8);
            count = countbb.asIntBuffer();
            shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.program, (IntBuffer)count, (IntBuffer)shaders);
            for (i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.program);
        }
        if (this.programAux != 0) {
            countbb = ByteBuffer.allocateDirect(4);
            shadersbb = ByteBuffer.allocateDirect(8);
            count = countbb.asIntBuffer();
            shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.programAux, (IntBuffer)count, (IntBuffer)shaders);
            for (i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.programAux);
        }
        if (this.programBloom1 != 0) {
            countbb = ByteBuffer.allocateDirect(4);
            shadersbb = ByteBuffer.allocateDirect(8);
            count = countbb.asIntBuffer();
            shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.programBloom1, (IntBuffer)count, (IntBuffer)shaders);
            for (i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.programBloom1);
        }
        if (this.programBloom2 != 0) {
            countbb = ByteBuffer.allocateDirect(4);
            shadersbb = ByteBuffer.allocateDirect(8);
            count = countbb.asIntBuffer();
            shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.programBloom2, (IntBuffer)count, (IntBuffer)shaders);
            for (i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.programBloom2);
        }
        if (this.programBloom3 != 0) {
            countbb = ByteBuffer.allocateDirect(4);
            shadersbb = ByteBuffer.allocateDirect(8);
            count = countbb.asIntBuffer();
            shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.programBloom3, (IntBuffer)count, (IntBuffer)shaders);
            for (i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.programBloom3);
        }
        if (this.lightTex != 0) {
            GL11.glDeleteTextures((int)this.lightTex);
        }
        if (this.hdrTex != 0) {
            GL11.glDeleteTextures((int)this.hdrTex);
        }
        if (this.hdrTex2 != 0) {
            GL11.glDeleteTextures((int)this.hdrTex2);
        }
        if (this.hdrTex3 != 0) {
            GL11.glDeleteTextures((int)this.hdrTex3);
        }
        if (this.normalTex != 0) {
            GL11.glDeleteTextures((int)this.normalTex);
        }
        if (this.hdrBufferId != 0) {
            if (ShaderLib.useBufferCore()) {
                GL30.glDeleteFramebuffers((int)this.hdrBufferId);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glDeleteFramebuffers((int)this.hdrBufferId);
            } else {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.hdrBufferId);
            }
        }
        if (this.hdrBuffer2Id != 0) {
            if (ShaderLib.useBufferCore()) {
                GL30.glDeleteFramebuffers((int)this.hdrBuffer2Id);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glDeleteFramebuffers((int)this.hdrBuffer2Id);
            } else {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.hdrBuffer2Id);
            }
        }
        if (this.hdrBuffer3Id != 0) {
            if (ShaderLib.useBufferCore()) {
                GL30.glDeleteFramebuffers((int)this.hdrBuffer3Id);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glDeleteFramebuffers((int)this.hdrBuffer3Id);
            } else {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.hdrBuffer3Id);
            }
        }
        if (this.normalBufferId != 0) {
            if (ShaderLib.useBufferCore()) {
                GL30.glDeleteFramebuffers((int)this.normalBufferId);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glDeleteFramebuffers((int)this.normalBufferId);
            } else {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.normalBufferId);
            }
        }
    }

    @Override
    public ShaderAPI.RenderOrder getRenderOrder() {
        return ShaderAPI.RenderOrder.OBJECT_SPACE;
    }

    @Override
    public void initCombat() {
        Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void renderInScreenCoords(ViewportAPI viewport) {
    }

    @Override
    public void renderInWorldCoords(ViewportAPI viewport) {
        LightAPI light;
        if (!this.enabled) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        LocalData localData = (LocalData)engine.getCustomData().get(DATA_KEY);
        List<LightAPI> lights = localData.lights;
        Set<BeamAPI> beams = localData.beams;
        Map<DamagingProjectileAPI, Boolean> projectiles = localData.projectiles;
        List allProjectiles = engine.getProjectiles();
        int size = allProjectiles.size();
        for (int i = 0; i < size; ++i) {
            StandardLight light2;
            DamagingProjectileAPI proj = (DamagingProjectileAPI)allProjectiles.get(i);
            if (proj.didDamage() || proj.getElapsed() > 0.1f || projectiles.containsKey(proj)) continue;
            projectiles.put(proj, false);
            if (!LightData.projectileLightData.containsKey(proj.getProjectileSpecId())) continue;
            LightEntry data = LightData.projectileLightData.get(proj.getProjectileSpecId());
            if (data.hasStandard && (float)Math.random() <= data.chance) {
                light2 = proj.getSource() != null && proj.getSource().getHullSize() == ShipAPI.HullSize.FIGHTER && data.fighterDim ? new StandardLight(ZERO, ZERO, ZERO, (CombatEntityAPI)proj, data.standardIntensity * this.fighterLightMultiplier, data.standardSize * this.fighterLightMultiplier) : new StandardLight(ZERO, ZERO, new Vector2f(-data.standardOffset, 0.0f), (CombatEntityAPI)proj, data.standardIntensity, data.standardSize);
                light2.setColor(data.standardColor);
                light2.setAutoFadeOutTime(data.standardFadeout);
                light2.setHeight(this.standardHeight);
                lights.add(light2);
            }
            if (!data.hasFlash || !((float)Math.random() <= data.chance)) continue;
            if (Float.compare(data.flashOffset, 0.0f) != 0) {
                double facing = (double)proj.getFacing() - 180.0;
                if (facing < 0.0) {
                    facing += 360.0;
                }
                facing = Math.toRadians(facing);
                tempVec.set((float)ShaderLib.fastCos(facing), (float)ShaderLib.fastSin(facing));
                tempVec.scale(data.flashOffset);
                Vector2f.add((Vector2f)proj.getLocation(), (Vector2f)tempVec, (Vector2f)tempVec);
                light2 = new StandardLight(tempVec, ZERO, ZERO, null);
            } else {
                light2 = new StandardLight(proj.getLocation(), ZERO, ZERO, null);
            }
            if (proj.getSource() != null && proj.getSource().getHullSize() == ShipAPI.HullSize.FIGHTER && data.fighterDim) {
                light2.setIntensity(data.flashIntensity * this.fighterLightMultiplier);
                light2.setSize(data.flashSize * this.fighterLightMultiplier);
            } else {
                light2.setIntensity(data.flashIntensity);
                light2.setSize(data.flashSize);
            }
            light2.setColor(data.flashColor);
            light2.fadeOut(data.flashFadeout);
            light2.setHeight(this.flashHeight);
            lights.add(light2);
        }
        Iterator<Map.Entry<DamagingProjectileAPI, Boolean>> iter1 = projectiles.entrySet().iterator();
        while (iter1.hasNext()) {
            Object missile;
            Map.Entry<DamagingProjectileAPI, Boolean> entry = iter1.next();
            DamagingProjectileAPI proj = entry.getKey();
            boolean boom = proj.didDamage();
            boolean isMine = false;
            if (proj instanceof MissileAPI && (missile = (MissileAPI)proj).isMine()) {
                isMine = true;
                if (missile.getUntilMineExplosion() <= 0.033333335f && !engine.isEntityInPlay((CombatEntityAPI)missile)) {
                    boom = true;
                }
            }
            if (!entry.getValue().booleanValue() && (proj.isFading() && !isMine || !engine.isEntityInPlay((CombatEntityAPI)proj) && !boom || proj instanceof MissileAPI && ((MissileAPI)proj).isFizzling() && !isMine)) {
                entry.setValue(true);
                missile = lights.iterator();
                while (missile.hasNext()) {
                    StandardLight sLight;
                    LightAPI light3 = (LightAPI)missile.next();
                    if (!(light3 instanceof StandardLight) || (sLight = (StandardLight)light3).getAttachment() != proj) continue;
                    if (!engine.isEntityInPlay((CombatEntityAPI)proj)) {
                        sLight.unattach();
                        sLight.setLocation(proj.getLocation());
                    }
                    sLight.fadeOut(sLight.getAutoFadeOutTime());
                }
            }
            if (boom) {
                LightAPI light4;
                LightEntry data = null;
                if (LightData.projectileLightData.containsKey(proj.getProjectileSpecId())) {
                    data = LightData.projectileLightData.get(proj.getProjectileSpecId());
                }
                boolean hadAttachment = false;
                float currentFactor = 1.0f;
                Iterator<LightAPI> iter2 = lights.iterator();
                while (iter2.hasNext()) {
                    StandardLight sLight;
                    light4 = iter2.next();
                    if (!(light4 instanceof StandardLight) || (sLight = (StandardLight)light4).getAttachment() != proj) continue;
                    hadAttachment = true;
                    if (data == null || !data.hasHit) {
                        sLight.unattach();
                        sLight.setLocation(proj.getLocation());
                        sLight.fadeOut(sLight.getAutoFadeOutTime());
                        continue;
                    }
                    if (!(proj instanceof MissileAPI)) {
                        currentFactor = sLight.getIntensity() / data.standardIntensity;
                    }
                    sLight.unattach();
                    iter2.remove();
                }
                if (data != null && data.hasHit && ((float)Math.random() <= data.chance || hadAttachment) && (proj.getDamageTarget() != null || isMine)) {
                    light4 = new StandardLight(proj.getLocation(), ZERO, ZERO, null);
                    if (proj.getSource() != null && proj.getSource().getHullSize() == ShipAPI.HullSize.FIGHTER && data.fighterDim) {
                        ((StandardLight)light4).setIntensity(data.hitIntensity * this.fighterLightMultiplier * currentFactor);
                        ((StandardLight)light4).setSize(data.hitSize * this.fighterLightMultiplier * currentFactor);
                    } else {
                        ((StandardLight)light4).setIntensity(data.hitIntensity * currentFactor);
                        ((StandardLight)light4).setSize(data.hitSize * currentFactor);
                    }
                    ((StandardLight)light4).setColor(data.hitColor);
                    ((StandardLight)light4).fadeOut(data.hitFadeout * currentFactor);
                    ((StandardLight)light4).setHeight(this.standardHeight);
                    lights.add(light4);
                }
                iter1.remove();
                continue;
            }
            if (engine.isEntityInPlay((CombatEntityAPI)proj)) continue;
            iter1.remove();
        }
        List allBeams = engine.getBeams();
        size = allBeams.size();
        for (int i = 0; i < size; ++i) {
            BeamAPI beam = (BeamAPI)allBeams.get(i);
            if (beam.getBrightness() <= 0.0f || beams.contains(beam)) continue;
            beams.add(beam);
            if (!LightData.beamLightData.containsKey(beam.getWeapon().getId())) continue;
            LightEntry data = LightData.beamLightData.get(beam.getWeapon().getId());
            if (!((float)Math.random() <= data.chance)) continue;
            if (data.hasStandard) {
                light = new StandardLight(ZERO, ZERO, ZERO, ZERO, beam);
                if (beam.getSource() != null && beam.getSource().getHullSize() == ShipAPI.HullSize.FIGHTER && data.fighterDim) {
                    ((StandardLight)light).setIntensity(data.standardIntensity * this.fighterLightMultiplier);
                    ((StandardLight)light).setSize(data.standardSize * this.fighterLightMultiplier);
                } else {
                    ((StandardLight)light).setIntensity(data.standardIntensity);
                    ((StandardLight)light).setSize(data.standardSize);
                }
                ((StandardLight)light).setColor(data.standardColor);
                ((StandardLight)light).setHeight(this.standardHeight);
                ((StandardLight)light).makePermanent();
                lights.add(light);
            }
            if (data.hasFlash) {
                light = new StandardLight(ZERO, ZERO, beam, false);
                if (beam.getSource() != null && beam.getSource().getHullSize() == ShipAPI.HullSize.FIGHTER && data.fighterDim) {
                    ((StandardLight)light).setIntensity(data.flashIntensity * this.fighterLightMultiplier);
                    ((StandardLight)light).setSize(data.flashSize * this.fighterLightMultiplier);
                } else {
                    ((StandardLight)light).setIntensity(data.flashIntensity);
                    ((StandardLight)light).setSize(data.flashSize);
                }
                ((StandardLight)light).setColor(data.flashColor);
                ((StandardLight)light).setHeight(this.flashHeight);
                ((StandardLight)light).makePermanent();
                lights.add(light);
            }
            if (!data.hasHit) continue;
            light = new StandardLight(ZERO, ZERO, beam, true);
            if (beam.getSource() != null && beam.getSource().getHullSize() == ShipAPI.HullSize.FIGHTER && data.fighterDim) {
                ((StandardLight)light).setIntensity(data.hitIntensity * this.fighterLightMultiplier);
                ((StandardLight)light).setSize(data.hitSize * this.fighterLightMultiplier);
            } else {
                ((StandardLight)light).setIntensity(data.hitIntensity);
                ((StandardLight)light).setSize(data.hitSize);
            }
            ((StandardLight)light).setColor(data.hitColor);
            ((StandardLight)light).setHeight(this.standardHeight);
            ((StandardLight)light).makePermanent();
            lights.add(light);
        }
        Iterator<BeamAPI> iter2 = beams.iterator();
        while (iter2.hasNext()) {
            BeamAPI beam = iter2.next();
            if (!(beam.getBrightness() <= 0.0f)) continue;
            Iterator<LightAPI> iter3 = lights.iterator();
            while (iter3.hasNext()) {
                StandardLight sLight;
                light = iter3.next();
                if (!(light instanceof StandardLight) || (sLight = (StandardLight)light).getBeamLink() != beam) continue;
                sLight.unattach();
                iter3.remove();
            }
            iter2.remove();
        }
        Collections.sort(lights, LIGHTSIZE);
        this.drawLights(viewport);
    }

    private void drawLights(ViewportAPI viewport) {
        Vector2f normI;
        Vector2f normS;
        Vector2f normH;
        Vector2f normY2;
        Vector2f normX2;
        Vector2f normY;
        Vector2f normX;
        if (ShaderLib.isForegroundEmpty(viewport)) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        List<LightAPI> lights = ((LocalData)engine.getCustomData().get((Object)DATA_KEY)).lights;
        if (this.normalEnabled) {
            this.drawNormalMaps(viewport);
            this.drawSurfaceMaps(viewport);
        }
        ShaderLib.beginDraw(this.program);
        Vector2f maxCoords = null;
        Vector2f minCoords = null;
        Vector2f maxCoords2 = null;
        Vector2f minCoords2 = null;
        float maxSize = 0.0f;
        float maxIntensity = 0.0f;
        float minHeight = 0.0f;
        float maxHeight = 0.0f;
        int lightCount = 0;
        int lineLightCount = 0;
        float[] bufferPut = new float[11];
        for (LightAPI light : lights) {
            float size = Math.max(light.getSize() * this.lightSizeMultiplier, 0.0f);
            int type = light.getType();
            if (lineLightCount >= this.maxLineLights && type == 1 || (type == 1 ? !ShaderLib.isOnScreen(light.getLocation(), light.getLocation2(), size) : type != 3 && !ShaderLib.isOnScreen(light.getLocation(), size))) continue;
            switch (type) {
                case 0: {
                    Vector2f coords = ShaderLib.transformScreenToUV(ShaderLib.transformWorldToScreen(light.getLocation()));
                    size = ShaderLib.unitsToUV(size);
                    float height = ShaderLib.unitsToUV(Math.max(light.getHeight(), light.getSize() * this.lightDepth));
                    float intensity = Math.max(light.getIntensity() * this.lightMultiplier, 0.0f);
                    float specularIntensity = Math.max(light.getSpecularMult() * light.getIntensity() * this.lightMultiplier, 0.0f);
                    if (maxCoords == null || minCoords == null) {
                        maxCoords = new Vector2f((ReadableVector2f)coords);
                        minCoords = new Vector2f((ReadableVector2f)coords);
                    } else {
                        if (coords.x > maxCoords.x) {
                            maxCoords.x = coords.x;
                        } else if (coords.x < minCoords.x) {
                            minCoords.x = coords.x;
                        }
                        if (coords.y > maxCoords.y) {
                            maxCoords.y = coords.y;
                        } else if (coords.y < minCoords.y) {
                            minCoords.y = coords.y;
                        }
                    }
                    if (maxCoords2 == null || minCoords2 == null) {
                        maxCoords2 = new Vector2f(specularIntensity, 0.5f);
                        minCoords2 = new Vector2f(specularIntensity, 0.5f);
                    } else if (specularIntensity > maxCoords2.x) {
                        maxCoords2.x = specularIntensity;
                    } else if (specularIntensity < minCoords2.x) {
                        minCoords2.x = specularIntensity;
                    }
                    if (size > maxSize) {
                        maxSize = size;
                    }
                    if (intensity > maxIntensity) {
                        maxIntensity = intensity;
                    }
                    if (height > maxHeight) {
                        maxHeight = height;
                    } else if (height < minHeight) {
                        minHeight = height;
                    }
                    bufferPut[0] = coords.x;
                    bufferPut[1] = coords.y;
                    bufferPut[2] = light.getColor().x;
                    bufferPut[3] = light.getColor().y;
                    bufferPut[4] = light.getColor().z;
                    bufferPut[5] = size;
                    bufferPut[6] = intensity;
                    bufferPut[7] = 0.0f;
                    bufferPut[8] = specularIntensity;
                    bufferPut[10] = height;
                    this.dataBufferPre.put(bufferPut);
                    break;
                }
                case 1: {
                    Vector2f coords = ShaderLib.transformScreenToUV(ShaderLib.transformWorldToScreen(light.getLocation()));
                    Vector2f coords2 = ShaderLib.transformScreenToUV(ShaderLib.transformWorldToScreen(light.getLocation2()));
                    size = ShaderLib.unitsToUV(size);
                    float height = ShaderLib.unitsToUV(Math.max(light.getHeight(), light.getSize() * this.lightDepth));
                    float intensity = Math.max(light.getIntensity() * this.lightMultiplier, 0.0f);
                    if (maxCoords == null || minCoords == null) {
                        maxCoords = new Vector2f((ReadableVector2f)coords);
                        minCoords = new Vector2f((ReadableVector2f)coords);
                    } else {
                        if (coords.x > maxCoords.x) {
                            maxCoords.x = coords.x;
                        } else if (coords.x < minCoords.x) {
                            minCoords.x = coords.x;
                        }
                        if (coords.y > maxCoords.y) {
                            maxCoords.y = coords.y;
                        } else if (coords.y < minCoords.y) {
                            minCoords.y = coords.y;
                        }
                    }
                    if (maxCoords2 == null || minCoords2 == null) {
                        maxCoords2 = new Vector2f((ReadableVector2f)coords2);
                        minCoords2 = new Vector2f((ReadableVector2f)coords2);
                    } else {
                        if (coords2.x > maxCoords2.x) {
                            maxCoords2.x = coords2.x;
                        } else if (coords2.x < minCoords2.x) {
                            minCoords2.x = coords2.x;
                        }
                        if (coords2.y > maxCoords2.y) {
                            maxCoords2.y = coords2.y;
                        } else if (coords2.y < minCoords2.y) {
                            minCoords2.y = coords2.y;
                        }
                    }
                    if (size > maxSize) {
                        maxSize = size;
                    }
                    if (intensity > maxIntensity) {
                        maxIntensity = intensity;
                    }
                    if (height > maxHeight) {
                        maxHeight = height;
                    } else if (height < minHeight) {
                        minHeight = height;
                    }
                    bufferPut[0] = coords.x;
                    bufferPut[1] = coords.y;
                    bufferPut[2] = light.getColor().x;
                    bufferPut[3] = light.getColor().y;
                    bufferPut[4] = light.getColor().z;
                    bufferPut[5] = size;
                    bufferPut[6] = intensity;
                    bufferPut[7] = 0.33f;
                    bufferPut[8] = coords2.x;
                    bufferPut[9] = coords2.y;
                    bufferPut[10] = height;
                    this.dataBufferPre.put(bufferPut);
                    break;
                }
                case 2: {
                    Vector2f coords = ShaderLib.transformScreenToUV(ShaderLib.transformWorldToScreen(light.getLocation()));
                    float anglesx = (float)Math.toRadians(light.getArcStart());
                    float anglesy = (float)Math.toRadians(light.getArcEnd());
                    size = ShaderLib.unitsToUV(size);
                    float height = ShaderLib.unitsToUV(Math.max(light.getHeight(), light.getSize() * this.lightDepth));
                    float intensity = Math.max(light.getIntensity() * this.lightMultiplier, 0.0f);
                    if (maxCoords == null || minCoords == null) {
                        maxCoords = new Vector2f((ReadableVector2f)coords);
                        minCoords = new Vector2f((ReadableVector2f)coords);
                    } else {
                        if (coords.x > maxCoords.x) {
                            maxCoords.x = coords.x;
                        } else if (coords.x < minCoords.x) {
                            minCoords.x = coords.x;
                        }
                        if (coords.y > maxCoords.y) {
                            maxCoords.y = coords.y;
                        } else if (coords.y < minCoords.y) {
                            minCoords.y = coords.y;
                        }
                    }
                    if (maxCoords2 == null || minCoords2 == null) {
                        maxCoords2 = new Vector2f(anglesx, anglesy);
                        minCoords2 = new Vector2f(anglesx, anglesy);
                    } else {
                        if (anglesx > maxCoords2.x) {
                            maxCoords2.x = anglesx;
                        } else if (anglesx < minCoords2.x) {
                            minCoords2.x = anglesx;
                        }
                        if (anglesy > maxCoords2.y) {
                            maxCoords2.y = anglesy;
                        } else if (anglesy < minCoords2.y) {
                            minCoords2.y = anglesy;
                        }
                    }
                    if (size > maxSize) {
                        maxSize = size;
                    }
                    if (intensity > maxIntensity) {
                        maxIntensity = intensity;
                    }
                    if (height > maxHeight) {
                        maxHeight = height;
                    } else if (height < minHeight) {
                        minHeight = height;
                    }
                    bufferPut[0] = coords.x;
                    bufferPut[1] = coords.y;
                    bufferPut[2] = light.getColor().x;
                    bufferPut[3] = light.getColor().y;
                    bufferPut[4] = light.getColor().z;
                    bufferPut[5] = size;
                    bufferPut[6] = intensity;
                    bufferPut[7] = 0.67f;
                    bufferPut[8] = anglesx;
                    bufferPut[9] = anglesy;
                    bufferPut[10] = height;
                    this.dataBufferPre.put(bufferPut);
                    break;
                }
                default: {
                    float directionx = light.getDirection().x;
                    float directiony = light.getDirection().y;
                    float directionz = light.getDirection().z;
                    float intensity = Math.max(light.getIntensity() * this.lightMultiplier, 0.0f);
                    float specularIntensity = Math.max(light.getSpecularIntensity() * this.lightMultiplier, 0.0f);
                    if (maxCoords == null || minCoords == null) {
                        maxCoords = new Vector2f(directionx, directiony);
                        minCoords = new Vector2f(directionx, directiony);
                    } else {
                        if (directionx > maxCoords.x) {
                            maxCoords.x = directionx;
                        } else if (directionx < minCoords.x) {
                            minCoords.x = directionx;
                        }
                        if (directiony > maxCoords.y) {
                            maxCoords.y = directiony;
                        } else if (directiony < minCoords.y) {
                            minCoords.y = directiony;
                        }
                    }
                    if (maxCoords2 == null || minCoords2 == null) {
                        maxCoords2 = new Vector2f(directionz, 0.5f);
                        minCoords2 = new Vector2f(directionz, 0.5f);
                    } else if (directionz > maxCoords2.x) {
                        maxCoords2.x = directionz;
                    } else if (directionz < minCoords2.x) {
                        minCoords2.x = directionz;
                    }
                    if (specularIntensity > maxSize) {
                        maxSize = specularIntensity;
                    }
                    if (intensity > maxIntensity) {
                        maxIntensity = intensity;
                    }
                    bufferPut[0] = directionx;
                    bufferPut[1] = directiony;
                    bufferPut[2] = light.getColor().x;
                    bufferPut[3] = light.getColor().y;
                    bufferPut[4] = light.getColor().z;
                    bufferPut[5] = specularIntensity;
                    bufferPut[6] = intensity;
                    bufferPut[7] = 1.0f;
                    bufferPut[8] = directionz;
                    this.dataBufferPre.put(bufferPut);
                    break;
                }
            }
            if (type == 1) {
                ++lineLightCount;
            }
            if (++lightCount < Math.min(this.maxLights, 372)) continue;
            break;
        }
        if (lightCount <= 0 || minCoords == null || maxCoords == null || minCoords2 == null || maxCoords2 == null) {
            normX = ZERO;
            normY = ZERO;
            normX2 = ZERO;
            normY2 = ZERO;
            normH = ZERO;
            normS = ZERO;
            normI = ZERO;
            lightCount = 0;
        } else {
            normX = ShaderLib.getTextureDataNormalization(minCoords.x, maxCoords.x);
            normY = ShaderLib.getTextureDataNormalization(minCoords.y, maxCoords.y);
            normX2 = ShaderLib.getTextureDataNormalization(minCoords2.x, maxCoords2.x);
            normY2 = ShaderLib.getTextureDataNormalization(minCoords2.y, maxCoords2.y);
            normH = ShaderLib.getTextureDataNormalization(minHeight, maxHeight);
            normS = ShaderLib.getTextureDataNormalization(0.0f, maxSize);
            normI = ShaderLib.getTextureDataNormalization(0.0f, maxIntensity);
            this.dataBufferPre.flip();
            int size = lightCount * 11;
            block15: for (int i = 0; i < size; ++i) {
                switch (i % 11) {
                    case 0: {
                        this.dataBuffer.put((this.dataBufferPre.get() - normX.y) / normX.x);
                        continue block15;
                    }
                    case 1: {
                        this.dataBuffer.put((this.dataBufferPre.get() - normY.y) / normY.x);
                        continue block15;
                    }
                    case 8: {
                        this.dataBuffer.put((this.dataBufferPre.get() - normX2.y) / normX2.x);
                        continue block15;
                    }
                    case 9: {
                        this.dataBuffer.put((this.dataBufferPre.get() - normY2.y) / normY2.x);
                        continue block15;
                    }
                    case 10: {
                        this.dataBuffer.put((this.dataBufferPre.get() - normH.y) / normH.x);
                        continue block15;
                    }
                    case 5: {
                        this.dataBuffer.put(this.dataBufferPre.get() / normS.x);
                        continue block15;
                    }
                    case 6: {
                        this.dataBuffer.put(this.dataBufferPre.get() / normI.x);
                        continue block15;
                    }
                    default: {
                        this.dataBuffer.put(this.dataBufferPre.get());
                    }
                }
            }
        }
        this.dataBuffer.flip();
        GL11.glBindTexture((int)3552, (int)this.lightTex);
        GL11.glTexSubImage1D((int)3552, (int)0, (int)0, (int)this.dataBuffer.remaining(), (int)6403, (int)5126, (FloatBuffer)this.dataBuffer);
        GL11.glTexParameteri((int)3552, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3552, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3552, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3552, (int)10243, (int)10496);
        GL20.glUniform1i((int)this.index[4], (int)lightCount);
        GL20.glUniform4f((int)this.index[5], (float)normX.x, (float)normX.y, (float)normY.x, (float)normY.y);
        GL20.glUniform4f((int)this.index[6], (float)normS.x, (float)normI.x, (float)normH.x, (float)normH.y);
        GL20.glUniform4f((int)this.index[7], (float)normX2.x, (float)normX2.y, (float)normY2.x, (float)normY2.y);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)ShaderLib.getScreenTexture());
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)ShaderLib.getForegroundTexture(viewport));
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3552, (int)this.lightTex);
        if (this.normalEnabled) {
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)this.normalTex);
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)ShaderLib.getAuxiliaryBufferTexture());
        }
        if (!this.validated) {
            this.validated = true;
            GL20.glValidateProgram((int)this.program);
            if (GL20.glGetProgrami((int)this.program, (int)35715) == 0) {
                Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.program));
                ShaderLib.exitDraw();
                this.dataBuffer.clear();
                this.dataBufferPre.clear();
                this.enabled = false;
                return;
            }
        }
        if (this.bloomEnabled) {
            ShaderLib.copyScreen(ShaderLib.getScreenTexture(), 33984);
            if (ShaderLib.useBufferCore()) {
                GL30.glBindFramebuffer((int)36160, (int)this.hdrBufferId);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glBindFramebuffer((int)36160, (int)this.hdrBufferId);
            } else {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.hdrBufferId);
            }
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GL11.glClear((int)16384);
            GL11.glDisable((int)3042);
            ShaderLib.drawScreenQuad(1.0f);
            ShaderLib.exitDraw();
            ShaderLib.beginDraw(this.programBloom1);
            if (ShaderLib.useBufferCore()) {
                GL30.glBindFramebuffer((int)36160, (int)this.hdrBuffer2Id);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glBindFramebuffer((int)36160, (int)this.hdrBuffer2Id);
            } else {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.hdrBuffer2Id);
            }
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GL11.glClear((int)16384);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)this.hdrTex);
            if (!this.validatedBloom1) {
                this.validatedBloom1 = true;
                GL20.glValidateProgram((int)this.programBloom1);
                if (GL20.glGetProgrami((int)this.programBloom1, (int)35715) == 0) {
                    Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.programBloom1));
                    if (ShaderLib.useBufferCore()) {
                        GL30.glBindFramebuffer((int)36160, (int)0);
                    } else if (ShaderLib.useBufferARB()) {
                        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
                    } else {
                        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                    }
                    ShaderLib.exitDraw();
                    this.dataBuffer.clear();
                    this.dataBufferPre.clear();
                    this.bloomEnabled = false;
                    return;
                }
            }
            GL11.glDisable((int)3042);
            ShaderLib.drawScreenQuad(1.0f / (float)Math.pow(2.0, this.bloomMips - 1));
            ShaderLib.exitDraw();
            ShaderLib.beginDraw(this.programBloom2);
            if (ShaderLib.useBufferCore()) {
                GL30.glBindFramebuffer((int)36160, (int)this.hdrBuffer3Id);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glBindFramebuffer((int)36160, (int)this.hdrBuffer3Id);
            } else {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.hdrBuffer3Id);
            }
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GL11.glClear((int)16384);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)this.hdrTex2);
            if (!this.validatedBloom2) {
                this.validatedBloom2 = true;
                GL20.glValidateProgram((int)this.programBloom2);
                if (GL20.glGetProgrami((int)this.programBloom2, (int)35715) == 0) {
                    Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.programBloom2));
                    if (ShaderLib.useBufferCore()) {
                        GL30.glBindFramebuffer((int)36160, (int)0);
                    } else if (ShaderLib.useBufferARB()) {
                        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
                    } else {
                        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                    }
                    ShaderLib.exitDraw();
                    this.dataBuffer.clear();
                    this.dataBufferPre.clear();
                    this.bloomEnabled = false;
                    return;
                }
            }
            GL11.glDisable((int)3042);
            ShaderLib.drawScreenQuad(1.0f / (float)Math.pow(2.0, this.bloomMips - 1));
            ShaderLib.exitDraw();
            ShaderLib.beginDraw(this.programBloom3);
            if (ShaderLib.useBufferCore()) {
                GL30.glBindFramebuffer((int)36160, (int)0);
            } else if (ShaderLib.useBufferARB()) {
                ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
            } else {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
            }
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)this.hdrTex);
            GL13.glActiveTexture((int)33985);
            GL11.glBindTexture((int)3553, (int)this.hdrTex3);
            if (!this.validatedBloom3) {
                this.validatedBloom3 = true;
                GL20.glValidateProgram((int)this.programBloom3);
                if (GL20.glGetProgrami((int)this.programBloom3, (int)35715) == 0) {
                    Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.programBloom3));
                    ShaderLib.exitDraw();
                    this.dataBuffer.clear();
                    this.dataBufferPre.clear();
                    this.bloomEnabled = false;
                    return;
                }
            }
            GL11.glDisable((int)3042);
            ShaderLib.drawScreenQuad(1.0f);
        } else {
            GL11.glDisable((int)3042);
            ShaderLib.screenDraw(ShaderLib.getScreenTexture(), 33984);
        }
        ShaderLib.exitDraw();
        this.dataBuffer.clear();
        this.dataBufferPre.clear();
    }

    private void drawNormalMaps(ViewportAPI viewport) {
        float uniformAngle;
        GL20.glUseProgram((int)this.programAux);
        GL11.glPushAttrib((int)1048575);
        if (ShaderLib.useBufferCore()) {
            GL30.glBindFramebuffer((int)36160, (int)this.normalBufferId);
        } else if (ShaderLib.useBufferARB()) {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)this.normalBufferId);
        } else {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.normalBufferId);
        }
        GL11.glViewport((int)0, (int)0, (int)((int)(Global.getSettings().getScreenWidth() * Display.getPixelScaleFactor())), (int)((int)(Global.getSettings().getScreenHeight() * Display.getPixelScaleFactor())));
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)viewport.getLLX(), (double)(viewport.getLLX() + viewport.getVisibleWidth()), (double)viewport.getLLY(), (double)(viewport.getLLY() + viewport.getVisibleHeight()), (double)-2000.0, (double)2000.0);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glClear((int)16384);
        List asteroids = Global.getCombatEngine().getAsteroids();
        int size = asteroids.size();
        for (int i = 0; i < size; ++i) {
            float uniformFlatness;
            boolean hasNormal;
            SpriteAPI sprite;
            CombatEntityAPI asteroid = (CombatEntityAPI)asteroids.get(i);
            Vector2f asteroidLocation = asteroid.getLocation();
            if (!ShaderLib.isOnScreen(asteroidLocation, 100.0f)) continue;
            CombatAsteroidAPI assteroid = (CombatAsteroidAPI)asteroid;
            SpriteAPI asteroidSprite = assteroid.getSpriteAPI();
            String asteroidType = ShaderModPlugin.ASTEROID_MAP.get(asteroidSprite.getTextureId());
            if (asteroidType == null) {
                asteroidType = "nil";
            }
            TextureEntry entry = TextureData.getTextureData(asteroidType, TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.ASTEROID, 0);
            float depth = 1.0f;
            if (entry != null) {
                sprite = entry.sprite;
                sprite.setAngle(asteroidSprite.getAngle());
                sprite.setSize(asteroidSprite.getWidth(), asteroidSprite.getHeight());
                sprite.setCenter(asteroidSprite.getCenterX(), asteroidSprite.getCenterY());
                sprite.setAlphaMult(asteroidSprite.getAlphaMult());
                depth = entry.magnitude;
                hasNormal = true;
            } else {
                sprite = asteroidSprite;
                hasNormal = false;
            }
            uniformAngle = asteroidSprite.getAngle();
            float f = uniformFlatness = hasNormal ? 1.0f - (1.0f - this.flatness) * depth : 2.0f;
            if (uniformAngle != this.lastAngle || uniformFlatness != this.lastFlatness) {
                this.lastAngle = uniformAngle;
                this.lastFlatness = uniformFlatness;
                GL20.glUniform2f((int)this.indexAux[1], (float)uniformAngle, (float)uniformFlatness);
            }
            if (!this.validatedAux) {
                this.validatedAux = true;
                GL20.glValidateProgram((int)this.programAux);
                if (GL20.glGetProgrami((int)this.programAux, (int)35715) == 0) {
                    Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.programAux));
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5890);
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5889);
                    GL11.glPopMatrix();
                    if (ShaderLib.useBufferCore()) {
                        GL30.glBindFramebuffer((int)36160, (int)0);
                    } else if (ShaderLib.useBufferARB()) {
                        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
                    } else {
                        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                    }
                    GL11.glPopAttrib();
                    GL11.glViewport((int)0, (int)0, (int)((int)(Global.getSettings().getScreenWidth() * Display.getPixelScaleFactor())), (int)((int)(Global.getSettings().getScreenHeight() * Display.getPixelScaleFactor())));
                    this.normalEnabled = false;
                    this.enabled = false;
                    return;
                }
            }
            sprite.renderAtCenter(asteroidLocation.x, asteroidLocation.y);
        }
        List ships = Global.getCombatEngine().getShips();
        Collections.sort(ships, ShaderLib.SHIP_DRAW_ORDER);
        size = ships.size();
        for (int i = 0; i < size; ++i) {
            int j;
            BoundsAPI bounds;
            float uniformFlatness;
            boolean hasNormal;
            SpriteAPI sprite;
            ShipAPI ship = (ShipAPI)ships.get(i);
            Vector2f shipLocation = ship.getLocation();
            if (!ShaderLib.isOnScreen(shipLocation, 1.25f * ship.getCollisionRadius())) continue;
            TextureEntry entry = ShaderLib.getShipTexture(ship, TextureData.TextureDataType.NORMAL_MAP);
            float depth = 1.0f;
            SpriteAPI originalSprite = ship.getSpriteAPI();
            if (entry != null) {
                sprite = entry.sprite;
                sprite.setAngle(originalSprite.getAngle());
                sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                sprite.setAlphaMult(ship.getCombinedAlphaMult());
                depth = entry.magnitude;
                hasNormal = true;
            } else {
                sprite = originalSprite;
                hasNormal = false;
            }
            float uniformAngle2 = originalSprite.getAngle();
            float f = uniformFlatness = hasNormal ? 1.0f - (1.0f - this.flatness) * depth : 2.0f;
            if (uniformAngle2 != this.lastAngle || uniformFlatness != this.lastFlatness) {
                this.lastAngle = uniformAngle2;
                this.lastFlatness = uniformFlatness;
                GL20.glUniform2f((int)this.indexAux[1], (float)uniformAngle2, (float)uniformFlatness);
            }
            if (!this.validatedAux) {
                this.validatedAux = true;
                GL20.glValidateProgram((int)this.programAux);
                if (GL20.glGetProgrami((int)this.programAux, (int)35715) == 0) {
                    Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.programAux));
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5890);
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5889);
                    GL11.glPopMatrix();
                    if (ShaderLib.useBufferCore()) {
                        GL30.glBindFramebuffer((int)36160, (int)0);
                    } else if (ShaderLib.useBufferARB()) {
                        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
                    } else {
                        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                    }
                    GL11.glPopAttrib();
                    GL11.glViewport((int)0, (int)0, (int)((int)(Global.getSettings().getScreenWidth() * Display.getPixelScaleFactor())), (int)((int)(Global.getSettings().getScreenHeight() * Display.getPixelScaleFactor())));
                    this.normalEnabled = false;
                    this.enabled = false;
                    return;
                }
            }
            if ((bounds = ship.getVisualBounds()) != null) {
                bounds.update(ship.getLocation(), ship.getFacing());
                GL11.glEnable((int)2960);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3553);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glStencilFunc((int)519, (int)16, (int)255);
                GL11.glStencilOp((int)7680, (int)7680, (int)7681);
                GL11.glStencilMask((int)255);
                GL11.glClearStencil((int)0);
                GL11.glClear((int)1024);
                Tessellate.render(bounds, 1.0f, 1.0f, 1.0f, ship.getId());
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glStencilFunc((int)514, (int)16, (int)255);
                GL11.glStencilOp((int)7680, (int)7680, (int)7680);
                GL11.glStencilMask((int)0);
                sprite.setBlendFunc(770, 771);
                sprite.renderAtCenter(shipLocation.x, shipLocation.y);
                GL11.glDisable((int)2960);
                GL11.glStencilFunc((int)519, (int)0, (int)255);
            } else {
                sprite.renderAtCenter(shipLocation.x, shipLocation.y);
            }
            Vector2f renderOffset = VectorUtils.rotate((Vector2f)ship.getRenderOffset(), (float)ship.getFacing(), (Vector2f)new Vector2f());
            List weapons = ship.getAllWeapons();
            List emptySlots = ship.getHullSpec().getAllWeaponSlotsCopy();
            int weaponSize = weapons.size();
            block6: for (j = 0; j < weaponSize; ++j) {
                WeaponAPI weapon = (WeaponAPI)weapons.get(j);
                if (emptySlots.remove(weapon.getSlot())) continue;
                Iterator iter = emptySlots.iterator();
                while (iter.hasNext()) {
                    Vector2f weaponLocation;
                    WeaponSlotAPI slot = (WeaponSlotAPI)iter.next();
                    Vector2f slotLocation = Vector2f.add((Vector2f)slot.computePosition((CombatEntityAPI)ship), (Vector2f)renderOffset, (Vector2f)new Vector2f());
                    if (!(MathUtils.getDistance((Vector2f)slotLocation, (Vector2f)(weaponLocation = Vector2f.add((Vector2f)weapon.getLocation(), (Vector2f)renderOffset, (Vector2f)new Vector2f()))) <= 1.0f)) continue;
                    iter.remove();
                    continue block6;
                }
            }
            if (bounds == null) {
                int slotSize = emptySlots.size();
                for (int j2 = 0; j2 < slotSize; ++j2) {
                    WeaponSlotAPI slot = (WeaponSlotAPI)emptySlots.get(j2);
                    if (slot.isDecorative() || slot.isHidden() || slot.isSystemSlot() || slot.getWeaponType() == WeaponAPI.WeaponType.LAUNCH_BAY || slot.isStationModule() || slot.isBuiltIn()) continue;
                    Vector2f slotLocation = Vector2f.add((Vector2f)slot.computePosition((CombatEntityAPI)ship), (Vector2f)renderOffset, (Vector2f)new Vector2f());
                    switch (slot.getSlotSize()) {
                        default: {
                            if (slot.isHardpoint()) {
                                entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT_COVER_SMALL, 0);
                                originalSprite = ship.getSmallHardpointCover();
                                break;
                            }
                            entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET_COVER_SMALL, 0);
                            originalSprite = ship.getSmallTurretCover();
                            break;
                        }
                        case MEDIUM: {
                            if (slot.isHardpoint()) {
                                entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT_COVER_MEDIUM, 0);
                                originalSprite = ship.getMediumHardpointCover();
                                break;
                            }
                            entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET_COVER_MEDIUM, 0);
                            originalSprite = ship.getMediumTurretCover();
                            break;
                        }
                        case LARGE: {
                            if (slot.isHardpoint()) {
                                entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT_COVER_LARGE, 0);
                                originalSprite = ship.getLargeHardpointCover();
                                break;
                            }
                            entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET_COVER_LARGE, 0);
                            originalSprite = ship.getLargeTurretCover();
                        }
                    }
                    if (originalSprite == null || originalSprite.getTextureId() == 0) continue;
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setAngle(slot.getAngle() + ship.getFacing() - 90.0f);
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        depth = entry.magnitude;
                        hasNormal = true;
                    } else {
                        sprite = originalSprite;
                        sprite.setAngle(slot.getAngle() + ship.getFacing() - 90.0f);
                        hasNormal = false;
                    }
                    uniformAngle2 = originalSprite.getAngle();
                    float f2 = uniformFlatness = hasNormal ? 1.0f - (1.0f - this.flatness) * depth : 2.0f;
                    if (uniformAngle2 != this.lastAngle || uniformFlatness != this.lastFlatness) {
                        this.lastAngle = uniformAngle2;
                        this.lastFlatness = uniformFlatness;
                        GL20.glUniform2f((int)this.indexAux[1], (float)uniformAngle2, (float)uniformFlatness);
                    }
                    sprite.renderAtCenter(slotLocation.x, slotLocation.y);
                }
            }
            for (j = 0; j < weaponSize; ++j) {
                WeaponAPI weapon = (WeaponAPI)weapons.get(j);
                if (weapon.getSlot().isHidden()) continue;
                Vector2f weaponLocation = Vector2f.add((Vector2f)weapon.getLocation(), (Vector2f)renderOffset, (Vector2f)new Vector2f());
                if (weapon.getUnderSpriteAPI() != null) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT_UNDER, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT_UNDER, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET_UNDER, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET_UNDER, 0));
                    originalSprite = weapon.getUnderSpriteAPI();
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setAngle(originalSprite.getAngle());
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        depth = entry.magnitude;
                        hasNormal = true;
                    } else {
                        sprite = originalSprite;
                        hasNormal = false;
                    }
                    uniformAngle2 = originalSprite.getAngle();
                    float f3 = uniformFlatness = hasNormal ? 1.0f - (1.0f - this.flatness) * depth : 2.0f;
                    if (uniformAngle2 != this.lastAngle || uniformFlatness != this.lastFlatness) {
                        this.lastAngle = uniformAngle2;
                        this.lastFlatness = uniformFlatness;
                        GL20.glUniform2f((int)this.indexAux[1], (float)uniformAngle2, (float)uniformFlatness);
                    }
                    sprite.renderAtCenter(weaponLocation.x, weaponLocation.y);
                }
                if (weapon.getBarrelSpriteAPI() != null && weapon.isRenderBarrelBelow()) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT_BARREL, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET_BARREL, 0));
                    originalSprite = weapon.getBarrelSpriteAPI();
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        depth = entry.magnitude;
                        hasNormal = true;
                    } else {
                        sprite = originalSprite;
                        hasNormal = false;
                    }
                    uniformAngle2 = originalSprite.getAngle();
                    float f4 = uniformFlatness = hasNormal ? 1.0f - (1.0f - this.flatness) * depth : 2.0f;
                    if (uniformAngle2 != this.lastAngle || uniformFlatness != this.lastFlatness) {
                        this.lastAngle = uniformAngle2;
                        this.lastFlatness = uniformFlatness;
                        GL20.glUniform2f((int)this.indexAux[1], (float)uniformAngle2, (float)uniformFlatness);
                    }
                    weapon.renderBarrel(sprite, weaponLocation, Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                }
                if (weapon.getSprite() != null) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET, 0));
                    originalSprite = weapon.getSprite();
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setAngle(originalSprite.getAngle());
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        depth = entry.magnitude;
                        hasNormal = true;
                    } else {
                        sprite = originalSprite;
                        hasNormal = false;
                    }
                    uniformAngle2 = originalSprite.getAngle();
                    float f5 = uniformFlatness = hasNormal ? 1.0f - (1.0f - this.flatness) * depth : 2.0f;
                    if (uniformAngle2 != this.lastAngle || uniformFlatness != this.lastFlatness) {
                        this.lastAngle = uniformAngle2;
                        this.lastFlatness = uniformFlatness;
                        GL20.glUniform2f((int)this.indexAux[1], (float)uniformAngle2, (float)uniformFlatness);
                    }
                    sprite.renderAtCenter(weaponLocation.x, weaponLocation.y);
                }
                if (weapon.getBarrelSpriteAPI() != null && !weapon.isRenderBarrelBelow()) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.HARDPOINT_BARREL, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.TURRET_BARREL, 0));
                    originalSprite = weapon.getBarrelSpriteAPI();
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        depth = entry.magnitude;
                        hasNormal = true;
                    } else {
                        sprite = originalSprite;
                        hasNormal = false;
                    }
                    uniformAngle2 = originalSprite.getAngle();
                    float f6 = uniformFlatness = hasNormal ? 1.0f - (1.0f - this.flatness) * depth : 2.0f;
                    if (uniformAngle2 != this.lastAngle || uniformFlatness != this.lastFlatness) {
                        this.lastAngle = uniformAngle2;
                        this.lastFlatness = uniformFlatness;
                        GL20.glUniform2f((int)this.indexAux[1], (float)uniformAngle2, (float)uniformFlatness);
                    }
                    weapon.renderBarrel(sprite, weaponLocation, Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                }
                if (weapon.getMissileRenderData() == null || weapon.getMissileRenderData().isEmpty() || weapon.usesAmmo() && weapon.getAmmo() <= 0) continue;
                List msls = weapon.getMissileRenderData();
                int mslSize = msls.size();
                for (int k = 0; k < mslSize; ++k) {
                    MissileRenderDataAPI msl = (MissileRenderDataAPI)msls.get(k);
                    if (msl.getMissileSpecId() == null) continue;
                    Vector2f missileLocation = msl.getMissileCenterLocation();
                    entry = TextureData.getTextureData(msl.getMissileSpecId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.MISSILE, 0);
                    originalSprite = msl.getSprite();
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setAngle(msl.getMissileFacing() - 90.0f);
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()) * msl.getBrightness());
                        depth = entry.magnitude;
                        hasNormal = true;
                    } else {
                        sprite = originalSprite;
                        hasNormal = false;
                    }
                    uniformAngle2 = msl.getMissileFacing() - 90.0f;
                    float f7 = uniformFlatness = hasNormal ? 1.0f - (1.0f - this.flatness) * depth : 2.0f;
                    if (uniformAngle2 != this.lastAngle || uniformFlatness != this.lastFlatness) {
                        this.lastAngle = uniformAngle2;
                        this.lastFlatness = uniformFlatness;
                        GL20.glUniform2f((int)this.indexAux[1], (float)uniformAngle2, (float)uniformFlatness);
                    }
                    sprite.renderAtCenter(missileLocation.x + renderOffset.x, missileLocation.y + renderOffset.y);
                }
            }
        }
        List missiles = Global.getCombatEngine().getMissiles();
        size = missiles.size();
        for (int i = 0; i < size; ++i) {
            float uniformFlatness;
            boolean hasNormal;
            SpriteAPI sprite;
            MissileAPI missile = (MissileAPI)missiles.get(i);
            Vector2f missileLocation = missile.getLocation();
            if (!ShaderLib.isOnScreen(missileLocation, 1.25f * missile.getCollisionRadius()) || missile.getProjectileSpecId() == null) continue;
            TextureEntry entry = TextureData.getTextureData(missile.getProjectileSpecId(), TextureData.TextureDataType.NORMAL_MAP, TextureData.ObjectType.MISSILE, 0);
            float depth = 1.0f;
            SpriteAPI originalSprite = missile.getSpriteAPI();
            if (entry != null) {
                sprite = entry.sprite;
                sprite.setAngle(originalSprite.getAngle());
                sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                sprite.setAlphaMult(originalSprite.getAlphaMult());
                depth = entry.magnitude;
                hasNormal = true;
            } else {
                sprite = originalSprite;
                hasNormal = false;
            }
            uniformAngle = originalSprite.getAngle();
            float f = uniformFlatness = hasNormal ? 1.0f - (1.0f - this.flatness) * depth : 2.0f;
            if (uniformAngle != this.lastAngle || uniformFlatness != this.lastFlatness) {
                this.lastAngle = uniformAngle;
                this.lastFlatness = uniformFlatness;
                GL20.glUniform2f((int)this.indexAux[1], (float)uniformAngle, (float)uniformFlatness);
            }
            if (!this.validatedAux) {
                this.validatedAux = true;
                GL20.glValidateProgram((int)this.programAux);
                if (GL20.glGetProgrami((int)this.programAux, (int)35715) == 0) {
                    Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.programAux));
                    GL11.glMatrixMode((int)5888);
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5890);
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5889);
                    GL11.glPopMatrix();
                    if (ShaderLib.useBufferCore()) {
                        GL30.glBindFramebuffer((int)36160, (int)0);
                    } else if (ShaderLib.useBufferARB()) {
                        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
                    } else {
                        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                    }
                    GL11.glPopAttrib();
                    GL11.glViewport((int)0, (int)0, (int)((int)(Global.getSettings().getScreenWidth() * Display.getPixelScaleFactor())), (int)((int)(Global.getSettings().getScreenHeight() * Display.getPixelScaleFactor())));
                    this.normalEnabled = false;
                    this.enabled = false;
                    return;
                }
            }
            sprite.renderAtCenter(missileLocation.x, missileLocation.y);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5890);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        if (ShaderLib.useBufferCore()) {
            GL30.glBindFramebuffer((int)36160, (int)0);
        } else if (ShaderLib.useBufferARB()) {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        } else {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        }
        GL11.glPopAttrib();
    }

    private void drawSurfaceMaps(ViewportAPI viewport) {
        Color originalColor;
        GL20.glUseProgram((int)0);
        GL11.glPushAttrib((int)1048575);
        if (ShaderLib.useBufferCore()) {
            GL30.glBindFramebuffer((int)36160, (int)ShaderLib.getAuxiliaryBufferId());
        } else if (ShaderLib.useBufferARB()) {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)ShaderLib.getAuxiliaryBufferId());
        } else {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)ShaderLib.getAuxiliaryBufferId());
        }
        GL11.glViewport((int)0, (int)0, (int)((int)(Global.getSettings().getScreenWidth() * Display.getPixelScaleFactor())), (int)((int)(Global.getSettings().getScreenHeight() * Display.getPixelScaleFactor())));
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)viewport.getLLX(), (double)(viewport.getLLX() + viewport.getVisibleWidth()), (double)viewport.getLLY(), (double)(viewport.getLLY() + viewport.getVisibleHeight()), (double)-2000.0, (double)2000.0);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glClear((int)16384);
        List asteroids = Global.getCombatEngine().getAsteroids();
        int size = asteroids.size();
        for (int i = 0; i < size; ++i) {
            SpriteAPI sprite;
            TextureEntry entry;
            CombatEntityAPI asteroid = (CombatEntityAPI)asteroids.get(i);
            Vector2f asteroidLocation = asteroid.getLocation();
            if (!ShaderLib.isOnScreen(asteroidLocation, 100.0f)) continue;
            CombatAsteroidAPI assteroid = (CombatAsteroidAPI)asteroid;
            SpriteAPI asteroidSprite = assteroid.getSpriteAPI();
            String asteroidType = ShaderModPlugin.ASTEROID_MAP.get(asteroidSprite.getTextureId());
            if (asteroidType == null) {
                asteroidType = "nil";
            }
            if ((entry = TextureData.getTextureData(asteroidType, TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.ASTEROID, 0)) != null) {
                sprite = entry.sprite;
                sprite.setAngle(asteroidSprite.getAngle());
                sprite.setSize(asteroidSprite.getWidth(), asteroidSprite.getHeight());
                sprite.setCenter(asteroidSprite.getCenterX(), asteroidSprite.getCenterY());
                sprite.setAlphaMult(asteroidSprite.getAlphaMult());
                sprite.renderAtCenter(asteroidLocation.x, asteroidLocation.y);
                continue;
            }
            sprite = asteroidSprite;
            originalColor = sprite.getColor();
            sprite.setColor(Color.BLACK);
            sprite.renderAtCenter(asteroidLocation.x, asteroidLocation.y);
            sprite.setColor(originalColor);
        }
        List ships = Global.getCombatEngine().getShips();
        Collections.sort(ships, ShaderLib.SHIP_DRAW_ORDER);
        size = ships.size();
        for (int i = 0; i < size; ++i) {
            int j;
            BoundsAPI bounds;
            SpriteAPI sprite;
            ShipAPI ship = (ShipAPI)ships.get(i);
            Vector2f shipLocation = ship.getLocation();
            if (!ShaderLib.isOnScreen(shipLocation, 1.25f * ship.getCollisionRadius())) continue;
            TextureEntry entry = ShaderLib.getShipTexture(ship, TextureData.TextureDataType.SURFACE_MAP);
            SpriteAPI originalSprite = ship.getSpriteAPI();
            Color originalColor2 = null;
            if (entry != null) {
                sprite = entry.sprite;
                sprite.setAngle(originalSprite.getAngle());
                sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                sprite.setAlphaMult(ship.getCombinedAlphaMult());
                if (ship.isHulk()) {
                    sprite.setColor(deadSurface);
                }
            } else {
                sprite = originalSprite;
                originalColor2 = sprite.getColor();
                sprite.setColor(Color.BLACK);
            }
            if ((bounds = ship.getVisualBounds()) != null) {
                bounds.update(ship.getLocation(), ship.getFacing());
                GL11.glEnable((int)2960);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3553);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glStencilFunc((int)519, (int)16, (int)255);
                GL11.glStencilOp((int)7680, (int)7680, (int)7681);
                GL11.glStencilMask((int)255);
                GL11.glClearStencil((int)0);
                GL11.glClear((int)1024);
                Tessellate.render(bounds, 1.0f, 1.0f, 1.0f, ship.getId());
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glStencilFunc((int)514, (int)16, (int)255);
                GL11.glStencilOp((int)7680, (int)7680, (int)7680);
                GL11.glStencilMask((int)0);
                sprite.setBlendFunc(770, 771);
                sprite.renderAtCenter(shipLocation.x, shipLocation.y);
                GL11.glStencilFunc((int)519, (int)0, (int)255);
                GL11.glDisable((int)2960);
            } else {
                sprite.renderAtCenter(shipLocation.x, shipLocation.y);
            }
            if (entry == null) {
                sprite.setColor(originalColor2);
            }
            Vector2f renderOffset = VectorUtils.rotate((Vector2f)ship.getRenderOffset(), (float)ship.getFacing(), (Vector2f)new Vector2f());
            List weapons = ship.getAllWeapons();
            List emptySlots = ship.getHullSpec().getAllWeaponSlotsCopy();
            int weaponSize = weapons.size();
            block6: for (j = 0; j < weaponSize; ++j) {
                WeaponAPI weapon = (WeaponAPI)weapons.get(j);
                if (emptySlots.remove(weapon.getSlot())) continue;
                Iterator iter = emptySlots.iterator();
                while (iter.hasNext()) {
                    Vector2f weaponLocation;
                    WeaponSlotAPI slot = (WeaponSlotAPI)iter.next();
                    Vector2f slotLocation = Vector2f.add((Vector2f)slot.computePosition((CombatEntityAPI)ship), (Vector2f)renderOffset, (Vector2f)new Vector2f());
                    if (!(MathUtils.getDistance((Vector2f)slotLocation, (Vector2f)(weaponLocation = Vector2f.add((Vector2f)weapon.getLocation(), (Vector2f)renderOffset, (Vector2f)new Vector2f()))) <= 1.0f)) continue;
                    iter.remove();
                    continue block6;
                }
            }
            if (bounds == null) {
                int slotSize = emptySlots.size();
                for (int j2 = 0; j2 < slotSize; ++j2) {
                    WeaponSlotAPI slot = (WeaponSlotAPI)emptySlots.get(j2);
                    if (slot.isDecorative() || slot.isHidden() || slot.isSystemSlot() || slot.getWeaponType() == WeaponAPI.WeaponType.LAUNCH_BAY || slot.isStationModule() || slot.isBuiltIn()) continue;
                    Vector2f slotLocation = Vector2f.add((Vector2f)slot.computePosition((CombatEntityAPI)ship), (Vector2f)renderOffset, (Vector2f)new Vector2f());
                    switch (slot.getSlotSize()) {
                        default: {
                            if (slot.isHardpoint()) {
                                entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT_COVER_SMALL, 0);
                                originalSprite = ship.getSmallHardpointCover();
                                break;
                            }
                            entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET_COVER_SMALL, 0);
                            originalSprite = ship.getSmallTurretCover();
                            break;
                        }
                        case MEDIUM: {
                            if (slot.isHardpoint()) {
                                entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT_COVER_MEDIUM, 0);
                                originalSprite = ship.getMediumHardpointCover();
                                break;
                            }
                            entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET_COVER_MEDIUM, 0);
                            originalSprite = ship.getMediumTurretCover();
                            break;
                        }
                        case LARGE: {
                            if (slot.isHardpoint()) {
                                entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT_COVER_LARGE, 0);
                                originalSprite = ship.getLargeHardpointCover();
                                break;
                            }
                            entry = TextureData.getTextureData(ship.getHullStyleId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET_COVER_LARGE, 0);
                            originalSprite = ship.getLargeTurretCover();
                        }
                    }
                    if (originalSprite == null || originalSprite.getTextureId() == 0) continue;
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setAngle(slot.getAngle() + ship.getFacing() - 90.0f);
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        if (ship.isHulk()) {
                            sprite.setColor(deadSurface);
                        }
                        sprite.renderAtCenter(slotLocation.x, slotLocation.y);
                        continue;
                    }
                    sprite = originalSprite;
                    sprite.setAngle(slot.getAngle() + ship.getFacing() - 90.0f);
                    originalColor2 = sprite.getColor();
                    sprite.setColor(Color.BLACK);
                    sprite.renderAtCenter(slotLocation.x, slotLocation.y);
                    sprite.setColor(originalColor2);
                }
            }
            for (j = 0; j < weaponSize; ++j) {
                WeaponAPI weapon = (WeaponAPI)weapons.get(j);
                if (weapon.getSlot().isHidden()) continue;
                Vector2f weaponLocation = Vector2f.add((Vector2f)weapon.getLocation(), (Vector2f)renderOffset, (Vector2f)new Vector2f());
                if (weapon.getUnderSpriteAPI() != null) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT_UNDER, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT_UNDER, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET_UNDER, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET_UNDER, 0));
                    originalSprite = weapon.getUnderSpriteAPI();
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setAngle(originalSprite.getAngle());
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        if (ship.isHulk()) {
                            sprite.setColor(deadSurface);
                        }
                        sprite.renderAtCenter(weaponLocation.x, weaponLocation.y);
                    } else {
                        sprite = originalSprite;
                        originalColor2 = sprite.getColor();
                        sprite.setColor(Color.BLACK);
                        sprite.renderAtCenter(weaponLocation.x, weaponLocation.y);
                        sprite.setColor(originalColor2);
                    }
                }
                if (weapon.getBarrelSpriteAPI() != null && weapon.isRenderBarrelBelow()) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT_BARREL, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET_BARREL, 0));
                    originalSprite = weapon.getBarrelSpriteAPI();
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        if (ship.isHulk()) {
                            sprite.setColor(deadSurface);
                        }
                        weapon.renderBarrel(sprite, weaponLocation, Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                    } else {
                        sprite = originalSprite;
                        originalColor2 = sprite.getColor();
                        sprite.setColor(Color.BLACK);
                        weapon.renderBarrel(sprite, weaponLocation, Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        sprite.setColor(originalColor2);
                    }
                }
                if (weapon.getSprite() != null) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET, 0));
                    originalSprite = weapon.getSprite();
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setAngle(originalSprite.getAngle());
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        if (ship.isHulk()) {
                            sprite.setColor(deadSurface);
                        }
                        sprite.renderAtCenter(weaponLocation.x, weaponLocation.y);
                    } else {
                        sprite = originalSprite;
                        originalColor2 = sprite.getColor();
                        sprite.setColor(Color.BLACK);
                        sprite.renderAtCenter(weaponLocation.x, weaponLocation.y);
                        sprite.setColor(originalColor2);
                    }
                }
                if (weapon.getBarrelSpriteAPI() != null && !weapon.isRenderBarrelBelow()) {
                    entry = weapon.getSlot().isHardpoint() ? (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.HARDPOINT_BARREL, 0)) : (weapon.getAnimation() != null ? TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET_BARREL, weapon.getAnimation().getFrame()) : TextureData.getTextureData(weapon.getId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.TURRET_BARREL, 0));
                    originalSprite = weapon.getBarrelSpriteAPI();
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        if (ship.isHulk()) {
                            sprite.setColor(deadSurface);
                        }
                        weapon.renderBarrel(sprite, weaponLocation, Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                    } else {
                        sprite = originalSprite;
                        originalColor2 = sprite.getColor();
                        sprite.setColor(Color.BLACK);
                        weapon.renderBarrel(sprite, weaponLocation, Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()));
                        sprite.setColor(originalColor2);
                    }
                }
                if (weapon.getMissileRenderData() == null || weapon.getMissileRenderData().isEmpty() || weapon.usesAmmo() && weapon.getAmmo() <= 0) continue;
                List msls = weapon.getMissileRenderData();
                int mslSize = msls.size();
                for (int k = 0; k < mslSize; ++k) {
                    MissileRenderDataAPI msl = (MissileRenderDataAPI)msls.get(k);
                    if (msl.getMissileSpecId() == null) continue;
                    Vector2f missileLocation = msl.getMissileCenterLocation();
                    entry = TextureData.getTextureData(msl.getMissileSpecId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.MISSILE, 0);
                    originalSprite = msl.getSprite();
                    if (entry != null) {
                        sprite = entry.sprite;
                        sprite.setAngle(msl.getMissileFacing() - 90.0f);
                        sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                        sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                        sprite.setAlphaMult(Math.min(ship.getCombinedAlphaMult(), originalSprite.getAlphaMult()) * msl.getBrightness());
                        if (ship.isHulk()) {
                            sprite.setColor(deadSurface);
                        }
                        sprite.renderAtCenter(missileLocation.x + renderOffset.x, missileLocation.y + renderOffset.y);
                        continue;
                    }
                    sprite = originalSprite;
                    originalColor2 = sprite.getColor();
                    sprite.setColor(Color.BLACK);
                    sprite.renderAtCenter(missileLocation.x + renderOffset.x, missileLocation.y + renderOffset.y);
                    sprite.setColor(originalColor2);
                }
            }
        }
        List missiles = Global.getCombatEngine().getMissiles();
        size = missiles.size();
        for (int i = 0; i < size; ++i) {
            SpriteAPI sprite;
            MissileAPI missile = (MissileAPI)missiles.get(i);
            Vector2f missileLocation = missile.getLocation();
            if (!ShaderLib.isOnScreen(missileLocation, 1.25f * missile.getCollisionRadius()) || missile.getProjectileSpecId() == null) continue;
            TextureEntry entry = TextureData.getTextureData(missile.getProjectileSpecId(), TextureData.TextureDataType.SURFACE_MAP, TextureData.ObjectType.MISSILE, 0);
            SpriteAPI originalSprite = missile.getSpriteAPI();
            if (entry != null) {
                sprite = entry.sprite;
                sprite.setAngle(originalSprite.getAngle());
                sprite.setSize(originalSprite.getWidth(), originalSprite.getHeight());
                sprite.setCenter(originalSprite.getCenterX(), originalSprite.getCenterY());
                sprite.setAlphaMult(originalSprite.getAlphaMult());
                sprite.renderAtCenter(missileLocation.x, missileLocation.y);
                continue;
            }
            sprite = originalSprite;
            originalColor = sprite.getColor();
            sprite.setColor(Color.BLACK);
            sprite.renderAtCenter(missileLocation.x, missileLocation.y);
            sprite.setColor(originalColor);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5890);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        if (ShaderLib.useBufferCore()) {
            GL30.glBindFramebuffer((int)36160, (int)0);
        } else if (ShaderLib.useBufferARB()) {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        } else {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        }
        GL11.glPopAttrib();
    }

    private void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        this.enabled = settings.getBoolean("enableLights");
        this.maxLights = settings.getInt("maximumLights");
        this.maxLineLights = settings.getInt("maximumLineLights");
        this.lightMultiplier = (float)settings.getDouble("intensityScale");
        this.lightSizeMultiplier = (float)settings.getDouble("sizeScale");
        this.fighterLightMultiplier = (float)settings.getDouble("fighterBrightnessScale");
        this.bloomEnabled = settings.getBoolean("enableBloom");
        this.bloomQuality = Math.max(Math.min(settings.getInt("bloomQuality"), 5), 1);
        this.bloomMips = Math.max(Math.min(settings.getInt("bloomMips"), 5), 1);
        this.bloomScale = (float)settings.getDouble("bloomScale");
        this.bloomIntensity = (float)settings.getDouble("bloomIntensity");
        this.normalEnabled = settings.getBoolean("enableNormal");
        this.specularMultiplier = (float)settings.getDouble("specularIntensity");
        this.specularHardness = (float)settings.getDouble("specularHardness");
        this.flatness = (float)settings.getDouble("normalFlatness");
        this.lightDepth = (float)settings.getDouble("lightDepth");
        this.flashHeight = (float)settings.getDouble("weaponFlashHeight");
        this.standardHeight = (float)settings.getDouble("weaponLightHeight");
    }

    @Override
    public CombatEngineLayers getCombatLayer() {
        return CombatEngineLayers.ABOVE_SHIPS_AND_MISSILES_LAYER;
    }

    @Override
    public boolean isCombat() {
        return true;
    }

    private static final class LocalData {
        final Set<BeamAPI> beams = new LinkedHashSet<BeamAPI>(200);
        final List<LightAPI> lights = new LinkedList<LightAPI>();
        final Map<DamagingProjectileAPI, Boolean> projectiles = new LinkedHashMap<DamagingProjectileAPI, Boolean>(2000);

        private LocalData() {
        }
    }
}

