/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.light;

import com.fs.starfarer.api.Global;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.light.LightEntry;
import org.dark.shaders.util.ShaderLib;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LightData {
    static final Map<String, LightEntry> beamLightData = new HashMap<String, LightEntry>(100);
    static final Map<String, LightEntry> projectileLightData = new HashMap<String, LightEntry>(500);

    public static LightEntry getLightData(String key, LightDataType type) {
        if (null == type) {
            return null;
        }
        switch (type) {
            case PROJECTILE: {
                return projectileLightData.get(key);
            }
            case BEAM: {
                return beamLightData.get(key);
            }
        }
        return null;
    }

    public static void readLightDataCSV(String localPath) {
        try {
            JSONArray lightData = Global.getSettings().loadCSV(localPath);
            for (int i = 0; i < lightData.length(); ++i) {
                JSONObject entry = lightData.getJSONObject(i);
                if (entry.optString("id").isEmpty() || entry.optString("type").isEmpty()) continue;
                LightEntry lightEntry = new LightEntry();
                boolean success = true;
                switch (entry.getString("type")) {
                    case "projectile": {
                        projectileLightData.put(entry.getString("id"), lightEntry);
                        break;
                    }
                    case "beam": {
                        beamLightData.put(entry.getString("id"), lightEntry);
                        break;
                    }
                    default: {
                        success = false;
                    }
                }
                if (!success) continue;
                if (entry.optDouble("size", 0.0) > 0.0 && entry.optDouble("intensity", 0.0) > 0.0 && !entry.optString("color").isEmpty()) {
                    lightEntry.hasStandard = true;
                    lightEntry.standardSize = (float)entry.getDouble("size");
                    lightEntry.standardIntensity = (float)entry.getDouble("intensity");
                    lightEntry.standardColor = LightData.toColor3(entry.getString("color"));
                    lightEntry.standardFadeout = (float)entry.optDouble("fadeout", 0.0);
                    lightEntry.standardOffset = (float)entry.optDouble("offset", 0.0);
                }
                if (entry.optDouble("hit size", 0.0) > 0.0 && entry.optDouble("hit intensity", 0.0) > 0.0 && !entry.optString("hit color").isEmpty()) {
                    lightEntry.hasHit = true;
                    lightEntry.hitSize = (float)entry.getDouble("hit size");
                    lightEntry.hitIntensity = (float)entry.getDouble("hit intensity");
                    lightEntry.hitColor = LightData.toColor3(entry.getString("hit color"));
                    lightEntry.hitFadeout = (float)entry.optDouble("hit fadeout", 0.0);
                }
                if (entry.optDouble("flash size", 0.0) > 0.0 && entry.optDouble("flash intensity", 0.0) > 0.0 && !entry.optString("flash color").isEmpty()) {
                    lightEntry.hasFlash = true;
                    lightEntry.flashSize = (float)entry.getDouble("flash size");
                    lightEntry.flashIntensity = (float)entry.getDouble("flash intensity");
                    lightEntry.flashColor = LightData.toColor3(entry.getString("flash color"));
                    lightEntry.flashFadeout = (float)entry.optDouble("flash fadeout", 0.0);
                    lightEntry.flashOffset = (float)entry.optDouble("flash offset", 0.0);
                }
                lightEntry.chance = (float)entry.optDouble("chance", 1.0);
                lightEntry.fighterDim = entry.optBoolean("fighter dim", true);
            }
        }
        catch (IOException | JSONException e) {
            Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)("Light data loading failed for " + localPath + "! " + e.getMessage()));
        }
    }

    public static void readLightDataCSVNoOverwrite(String localPath) {
        try {
            JSONArray lightData = Global.getSettings().loadCSV(localPath);
            for (int i = 0; i < lightData.length(); ++i) {
                JSONObject entry = lightData.getJSONObject(i);
                if (entry.optString("id").isEmpty() || entry.optString("type").isEmpty()) continue;
                LightEntry lightEntry = new LightEntry();
                boolean success = true;
                switch (entry.getString("type")) {
                    case "projectile": {
                        if (projectileLightData.containsKey(entry.getString("id"))) {
                            success = false;
                            break;
                        }
                        projectileLightData.put(entry.getString("id"), lightEntry);
                        break;
                    }
                    case "beam": {
                        if (beamLightData.containsKey(entry.getString("id"))) {
                            success = false;
                            break;
                        }
                        beamLightData.put(entry.getString("id"), lightEntry);
                        break;
                    }
                    default: {
                        success = false;
                    }
                }
                if (!success) continue;
                if (entry.optDouble("size", 0.0) > 0.0 && entry.optDouble("intensity", 0.0) > 0.0 && !entry.optString("color").isEmpty()) {
                    lightEntry.hasStandard = true;
                    lightEntry.standardSize = (float)entry.getDouble("size");
                    lightEntry.standardIntensity = (float)entry.getDouble("intensity");
                    lightEntry.standardColor = LightData.toColor3(entry.getString("color"));
                    lightEntry.standardFadeout = (float)entry.optDouble("fadeout", 0.0);
                    lightEntry.standardOffset = (float)entry.optDouble("offset", 0.0);
                }
                if (entry.optDouble("hit size", 0.0) > 0.0 && entry.optDouble("hit intensity", 0.0) > 0.0 && !entry.optString("hit color").isEmpty()) {
                    lightEntry.hasHit = true;
                    lightEntry.hitSize = (float)entry.getDouble("hit size");
                    lightEntry.hitIntensity = (float)entry.getDouble("hit intensity");
                    lightEntry.hitColor = LightData.toColor3(entry.getString("hit color"));
                    lightEntry.hitFadeout = (float)entry.optDouble("hit fadeout", 0.0);
                }
                if (entry.optDouble("flash size", 0.0) > 0.0 && entry.optDouble("flash intensity", 0.0) > 0.0 && !entry.optString("flash color").isEmpty()) {
                    lightEntry.hasFlash = true;
                    lightEntry.flashSize = (float)entry.getDouble("flash size");
                    lightEntry.flashIntensity = (float)entry.getDouble("flash intensity");
                    lightEntry.flashColor = LightData.toColor3(entry.getString("flash color"));
                    lightEntry.flashFadeout = (float)entry.optDouble("flash fadeout", 0.0);
                    lightEntry.flashOffset = (float)entry.optDouble("flash offset", 0.0);
                }
                lightEntry.chance = (float)entry.optDouble("chance", 1.0);
                lightEntry.fighterDim = entry.optBoolean("fighter dim", true);
            }
        }
        catch (IOException | JSONException e) {
            Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)("Light data loading failed for " + localPath + "! " + e.getMessage()));
        }
    }

    private static int clamp255(int x) {
        return Math.max(0, Math.min(255, x));
    }

    private static Color toColor3(String in) {
        String inPredicate = in.substring(1, in.length() - 1);
        String[] array = inPredicate.split(",");
        return new Color(LightData.clamp255(Integer.parseInt(array[0])), LightData.clamp255(Integer.parseInt(array[1])), LightData.clamp255(Integer.parseInt(array[2])), 255);
    }

    public static enum LightDataType {
        PROJECTILE,
        BEAM;

    }
}

