/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.lens;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.util.ShaderAPI;
import org.dark.shaders.util.ShaderLib;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class LensShader
implements ShaderAPI {
    public static final Comparator<CombatEntityAPI> ENTITYSIZE = new Comparator<CombatEntityAPI>(){

        @Override
        public int compare(CombatEntityAPI entity1, CombatEntityAPI entity2) {
            if (entity1.getCollisionRadius() > entity2.getCollisionRadius()) {
                return -1;
            }
            if (entity1.getCollisionRadius() < entity2.getCollisionRadius()) {
                return 1;
            }
            return 0;
        }
    };
    private static final String DATA_KEY = "shaderlib_LensShader";
    private static final int MAX_LENSES = 21;
    private boolean active = false;
    private final FloatBuffer dataBuffer = BufferUtils.createFloatBuffer((int)64);
    private final FloatBuffer dataBufferPre = BufferUtils.createFloatBuffer((int)64);
    private boolean enabled = false;
    private final int[] index = new int[7];
    private int program = 0;
    private int rippleTex = 0;
    private boolean validated = false;

    public LensShader() {
        String fragShader;
        String vertShader;
        if (!ShaderLib.areShadersAllowed()) {
            return;
        }
        try {
            vertShader = Global.getSettings().loadText("data/shaders/lens.vert");
            fragShader = Global.getSettings().loadText("data/shaders/lens.frag");
        }
        catch (IOException ex) {
            return;
        }
        this.program = ShaderLib.loadShader(vertShader, fragShader);
        if (this.program == 0) {
            return;
        }
        this.rippleTex = GL11.glGenTextures();
        GL11.glBindTexture((int)3552, (int)this.rippleTex);
        if (ShaderLib.useBufferCore()) {
            GL11.glTexImage1D((int)3552, (int)0, (int)33326, (int)64, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        } else {
            GL11.glTexImage1D((int)3552, (int)0, (int)33326, (int)64, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        }
        GL20.glUseProgram((int)this.program);
        this.index[0] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"tex");
        this.index[1] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"data");
        this.index[2] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"trans");
        this.index[3] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"intensity");
        this.index[4] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"size");
        this.index[5] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"sizeNormalization");
        this.index[6] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"normalization");
        GL20.glUniform1i((int)this.index[0], (int)0);
        GL20.glUniform1i((int)this.index[1], (int)1);
        GL20.glUniform1f((int)this.index[2], (float)ShaderLib.getSquareTransform());
        GL20.glUniform1f((int)this.index[3], (float)1.0f);
        GL20.glUseProgram((int)0);
        this.enabled = true;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (!this.enabled) {
            return;
        }
    }

    @Override
    public void destroy() {
        if (this.program != 0) {
            ByteBuffer countbb = ByteBuffer.allocateDirect(4);
            ByteBuffer shadersbb = ByteBuffer.allocateDirect(8);
            IntBuffer count = countbb.asIntBuffer();
            IntBuffer shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.program, (IntBuffer)count, (IntBuffer)shaders);
            for (int i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.program);
        }
        if (this.rippleTex != 0) {
            GL11.glDeleteTextures((int)this.rippleTex);
        }
    }

    @Override
    public ShaderAPI.RenderOrder getRenderOrder() {
        return ShaderAPI.RenderOrder.DISTORTED_SPACE;
    }

    @Override
    public void initCombat() {
        Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void renderInScreenCoords(ViewportAPI viewport) {
    }

    @Override
    public void renderInWorldCoords(ViewportAPI viewport) {
        if (!this.enabled || !this.active) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        List<ShipAPI> ships = ((LocalData)engine.getCustomData().get((Object)DATA_KEY)).ships;
        List allShips = engine.getShips();
        for (ShipAPI ship : allShips) {
            if (ship.isHulk() || ships.contains(ship)) continue;
            ships.add(ship);
        }
        Iterator<ShipAPI> iter = ships.iterator();
        while (iter.hasNext()) {
            ShipAPI ship;
            ship = iter.next();
            if (!ship.isHulk() && engine.isEntityInPlay((CombatEntityAPI)ship)) continue;
            iter.remove();
        }
        if (!ships.isEmpty()) {
            Collections.sort(ships, ENTITYSIZE);
            this.drawRipples(viewport);
        }
    }

    private void drawRipples(ViewportAPI viewport) {
        int i;
        ShaderLib.beginDraw(this.program);
        CombatEngineAPI engine = Global.getCombatEngine();
        List<ShipAPI> ships = ((LocalData)engine.getCustomData().get((Object)DATA_KEY)).ships;
        Vector2f maxCoords = null;
        Vector2f minCoords = null;
        float maxSize = 0.0f;
        int lenses = 0;
        for (ShipAPI ship : ships) {
            Vector2f shipLocation = new Vector2f((ReadableVector2f)ship.getLocation());
            if (!ShaderLib.isOnScreen(shipLocation, ship.getCollisionRadius())) continue;
            Vector2f coords = ShaderLib.transformScreenToUV(ShaderLib.transformWorldToScreen(shipLocation));
            float size = ShaderLib.unitsToUV(ship.getCollisionRadius());
            if (maxCoords == null || minCoords == null) {
                maxCoords = new Vector2f((ReadableVector2f)coords);
                minCoords = new Vector2f((ReadableVector2f)coords);
            } else {
                if (coords.x > maxCoords.x) {
                    maxCoords.x = coords.x;
                } else if (coords.x < minCoords.x) {
                    minCoords.x = coords.x;
                }
                if (coords.y > maxCoords.y) {
                    maxCoords.y = coords.y;
                } else if (coords.y < minCoords.y) {
                    minCoords.y = coords.y;
                }
            }
            if (size > maxSize) {
                maxSize = size;
            }
            this.dataBufferPre.put(coords.x);
            this.dataBufferPre.put(coords.y);
            this.dataBufferPre.put(size);
            if (++lenses < 21) continue;
            break;
        }
        if (lenses <= 0 || minCoords == null || maxCoords == null) {
            ShaderLib.exitDraw();
            return;
        }
        Vector2f normX = ShaderLib.getTextureDataNormalization(minCoords.x, maxCoords.x);
        Vector2f normY = ShaderLib.getTextureDataNormalization(minCoords.y, maxCoords.y);
        Vector2f normS = ShaderLib.getTextureDataNormalization(0.0f, maxSize);
        this.dataBufferPre.flip();
        block5: for (i = 0; i < lenses * 3; ++i) {
            int pos = i % 3;
            switch (pos) {
                case 0: {
                    this.dataBuffer.put((this.dataBufferPre.get() - normX.y) / normX.x);
                    continue block5;
                }
                case 1: {
                    this.dataBuffer.put((this.dataBufferPre.get() - normY.y) / normY.x);
                    continue block5;
                }
                default: {
                    this.dataBuffer.put(this.dataBufferPre.get() / normS.x);
                }
            }
        }
        for (i = lenses * 3; i < 64; ++i) {
            this.dataBuffer.put(0.0f);
        }
        this.dataBuffer.flip();
        GL11.glBindTexture((int)3552, (int)this.rippleTex);
        if (ShaderLib.useBufferCore()) {
            GL11.glTexImage1D((int)3552, (int)0, (int)33326, (int)64, (int)0, (int)6403, (int)5126, (FloatBuffer)this.dataBuffer);
        } else {
            GL11.glTexImage1D((int)3552, (int)0, (int)33326, (int)64, (int)0, (int)6403, (int)5126, (FloatBuffer)this.dataBuffer);
        }
        GL11.glTexParameteri((int)3552, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3552, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3552, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3552, (int)10243, (int)10496);
        GL20.glUniform1i((int)this.index[4], (int)lenses);
        GL20.glUniform1f((int)this.index[5], (float)normS.x);
        GL20.glUniform4f((int)this.index[6], (float)normX.x, (float)normX.y, (float)normY.x, (float)normY.y);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)ShaderLib.getScreenTexture());
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3552, (int)this.rippleTex);
        if (!this.validated) {
            this.validated = true;
            GL20.glValidateProgram((int)this.program);
            if (GL20.glGetProgrami((int)this.program, (int)35715) == 0) {
                Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.program));
                ShaderLib.exitDraw();
                this.dataBuffer.clear();
                this.dataBufferPre.clear();
                this.enabled = false;
                return;
            }
        }
        GL11.glDisable((int)3042);
        ShaderLib.screenDraw(ShaderLib.getScreenTexture(), 33984);
        ShaderLib.exitDraw();
        this.dataBuffer.clear();
        this.dataBufferPre.clear();
    }

    @Override
    public CombatEngineLayers getCombatLayer() {
        return CombatEngineLayers.JUST_BELOW_WIDGETS;
    }

    @Override
    public boolean isCombat() {
        return true;
    }

    private static final class LocalData {
        final List<ShipAPI> ships = new ArrayList<ShipAPI>(100);

        private LocalData() {
        }
    }
}

