/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.invert;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.util.ShaderAPI;
import org.dark.shaders.util.ShaderLib;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class InvertShader
implements ShaderAPI {
    private boolean active = false;
    private boolean enabled = false;
    private final int[] index = new int[1];
    private int program = 0;
    private boolean validated = false;

    public InvertShader() {
        String fragShader;
        String vertShader;
        if (!ShaderLib.areShadersAllowed()) {
            return;
        }
        try {
            vertShader = Global.getSettings().loadText("data/shaders/invert.vert");
            fragShader = Global.getSettings().loadText("data/shaders/invert.frag");
        }
        catch (IOException ex) {
            return;
        }
        this.program = ShaderLib.loadShader(vertShader, fragShader);
        if (this.program == 0) {
            return;
        }
        GL20.glUseProgram((int)this.program);
        this.index[0] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"tex");
        GL20.glUniform1i((int)this.index[0], (int)0);
        GL20.glUseProgram((int)0);
        this.enabled = true;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (!this.enabled) {
            return;
        }
    }

    @Override
    public void destroy() {
        if (this.program != 0) {
            ByteBuffer countbb = ByteBuffer.allocateDirect(4);
            ByteBuffer shadersbb = ByteBuffer.allocateDirect(8);
            IntBuffer count = countbb.asIntBuffer();
            IntBuffer shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.program, (IntBuffer)count, (IntBuffer)shaders);
            for (int i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.program);
        }
    }

    @Override
    public ShaderAPI.RenderOrder getRenderOrder() {
        return ShaderAPI.RenderOrder.SCREEN_SPACE;
    }

    @Override
    public void initCombat() {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void renderInScreenCoords(ViewportAPI viewport) {
    }

    @Override
    public void renderInWorldCoords(ViewportAPI viewport) {
        if (!this.enabled || !this.active) {
            return;
        }
        this.invertScreen(viewport);
    }

    private void invertScreen(ViewportAPI viewport) {
        ShaderLib.beginDraw(this.program);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)ShaderLib.getScreenTexture());
        if (!this.validated) {
            this.validated = true;
            GL20.glValidateProgram((int)this.program);
            if (GL20.glGetProgrami((int)this.program, (int)35715) == 0) {
                Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.program));
                ShaderLib.exitDraw();
                this.enabled = false;
                return;
            }
        }
        GL11.glDisable((int)3042);
        ShaderLib.screenDraw(ShaderLib.getScreenTexture(), 33984);
        ShaderLib.exitDraw();
    }

    @Override
    public CombatEngineLayers getCombatLayer() {
        return CombatEngineLayers.JUST_BELOW_WIDGETS;
    }

    @Override
    public boolean isCombat() {
        return false;
    }
}

