/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.distortion;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.graphics.SpriteAPI;
import org.dark.shaders.distortion.DistortionAPI;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class WaveDistortion
implements DistortionAPI {
    private static SpriteAPI sprite;
    static boolean pathsSet;
    private float arcAttenWidth = 0.0f;
    private float arcEnd = 0.0f;
    private float arcStart = 0.0f;
    private float autoFadeIntensityTime = 0.0f;
    private float autoFadeSizeTime = 0.0f;
    private float deltaIntensity = 0.0f;
    private float deltaSize = 0.0f;
    private boolean flipped = false;
    private float intensity = 20.0f;
    private float lifetime = -1.0f;
    private final Vector2f location;
    private float maxIntensity = 20.0f;
    private float maxSize = 100.0f;
    private float size = 100.0f;
    private final Vector2f velocity;

    private static void setPaths() {
        String path = "graphics/shaders/distortions/wave.png";
        sprite = Global.getSettings().getSprite(path);
    }

    public WaveDistortion() {
        if (!pathsSet) {
            WaveDistortion.setPaths();
            pathsSet = true;
        }
        this.location = new Vector2f();
        this.velocity = new Vector2f();
    }

    public WaveDistortion(Vector2f location, Vector2f velocity) {
        if (!pathsSet) {
            WaveDistortion.setPaths();
            pathsSet = true;
        }
        this.location = new Vector2f((ReadableVector2f)location);
        this.velocity = new Vector2f((ReadableVector2f)velocity);
    }

    @Override
    public boolean advance(float amount) {
        this.size += this.deltaSize * amount;
        this.intensity += this.deltaIntensity * amount;
        if (this.size >= this.maxSize && this.deltaSize > 0.0f) {
            this.size = this.maxSize;
            this.deltaSize = 0.0f;
        }
        if (this.intensity >= this.maxIntensity && this.deltaIntensity > 0.0f) {
            this.intensity = this.maxIntensity;
            this.deltaIntensity = 0.0f;
        }
        if (this.size <= 0.0f || this.intensity <= 0.0f) {
            return true;
        }
        this.location.translate(this.velocity.x * amount, this.velocity.y * amount);
        if (Float.compare(this.deltaSize, 0.0f) == 0 && Float.compare(this.deltaIntensity, 0.0f) == 0 && this.lifetime >= 0.0f) {
            this.lifetime -= amount;
            if (this.lifetime <= 0.0f) {
                if (Float.compare(this.autoFadeSizeTime, 0.0f) == 0 || Float.compare(this.autoFadeIntensityTime, 0.0f) == 0) {
                    return true;
                }
                if (Float.compare(this.autoFadeSizeTime, 0.0f) != 0) {
                    this.fadeOutSize(this.autoFadeSizeTime);
                }
                if (Float.compare(this.autoFadeIntensityTime, 0.0f) != 0) {
                    this.fadeOutIntensity(this.autoFadeIntensityTime);
                }
            }
        }
        return false;
    }

    public void fadeInIntensity(float time) {
        this.deltaIntensity = this.intensity / time;
        this.maxIntensity = this.intensity;
        this.intensity = 0.0f;
    }

    public void fadeInSize(float time) {
        this.deltaSize = this.size / time;
        this.maxSize = this.size;
        this.size = 0.0f;
    }

    public void fadeOutIntensity(float time) {
        this.deltaIntensity = -this.intensity / time;
        this.maxIntensity = Float.MAX_VALUE;
    }

    public void fadeOutSize(float time) {
        this.deltaSize = -this.size / time;
        this.maxSize = Float.MAX_VALUE;
    }

    public void flip(boolean flipped) {
        this.flipped = flipped;
    }

    @Override
    public float getArcAttenuationWidth() {
        return this.arcAttenWidth;
    }

    public void setArcAttenuationWidth(float width) {
        this.arcAttenWidth = width;
    }

    @Override
    public float getArcEnd() {
        return this.arcEnd;
    }

    @Override
    public float getArcStart() {
        return this.arcStart;
    }

    public float getAutoFadeIntensityTime() {
        return this.autoFadeIntensityTime;
    }

    public void setAutoFadeIntensityTime(float time) {
        this.autoFadeIntensityTime = time;
    }

    public float getAutoFadeSizeTime() {
        return this.autoFadeSizeTime;
    }

    public void setAutoFadeSizeTime(float time) {
        this.autoFadeSizeTime = time;
    }

    @Override
    public float getFacing() {
        return sprite.getAngle();
    }

    @Override
    public float getIntensity() {
        return this.intensity;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    public void setLifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public Vector2f getLocation() {
        return this.location;
    }

    public void setLocation(Vector2f location) {
        this.location.set((ReadableVector2f)location);
    }

    public float getRemainingLifetime() {
        return this.lifetime;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    @Override
    public SpriteAPI getSprite() {
        sprite.setSize(2.0f * this.size, 2.0f * this.size);
        return sprite;
    }

    public Vector2f getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector2f velocity) {
        this.velocity.set((ReadableVector2f)velocity);
    }

    public boolean isFading() {
        return Float.compare(this.deltaSize, 0.0f) != 0 || Float.compare(this.deltaIntensity, 0.0f) != 0;
    }

    @Override
    public boolean isFlipped() {
        return this.flipped;
    }

    public void setArc(float start, float end) {
        this.arcStart = start;
        this.arcEnd = end;
        if (this.arcStart < -360.0f || this.arcStart > 360.0f) {
            this.arcStart %= 360.0f;
        }
        if (this.arcStart < 0.0f) {
            this.arcStart += 360.0f;
        }
        if (this.arcEnd < -360.0f || this.arcEnd > 360.0f) {
            this.arcEnd %= 360.0f;
        }
        if (this.arcEnd < 0.0f) {
            this.arcEnd += 360.0f;
        }
    }

    static {
        pathsSet = false;
    }
}

