/*
 * Decompiled with CFR 0.152.
 */
package org.dark.shaders.distortion;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.RippleDistortion;
import org.dark.shaders.distortion.WaveDistortion;
import org.dark.shaders.util.ShaderAPI;
import org.dark.shaders.util.ShaderLib;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.util.vector.Vector2f;

public class DistortionShader
implements ShaderAPI {
    private static final String DATA_KEY = "shaderlib_DistortionShader";
    private static final Comparator<DistortionAPI> DISTORTIONSIZE = new Comparator<DistortionAPI>(){

        @Override
        public int compare(DistortionAPI distortion1, DistortionAPI distortion2) {
            float distortion2factor;
            float distortion1factor = distortion1.getIntensity() * Math.max(distortion1.getSprite().getWidth(), distortion1.getSprite().getHeight());
            if (distortion1factor > (distortion2factor = distortion2.getIntensity() * Math.max(distortion2.getSprite().getWidth(), distortion2.getSprite().getHeight()))) {
                return -1;
            }
            if (distortion1factor < distortion2factor) {
                return 1;
            }
            return 0;
        }
    };
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private boolean enabled = false;
    private final int[] index = new int[4];
    private final int[] indexAux = new int[7];
    private int maxDistortions = 100;
    private int program = 0;
    private int programAux = 0;
    private boolean validated = false;
    private boolean validatedAux = false;

    public static void addDistortion(DistortionAPI distortion) {
        ShaderAPI distortionShader = ShaderLib.getShaderAPI(DistortionShader.class);
        if (distortionShader instanceof DistortionShader && distortionShader.isEnabled() && distortion != null) {
            LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
            if (localData == null) {
                return;
            }
            List<DistortionAPI> distortions = localData.distortions;
            if (distortions != null) {
                distortions.add(distortion);
            }
        }
    }

    public static void removeDistortion(DistortionAPI distortion) {
        ShaderAPI distortionShader = ShaderLib.getShaderAPI(DistortionShader.class);
        if (distortionShader instanceof DistortionShader && distortionShader.isEnabled() && distortion != null) {
            LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
            if (localData == null) {
                return;
            }
            List<DistortionAPI> distortions = localData.distortions;
            if (distortions != null) {
                distortions.remove(distortion);
            }
        }
    }

    public DistortionShader() {
        String fragShaderAux;
        String vertShaderAux;
        String fragShader;
        String vertShader;
        if (!ShaderLib.areShadersAllowed() || !ShaderLib.areBuffersAllowed()) {
            this.enabled = false;
            return;
        }
        RippleDistortion.pathsSet = false;
        WaveDistortion.pathsSet = false;
        Global.getLogger(DistortionShader.class).setLevel(Level.ERROR);
        try {
            this.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(DistortionShader.class).log((Priority)Level.ERROR, (Object)("Failed to load shader settings: " + e.getMessage()));
            this.enabled = false;
            return;
        }
        if (!this.enabled) {
            return;
        }
        try {
            vertShader = Global.getSettings().loadText("data/shaders/distortion/distortion.vert");
            fragShader = Global.getSettings().loadText("data/shaders/distortion/distortion.frag");
            vertShaderAux = Global.getSettings().loadText("data/shaders/distortion/2dtangent.vert");
            fragShaderAux = Global.getSettings().loadText("data/shaders/distortion/2dtangent.frag");
        }
        catch (IOException ex) {
            this.enabled = false;
            return;
        }
        this.program = ShaderLib.loadShader(vertShader, fragShader);
        this.programAux = ShaderLib.loadShader(vertShaderAux, fragShaderAux);
        if (this.program == 0 || this.programAux == 0) {
            this.enabled = false;
            return;
        }
        GL20.glUseProgram((int)this.program);
        this.index[0] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"tex");
        this.index[1] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"distort");
        this.index[2] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"screen");
        this.index[3] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"norm");
        GL20.glUniform1i((int)this.index[0], (int)0);
        GL20.glUniform1i((int)this.index[1], (int)1);
        GL20.glUniform4f((int)this.index[2], (float)ShaderLib.getInternalWidth(), (float)ShaderLib.getInternalHeight(), (float)ShaderLib.getVisibleU(), (float)ShaderLib.getVisibleV());
        GL20.glUseProgram((int)this.programAux);
        this.indexAux[0] = GL20.glGetUniformLocation((int)this.programAux, (CharSequence)"tex");
        this.indexAux[1] = GL20.glGetUniformLocation((int)this.programAux, (CharSequence)"facing");
        this.indexAux[2] = GL20.glGetUniformLocation((int)this.programAux, (CharSequence)"scale");
        this.indexAux[3] = GL20.glGetUniformLocation((int)this.programAux, (CharSequence)"norm");
        this.indexAux[4] = GL20.glGetUniformLocation((int)this.programAux, (CharSequence)"flip");
        this.indexAux[5] = GL20.glGetUniformLocation((int)this.programAux, (CharSequence)"arc");
        this.indexAux[6] = GL20.glGetUniformLocation((int)this.programAux, (CharSequence)"attwidth");
        GL20.glUniform1i((int)this.indexAux[0], (int)0);
        GL20.glUseProgram((int)0);
        this.enabled = true;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (!this.enabled) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        List<DistortionAPI> distortions = ((LocalData)Global.getCombatEngine().getCustomData().get((Object)DATA_KEY)).distortions;
        if (!engine.isPaused()) {
            Iterator<DistortionAPI> iter = distortions.iterator();
            while (iter.hasNext()) {
                DistortionAPI distortion = iter.next();
                if (!distortion.advance(amount)) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void destroy() {
        int i;
        IntBuffer shaders;
        IntBuffer count;
        ByteBuffer shadersbb;
        ByteBuffer countbb;
        if (this.program != 0) {
            countbb = ByteBuffer.allocateDirect(4);
            shadersbb = ByteBuffer.allocateDirect(8);
            count = countbb.asIntBuffer();
            shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.program, (IntBuffer)count, (IntBuffer)shaders);
            for (i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.program);
        }
        if (this.programAux != 0) {
            countbb = ByteBuffer.allocateDirect(4);
            shadersbb = ByteBuffer.allocateDirect(8);
            count = countbb.asIntBuffer();
            shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.programAux, (IntBuffer)count, (IntBuffer)shaders);
            for (i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.programAux);
        }
    }

    @Override
    public ShaderAPI.RenderOrder getRenderOrder() {
        return ShaderAPI.RenderOrder.DISTORTED_SPACE;
    }

    @Override
    public void initCombat() {
        Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void renderInScreenCoords(ViewportAPI viewport) {
    }

    @Override
    public void renderInWorldCoords(ViewportAPI viewport) {
        if (!this.enabled) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        List<DistortionAPI> distortions = ((LocalData)engine.getCustomData().get((Object)DATA_KEY)).distortions;
        if (!distortions.isEmpty()) {
            Collections.sort(distortions, DISTORTIONSIZE);
            this.drawDistortion(viewport);
        }
    }

    private void drawDistortion(ViewportAPI viewport) {
        CombatEngineAPI engine = Global.getCombatEngine();
        List<DistortionAPI> distortions = ((LocalData)engine.getCustomData().get((Object)DATA_KEY)).distortions;
        GL20.glUseProgram((int)this.programAux);
        GL11.glPushAttrib((int)1048575);
        if (ShaderLib.useBufferCore()) {
            GL30.glBindFramebuffer((int)36160, (int)ShaderLib.getAuxiliaryBufferId());
        } else if (ShaderLib.useBufferARB()) {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)ShaderLib.getAuxiliaryBufferId());
        } else {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)ShaderLib.getAuxiliaryBufferId());
        }
        GL11.glViewport((int)0, (int)0, (int)((int)(Global.getSettings().getScreenWidth() * Display.getPixelScaleFactor())), (int)((int)(Global.getSettings().getScreenHeight() * Display.getPixelScaleFactor())));
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)viewport.getLLX(), (double)(viewport.getLLX() + viewport.getVisibleWidth()), (double)viewport.getLLY(), (double)(viewport.getLLY() + viewport.getVisibleHeight()), (double)-2000.0, (double)2000.0);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glClear((int)16384);
        float maxScale = 0.0f;
        float minScale = 0.0f;
        int distortionCount = 0;
        ListIterator<DistortionAPI> iter = distortions.listIterator();
        while (iter.hasNext()) {
            DistortionAPI distortion = iter.next();
            float scale = ShaderLib.unitsToUV(distortion.getIntensity());
            if (scale > maxScale) {
                maxScale = scale;
            }
            if (scale < minScale) {
                minScale = scale;
            }
            if (++distortionCount < this.maxDistortions) continue;
            break;
        }
        Vector2f normS = ShaderLib.getTextureDataNormalization(minScale, maxScale);
        iter = distortions.listIterator(distortionCount);
        distortionCount = 0;
        while (iter.hasPrevious()) {
            DistortionAPI distortion = iter.previous();
            Vector2f location = distortion.getLocation();
            SpriteAPI sprite = distortion.getSprite();
            if (location == null || sprite == null || !ShaderLib.isOnScreen(location, Math.max(sprite.getHeight(), sprite.getWidth()))) continue;
            float scale = ShaderLib.unitsToUV(Math.max(distortion.getIntensity(), 0.0f));
            GL20.glUniform1f((int)this.indexAux[1], (float)distortion.getFacing());
            GL20.glUniform1f((int)this.indexAux[2], (float)scale);
            GL20.glUniform2f((int)this.indexAux[3], (float)normS.x, (float)normS.y);
            GL20.glUniform1f((int)this.indexAux[4], (float)(distortion.isFlipped() ? -1.0f : 1.0f));
            GL20.glUniform2f((int)this.indexAux[5], (float)((float)Math.toRadians(distortion.getArcStart())), (float)((float)Math.toRadians(distortion.getArcEnd())));
            GL20.glUniform1f((int)this.indexAux[6], (float)((float)Math.toRadians(distortion.getArcAttenuationWidth())));
            if (!this.validatedAux) {
                this.validatedAux = true;
                GL20.glValidateProgram((int)this.programAux);
                if (GL20.glGetProgrami((int)this.programAux, (int)35715) == 0) {
                    Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.programAux));
                    ShaderLib.exitDraw();
                    this.enabled = false;
                    return;
                }
            }
            sprite.renderAtCenter(location.x, location.y);
            if (++distortionCount < this.maxDistortions) continue;
            break;
        }
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5890);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        if (ShaderLib.useBufferCore()) {
            GL30.glBindFramebuffer((int)36160, (int)0);
        } else if (ShaderLib.useBufferARB()) {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        } else {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        }
        GL11.glPopAttrib();
        ShaderLib.beginDraw(this.program);
        GL20.glUniform2f((int)this.index[3], (float)normS.x, (float)normS.y);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)ShaderLib.getScreenTexture());
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)ShaderLib.getAuxiliaryBufferTexture());
        if (!this.validated) {
            this.validated = true;
            GL20.glValidateProgram((int)this.program);
            if (GL20.glGetProgrami((int)this.program, (int)35715) == 0) {
                Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo(this.program));
                ShaderLib.exitDraw();
                this.enabled = false;
                return;
            }
        }
        GL11.glDisable((int)3042);
        ShaderLib.screenDraw(ShaderLib.getScreenTexture(), 33984);
        ShaderLib.exitDraw();
    }

    private void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        this.enabled = settings.getBoolean("enableDistortion");
        this.maxDistortions = settings.getInt("maximumDistortions");
    }

    @Override
    public CombatEngineLayers getCombatLayer() {
        return CombatEngineLayers.JUST_BELOW_WIDGETS;
    }

    @Override
    public boolean isCombat() {
        return true;
    }

    private static final class LocalData {
        final List<DistortionAPI> distortions = new LinkedList<DistortionAPI>();

        private LocalData() {
        }
    }
}

