/*
 * Decompiled with CFR 0.152.
 */
package org.dark.graphics.util;

import com.fs.starfarer.api.combat.BoundsAPI;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.glu.GLUtessellatorCallback;
import org.lwjgl.util.glu.GLUtessellatorCallbackAdapter;
import org.lwjgl.util.glu.tessellation.GLUtessellatorImpl;
import org.lwjgl.util.vector.Vector2f;

public class Tessellate {
    public static void clearCache() {
    }

    public static void render(BoundsAPI bounds, float r, float g, float b, String id) {
        int i;
        GLUtessellatorImpl tesselator = (GLUtessellatorImpl)GLU.gluNewTess();
        TessCallbackV2 callback = new TessCallbackV2();
        tesselator.gluTessCallback(100101, (GLUtessellatorCallback)callback);
        tesselator.gluTessCallback(100100, (GLUtessellatorCallback)callback);
        tesselator.gluTessCallback(100102, (GLUtessellatorCallback)callback);
        tesselator.gluTessCallback(100105, (GLUtessellatorCallback)callback);
        tesselator.gluTessProperty(100140, 100130.0);
        tesselator.gluTessBeginPolygon(null);
        tesselator.gluTessBeginContour();
        List segments = bounds.getSegments();
        ArrayList<Vector2f> points = new ArrayList<Vector2f>(segments.size());
        for (BoundsAPI.SegmentAPI segment : segments) {
            points.add(segment.getP1());
        }
        double[][] data = new double[points.size()][6];
        for (i = 0; i < points.size(); ++i) {
            Vector2f v = (Vector2f)points.get(i);
            data[i][0] = v.x;
            data[i][1] = v.y;
            data[i][2] = 0.0;
            data[i][3] = r;
            data[i][4] = g;
            data[i][5] = b;
        }
        for (i = 0; i < points.size(); ++i) {
            tesselator.gluTessVertex(data[i], 0, (Object)new VertexDataV2(data[i]));
        }
        tesselator.gluTessEndContour();
        tesselator.gluTessEndPolygon();
        tesselator.gluDeleteTess();
    }

    public static class VertexDataV2 {
        public double[] data;

        VertexDataV2(double[] data) {
            this.data = data;
        }
    }

    public static class TessCallbackV2
    extends GLUtessellatorCallbackAdapter {
        public void begin(int type) {
            GL11.glBegin((int)type);
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            for (int i = 0; i < outData.length; ++i) {
                double[] combined = new double[]{coords[0], coords[1], coords[2], 1.0, 1.0, 1.0};
                outData[i] = new VertexDataV2(combined);
            }
        }

        public void end() {
            GL11.glEnd();
        }

        public void vertex(Object vertexData) {
            VertexDataV2 vertex = (VertexDataV2)vertexData;
            GL11.glVertex3d((double)vertex.data[0], (double)vertex.data[1], (double)vertex.data[2]);
            GL11.glColor3d((double)vertex.data[3], (double)vertex.data[4], (double)vertex.data[5]);
        }
    }
}

