/*
 * Decompiled with CFR 0.152.
 */
package org.dark.graphics.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.graphics.util.ShipColors;
import org.dark.shaders.util.ShaderLib;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class WeaponDamageSmoke
extends BaseEveryFrameCombatPlugin {
    private static final Map<WeaponAPI.WeaponSize, Float> MAGNITUDE = new HashMap<WeaponAPI.WeaponSize, Float>(3);
    private static final float OFFSCREEN_GRACE_CONSTANT = 500.0f;
    private static final float OFFSCREEN_GRACE_FACTOR = 2.0f;
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private static final Color SMOKE1_MOD = new Color(0, 0, 0, 0);
    private static final Color SMOKE2_MOD = new Color(70, 70, 70, 0);
    private static boolean enabled = true;
    private static boolean offscreen = false;
    private CombatEngineAPI engine;
    private final IntervalUtil interval = new IntervalUtil(0.1f, 0.1f);

    private static void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        enabled = settings.getBoolean("enableWeaponSmoke");
        offscreen = settings.getBoolean("drawOffscreenParticles");
    }

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null || !enabled) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.interval.advance(amount);
        if (this.interval.intervalElapsed()) {
            float smokeSize = 0.8f + 0.4f * (float)Math.random();
            List ships = this.engine.getShips();
            int size = ships.size();
            for (int i = 0; i < size; ++i) {
                ShipAPI ship = (ShipAPI)ships.get(i);
                if (!ship.isAlive() || !offscreen && !ShaderLib.isOnScreen(ship.getLocation(), (ship.getCollisionRadius() + 20.0f) * 2.0f + 500.0f)) continue;
                String style = ship.getHullStyleId();
                Color smokeColor = ShipColors.SMOKE_COLORS.get(style);
                if (smokeColor == null) {
                    smokeColor = ShipColors.SMOKE_COLORS.get("MIDLINE");
                }
                List weapons = ship.getAllWeapons();
                int weaponsSize = weapons.size();
                for (int j = 0; j < weaponsSize; ++j) {
                    WeaponAPI weapon = (WeaponAPI)weapons.get(j);
                    if (!weapon.isDisabled() || weapon.isPermanentlyDisabled()) continue;
                    float smokeSizeValue = MAGNITUDE.get(weapon.getSize()).floatValue();
                    Vector2f location = MathUtils.getRandomPointInCircle(null, (float)5.0f);
                    Color color = ShipColors.colorJitter(ShipColors.colorBlend(smokeColor, SMOKE1_MOD, 0.9f), 10.0f);
                    Color color2 = ShipColors.colorJitter(ShipColors.colorBlend(smokeColor, SMOKE2_MOD, 0.9f), 30.0f);
                    this.engine.addSmokeParticle(weapon.getLocation(), location, 40.0f * smokeSize * smokeSizeValue, 0.1f, 4.0f, color);
                    this.engine.addSmokeParticle(weapon.getLocation(), location, 20.0f * smokeSize * smokeSizeValue, 0.1f, 3.0f, color2);
                }
            }
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }

    static {
        MAGNITUDE.put(WeaponAPI.WeaponSize.SMALL, Float.valueOf(1.0f));
        MAGNITUDE.put(WeaponAPI.WeaponSize.MEDIUM, Float.valueOf(1.5f));
        MAGNITUDE.put(WeaponAPI.WeaponSize.LARGE, Float.valueOf(2.5f));
        try {
            WeaponDamageSmoke.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(WeaponDamageSmoke.class).log((Priority)Level.ERROR, (Object)("Failed to load performance settings: " + e.getMessage()));
            enabled = false;
        }
    }
}

