/*
 * Decompiled with CFR 0.152.
 */
package org.dark.graphics.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.graphics.util.AnamorphicFlare;
import org.dark.graphics.util.ShipColors;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.dark.shaders.util.ShaderLib;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.combat.entities.AnchoredEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ShipDestructionEffects
extends BaseEveryFrameCombatPlugin {
    private static final Map<String, Float> BOSS_SHIPS = new HashMap<String, Float>(9);
    private static final Color COLOR_BLACK1 = new Color(0, 0, 0, 0);
    private static final Color COLOR_BLACK2 = new Color(0, 0, 0, 50);
    private static final Color COLOR_MAIN = new Color(255, 160, 30);
    private static final Color COLOR_WHITE1 = new Color(255, 255, 255, 255);
    private static final Color COLOR_WHITE2 = new Color(255, 255, 255, 50);
    private static final String DATA_KEY = "GLib_ShipDestructionEffects";
    private static final Map<ShipAPI.HullSize, Float> EXPLOSION_LENGTH = new HashMap<ShipAPI.HullSize, Float>(6);
    private static final Map<ShipAPI.HullSize, Float> EXPLOSION_SIZE_MOD = new HashMap<ShipAPI.HullSize, Float>(6);
    private static final Map<ShipAPI.HullSize, Float> FLARE_BRIGHTNESS = new HashMap<ShipAPI.HullSize, Float>(6);
    private static final Map<ShipAPI.HullSize, Float> FLARE_THICKNESS = new HashMap<ShipAPI.HullSize, Float>(6);
    private static final Map<ShipAPI.HullSize, Float> LIGHT_DURATION = new HashMap<ShipAPI.HullSize, Float>(6);
    private static final Map<ShipAPI.HullSize, Float> LIGHT_INTENSITY = new HashMap<ShipAPI.HullSize, Float>(6);
    private static final float OFFSCREEN_GRACE_CONSTANT = 500.0f;
    private static final float OFFSCREEN_GRACE_FACTOR = 2.0f;
    private static final Map<ShipAPI.HullSize, Float> RIPPLE_LENGTH = new HashMap<ShipAPI.HullSize, Float>(6);
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private static final Vector2f ZERO = new Vector2f();
    private static boolean enabled = true;
    private static boolean explosionEnabled = true;
    private static boolean offscreen = false;
    private static boolean shockwaveEnabled = true;
    private static float trailScale = 1.0f;
    private static boolean trailsEnabled = true;
    private CombatEngineAPI engine;
    private IntervalUtil interval;

    private static float effectiveRadius(ShipAPI ship) {
        if (ship.getSpriteAPI() == null || ship.isPiece()) {
            return ship.getCollisionRadius();
        }
        float fudgeFactor = 1.5f;
        return (ship.getSpriteAPI().getWidth() / 2.0f + ship.getSpriteAPI().getHeight() / 2.0f) * 0.5f * fudgeFactor;
    }

    private static void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        explosionEnabled = settings.getBoolean("enableExplosionEffects");
        offscreen = settings.getBoolean("drawOffscreenParticles");
        shockwaveEnabled = settings.getBoolean("enableExplosionShockwave");
        trailsEnabled = settings.getBoolean("enableExplosionTrails");
        trailScale = (float)settings.getDouble("explosionTrailScale");
        if (trailScale <= 0.01f) {
            trailsEnabled = false;
        }
        enabled = explosionEnabled || shockwaveEnabled || trailsEnabled;
    }

    public void advance(float amount, List<InputEventAPI> events) {
        Vector2f vel;
        float intensity2;
        String style;
        ShipAPI.HullSize shipHullSize;
        float shipRadius;
        Vector2f shipLoc;
        ShipAPI ship;
        if (this.engine == null || !enabled) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        Set<ShipAPI> deadShips = localData.deadShips;
        List<ExplodingShip> explodingShips = localData.explodingShips;
        this.interval.advance(amount);
        List ships = this.engine.getShips();
        int shipsSize = ships.size();
        for (int i = 0; i < shipsSize; ++i) {
            ship = (ShipAPI)ships.get(i);
            if (ship == null || !ship.isHulk() || deadShips.contains(ship)) continue;
            deadShips.add(ship);
            shipLoc = ship.getLocation();
            Vector2f shipVel = ship.getVelocity();
            shipRadius = ShipDestructionEffects.effectiveRadius(ship);
            shipHullSize = ship.getHullSize();
            style = ship.getHullStyleId();
            if (ShipColors.EXPLOSION_COLORS.get(style) == null) {
                style = "MIDLINE";
            }
            if (explosionEnabled && shipHullSize != ShipAPI.HullSize.FIGHTER && !ship.isDrone() && !ship.isPiece()) {
                float intensity = FLARE_BRIGHTNESS.get(shipHullSize).floatValue() / 10.0f;
                intensity2 = FLARE_THICKNESS.get(shipHullSize).floatValue() / 3.0f;
                AnamorphicFlare.createFlare(ship, new Vector2f((ReadableVector2f)shipLoc), this.engine, intensity, intensity2, 0.0f, 15.0f, 1.0f, ShipColors.EXPLOSION_COLORS.get(style), COLOR_WHITE1);
            }
            if (shockwaveEnabled && !ship.isFighter() && !ship.isPiece()) {
                RippleDistortion ripple = new RippleDistortion(shipLoc, shipVel);
                ripple.setSize(shipRadius * 4.5f);
                ripple.setIntensity(shipRadius);
                ripple.setFrameRate(60.0f / RIPPLE_LENGTH.get(shipHullSize).floatValue());
                ripple.fadeInSize(RIPPLE_LENGTH.get(shipHullSize).floatValue() * 1.5f);
                ripple.fadeOutIntensity(RIPPLE_LENGTH.get(shipHullSize).floatValue());
                ripple.setSize(shipRadius * 1.5f);
                DistortionShader.addDistortion(ripple);
            }
            if (explosionEnabled) {
                this.engine.addHitParticle(shipLoc, ZERO, shipRadius * 10.0f, 0.75f, shipRadius / 50.0f, COLOR_WHITE1);
                this.engine.addSmoothParticle(shipLoc, ZERO, shipRadius * 7.5f, 0.25f, shipRadius / 35.0f, COLOR_WHITE2);
                if (offscreen || ShaderLib.isOnScreen(shipLoc, shipRadius * 2.0f * 2.0f + 500.0f)) {
                    Color color = ShipColors.colorJitter(ShipColors.colorBlend(ShipColors.EXPLOSION_COLORS.get(style), COLOR_BLACK1, 0.2f), 50.0f);
                    this.engine.spawnExplosion(shipLoc, shipVel, color, shipRadius * 2.0f, shipRadius / 60.0f * ((float)Math.random() * 0.25f + 1.0f));
                }
                if (!ship.isPiece()) {
                    if (ship.getHullSize() == ShipAPI.HullSize.FIGHTER) {
                        this.engine.addSmoothParticle(shipLoc, ZERO, shipRadius * 12.0f, 0.5f, 0.05f, COLOR_WHITE1);
                    } else if (ship.getHullSize() == ShipAPI.HullSize.FRIGATE) {
                        this.engine.addSmoothParticle(shipLoc, ZERO, shipRadius * 15.0f, 1.0f, 0.05f, COLOR_WHITE1);
                    } else if (ship.getHullSize() == ShipAPI.HullSize.DESTROYER) {
                        this.engine.addSmoothParticle(shipLoc, ZERO, shipRadius * 15.0f, 1.0f, 0.075f, COLOR_WHITE1);
                    } else if (ship.getHullSize() == ShipAPI.HullSize.CRUISER) {
                        this.engine.addSmoothParticle(shipLoc, ZERO, shipRadius * 15.0f, 1.0f, 0.1f, COLOR_WHITE1);
                    } else {
                        this.engine.addSmoothParticle(shipLoc, ZERO, shipRadius * 15.0f, 1.0f, 0.125f, COLOR_WHITE1);
                    }
                }
                StandardLight light = new StandardLight(shipLoc, shipVel, ZERO, null);
                if (ship.isPiece()) {
                    light.setSize(shipRadius * EXPLOSION_SIZE_MOD.get(ShipAPI.HullSize.FRIGATE).floatValue() * 4.0f);
                    light.setIntensity(LIGHT_INTENSITY.get(ShipAPI.HullSize.FRIGATE).floatValue());
                    light.setLifetime(LIGHT_DURATION.get(ShipAPI.HullSize.FRIGATE).floatValue());
                    light.setAutoFadeOutTime(0.5f + LIGHT_DURATION.get(ShipAPI.HullSize.FRIGATE).floatValue());
                } else {
                    light.setSize(shipRadius * EXPLOSION_SIZE_MOD.get(shipHullSize).floatValue() * 4.0f);
                    light.setIntensity(LIGHT_INTENSITY.get(shipHullSize).floatValue());
                    light.setLifetime(LIGHT_DURATION.get(shipHullSize).floatValue());
                    light.setAutoFadeOutTime(0.5f + LIGHT_DURATION.get(shipHullSize).floatValue());
                }
                light.setColor(ShipColors.EXPLOSION_COLORS.get(style));
                LightShader.addLight(light);
            }
            if (!trailsEnabled || ship.isShuttlePod() || ship.isDrone()) continue;
            int count = (int)(shipRadius * EXPLOSION_SIZE_MOD.get(shipHullSize).floatValue() / 4.0f);
            float length = EXPLOSION_LENGTH.get(shipHullSize).floatValue() * ((float)Math.random() * 0.5f + 0.75f);
            if (ship.isPiece()) {
                count /= 2;
            }
            if (count < 0) {
                count = 1;
            }
            ExplodingShip exploder = new ExplodingShip(ship, count, length / (float)count);
            explodingShips.add(exploder);
        }
        Iterator<ShipAPI> iter = deadShips.iterator();
        while (iter.hasNext()) {
            ship = iter.next();
            if (ship == null || ships.contains(ship)) continue;
            shipLoc = ship.getLocation();
            String shipHullId = ship.getHullSpec().getBaseHullId();
            shipRadius = ShipDestructionEffects.effectiveRadius(ship);
            shipHullSize = ship.getHullSize();
            if (explosionEnabled) {
                style = ship.getHullStyleId();
                if (ShipColors.EXPLOSION_COLORS.get(style) == null) {
                    style = "MIDLINE";
                }
                if (this.engine.isInCampaign() || this.engine.isInCampaignSim() || this.engine.isSimulation() || this.engine.getPlayerShip() == null || !this.engine.getPlayerShip().getHullSpec().getHullId().contentEquals("swp_arcade_superhyperion") || BOSS_SHIPS.containsKey(shipHullId)) {
                    float intensity;
                    this.engine.addHitParticle(shipLoc, ZERO, shipRadius * 15.0f, 0.75f, shipRadius / 15.0f, COLOR_WHITE1);
                    this.engine.addSmoothParticle(shipLoc, ZERO, shipRadius * 10.0f, 0.25f, shipRadius / 10.0f, COLOR_WHITE2);
                    if (offscreen || ShaderLib.isOnScreen(shipLoc, shipRadius * 3.0f * 2.0f + 500.0f)) {
                        Color color = ShipColors.colorJitter(ShipColors.colorBlend(ShipColors.EXPLOSION_COLORS.get(style), COLOR_BLACK1, 0.2f), 50.0f);
                        this.engine.spawnExplosion(shipLoc, ZERO, color, shipRadius * 3.0f, shipRadius / 20.0f * ((float)Math.random() * 0.25f + 1.0f));
                    }
                    if (ship.isPiece()) {
                        intensity = FLARE_BRIGHTNESS.get(ShipAPI.HullSize.FRIGATE).floatValue() / 10.0f;
                        intensity2 = FLARE_THICKNESS.get(ShipAPI.HullSize.FRIGATE).floatValue() / 3.0f;
                    } else {
                        intensity = FLARE_BRIGHTNESS.get(shipHullSize).floatValue() / 10.0f;
                        intensity2 = FLARE_THICKNESS.get(shipHullSize).floatValue() / 3.0f;
                    }
                    AnamorphicFlare.createFlare(ship, new Vector2f((ReadableVector2f)shipLoc), this.engine, intensity, intensity2, 0.0f, 15.0f, 1.0f, ShipColors.EXPLOSION_COLORS.get(style), COLOR_WHITE1);
                }
                StandardLight light = new StandardLight(shipLoc, ZERO, ZERO, null);
                if (ship.isPiece()) {
                    light.setSize(shipRadius * EXPLOSION_SIZE_MOD.get(ShipAPI.HullSize.FRIGATE).floatValue() * 3.0f);
                    light.setIntensity(LIGHT_INTENSITY.get(ShipAPI.HullSize.FRIGATE).floatValue() * 0.75f);
                    light.setLifetime(LIGHT_DURATION.get(ShipAPI.HullSize.FRIGATE).floatValue());
                    light.setAutoFadeOutTime(0.5f + LIGHT_DURATION.get(ShipAPI.HullSize.FRIGATE).floatValue());
                } else {
                    light.setSize(shipRadius * EXPLOSION_SIZE_MOD.get(shipHullSize).floatValue() * 3.0f);
                    light.setIntensity(LIGHT_INTENSITY.get(shipHullSize).floatValue() * 0.75f);
                    light.setLifetime(LIGHT_DURATION.get(shipHullSize).floatValue());
                    light.setAutoFadeOutTime(0.5f + LIGHT_DURATION.get(shipHullSize).floatValue());
                }
                light.setColor(ShipColors.EXPLOSION_COLORS.get(style));
                LightShader.addLight(light);
                float sizeMod = ship.isPiece() ? EXPLOSION_SIZE_MOD.get(ShipAPI.HullSize.FRIGATE).floatValue() : EXPLOSION_SIZE_MOD.get(shipHullSize).floatValue();
                int particles = (int)(sizeMod * shipRadius / 2.0f * ((float)Math.random() * 0.5f + 0.75f));
                int fire = (int)(sizeMod * shipRadius / 20.0f * ((float)Math.random() * 0.5f + 0.75f));
                if (BOSS_SHIPS.containsKey(shipHullId)) {
                    sizeMod *= 2.0f;
                    particles = (int)((float)particles * 4.0f);
                    fire = (int)((float)fire * 4.0f);
                }
                float renderParticleRadius = 123.74f * (shipRadius / 5.0f) * (BOSS_SHIPS.containsKey(shipHullId) ? 5.0f : 1.0f) + 0.70711f * shipRadius;
                if (offscreen || ShaderLib.isOnScreen(shipLoc, renderParticleRadius * 2.0f + 500.0f)) {
                    for (int i = 0; i < particles; ++i) {
                        Vector2f point = new Vector2f((ReadableVector2f)shipLoc);
                        vel = new Vector2f();
                        vel.x += ((float)Math.random() + (float)Math.random() + (float)Math.random()) * 100.0f / 3.0f - 50.0f;
                        vel.y += ((float)Math.random() + (float)Math.random() + (float)Math.random()) * 100.0f / 3.0f - 50.0f;
                        if (BOSS_SHIPS.containsKey(shipHullId)) {
                            vel.scale(5.0f);
                        }
                        point.x += shipRadius * ((float)Math.random() * 1.0f - 0.5f);
                        point.y += shipRadius * ((float)Math.random() * 1.0f - 0.5f);
                        Color color = ShipColors.colorJitter(ShipColors.EXPLOSION_COLORS.get(style), 50.0f);
                        Color color2 = ShipColors.colorJitter(ShipColors.colorBlend(ShipColors.EXPLOSION_COLORS.get(style), COLOR_BLACK1, 0.2f), 50.0f);
                        this.engine.addHitParticle(point, vel, (float)Math.random() * 5.0f + 5.0f, 1.0f, shipRadius / 5.0f * ((float)Math.random() * 1.5f + 0.25f), color);
                        this.engine.addHitParticle(point, vel, (float)Math.random() * 15.0f + 30.0f, 0.2f, shipRadius / 5.0f * ((float)Math.random() * 1.5f + 0.25f), color2);
                    }
                }
                float renderFireRadius = 2.2097f * (float)Math.sqrt(shipRadius) * (shipRadius / 25.0f) * (BOSS_SHIPS.containsKey(shipHullId) ? 3.0f : 1.0f) + 1.2728f * shipRadius;
                if (offscreen || ShaderLib.isOnScreen(shipLoc, renderFireRadius * 2.0f + 500.0f)) {
                    for (int i = 0; i < fire; ++i) {
                        Vector2f point = new Vector2f((ReadableVector2f)shipLoc);
                        Vector2f vel2 = new Vector2f();
                        vel2.x += ((float)Math.random() * 2.5f - 1.25f) * (float)Math.sqrt(shipRadius);
                        vel2.y += ((float)Math.random() * 2.5f - 1.25f) * (float)Math.sqrt(shipRadius);
                        if (BOSS_SHIPS.containsKey(shipHullId)) {
                            vel2.scale(3.0f);
                        }
                        point.x += shipRadius * ((float)Math.random() * 1.8f - 0.9f);
                        point.y += shipRadius * ((float)Math.random() * 1.8f - 0.9f);
                        Color color = ShipColors.colorJitter(ShipColors.colorBlend(ShipColors.EXPLOSION_COLORS.get(style), COLOR_BLACK1, 0.2f), 50.0f);
                        float size = ((float)Math.random() * 30.0f + 100.0f) * sizeMod;
                        this.engine.spawnExplosion(point, vel2, color, size, shipRadius / 25.0f * ((float)Math.random() * 0.5f + 0.75f));
                    }
                }
            }
            iter.remove();
        }
        Iterator<ExplodingShip> iter2 = explodingShips.iterator();
        while (iter2.hasNext()) {
            float sizeMod;
            ExplodingShip exploder = iter2.next();
            if (exploder.ship == null) {
                exploder.flamePoints.clear();
                iter2.remove();
                continue;
            }
            if (!this.engine.getShips().contains(exploder.ship)) {
                exploder.flamePoints.clear();
                iter2.remove();
                continue;
            }
            Vector2f shipLoc2 = exploder.ship.getLocation();
            String shipHullId = exploder.ship.getHullSpec().getHullId();
            float shipRadius2 = ShipDestructionEffects.effectiveRadius(exploder.ship);
            ShipAPI.HullSize shipHullSize2 = exploder.ship.getHullSize();
            Vector2f shipVel = exploder.ship.getVelocity();
            String style2 = exploder.ship.getHullStyleId();
            if (ShipColors.EXPLOSION_COLORS.get(style2) == null) {
                style2 = "MIDLINE";
            }
            Iterator<FlamePoint> iter3 = exploder.flamePoints.iterator();
            while (iter3.hasNext()) {
                FlamePoint flamePoint = iter3.next();
                if (!flamePoint.tick(amount) && CollisionUtils.isPointWithinBounds((Vector2f)flamePoint.anchor.getLocation(), (CombatEntityAPI)exploder.ship)) {
                    if (!this.interval.intervalElapsed() || !offscreen && !ShaderLib.isOnScreen(flamePoint.anchor.getLocation(), 726.28f)) continue;
                    Vector2f point = new Vector2f((ReadableVector2f)flamePoint.anchor.getLocation());
                    Vector2f vel3 = new Vector2f();
                    Vector2f vel2 = new Vector2f();
                    Color color = ShipColors.colorJitter(ShipColors.colorBlend(ShipColors.colorBlend(ShipColors.EXPLOSION_COLORS.get(style2), COLOR_MAIN, 0.75f), COLOR_BLACK1, 0.2f), 50.0f);
                    Color color2 = ShipColors.colorJitter(ShipColors.colorBlend(ShipColors.colorBlend(ShipColors.EXPLOSION_COLORS.get(style2), COLOR_MAIN, 0.75f), COLOR_BLACK1, 0.75f), 30.0f);
                    Color color3 = ShipColors.colorBlend(ShipColors.EXPLOSION_COLORS.get(style2), COLOR_WHITE1, 0.5f);
                    sizeMod = EXPLOSION_SIZE_MOD.get(shipHullSize2).floatValue();
                    float size = (float)Math.random() * 25.0f * sizeMod * flamePoint.scale;
                    float size2 = ((float)Math.random() * 10.0f + 40.0f) * sizeMod * flamePoint.scale;
                    float size3 = ((float)Math.random() * 40.0f + 80.0f) * sizeMod * flamePoint.scale;
                    float size4 = ((float)Math.random() * 15.0f + 5.0f) * flamePoint.scale;
                    vel3.x += (float)Math.random() * 40.0f - 20.0f;
                    vel3.y += (float)Math.random() * 40.0f - 20.0f;
                    vel2.x += (float)Math.random() * 20.0f - 10.0f;
                    vel2.y += (float)Math.random() * 20.0f - 10.0f;
                    if (!((float)Math.random() <= (flamePoint.anchor.getVelocity().length() + 50.0f) / 75.0f)) continue;
                    this.engine.addHitParticle(point, flamePoint.anchor.getVelocity(), size4, 0.65f, (float)Math.random() * 0.15f + 0.3f, color3);
                    if ((float)Math.random() >= 0.5f) {
                        this.engine.spawnExplosion(point, vel3, color, size, (float)Math.random() * 1.0f + 0.5f);
                        this.engine.addSmokeParticle(point, vel2, size2, (float)Math.random() * 0.025f + 0.1f, (float)Math.random() * 4.0f + 4.0f, color2);
                        continue;
                    }
                    this.engine.addHitParticle(point, vel3, size3, (float)Math.random() * 0.05f + 0.05f, (float)Math.random() * 0.5f + 0.25f, color);
                    continue;
                }
                iter3.remove();
            }
            if (exploder.flamePoints.isEmpty() && exploder.count <= 0) {
                iter2.remove();
                continue;
            }
            if (!exploder.tick(amount)) continue;
            if (exploder.count <= 0) {
                if (!BOSS_SHIPS.containsKey(shipHullId)) continue;
                this.engine.applyDamage((CombatEntityAPI)exploder.ship, shipLoc2, 1000000.0f, DamageType.ENERGY, 0.0f, true, true, (Object)exploder.ship);
                continue;
            }
            ShipAPI ship2 = exploder.ship;
            float renderExplosionRadius = 1.4142f * shipRadius2 + shipVel.length() * 2.4f * EXPLOSION_SIZE_MOD.get(shipHullSize2).floatValue();
            if (offscreen || ShaderLib.isOnScreen(shipLoc2, renderExplosionRadius * 2.0f + 500.0f)) {
                int bound = 100;
                while (bound > 0) {
                    --bound;
                    Vector2f point = new Vector2f((ReadableVector2f)shipLoc2);
                    point.x += shipRadius2 * ((float)Math.random() * 2.0f - 1.0f);
                    point.y += shipRadius2 * ((float)Math.random() * 2.0f - 1.0f);
                    if (!CollisionUtils.isPointWithinBounds((Vector2f)point, (CombatEntityAPI)ship2)) continue;
                    vel = new Vector2f((ReadableVector2f)shipVel);
                    Vector2f vel2 = new Vector2f((ReadableVector2f)shipVel);
                    float rand = (float)Math.random() * 0.5f + 0.5f;
                    sizeMod = EXPLOSION_SIZE_MOD.get(shipHullSize2).floatValue();
                    float otherSize = (float)Math.sqrt(shipRadius2);
                    float size = (30.0f + (float)Math.random() * 30.0f) * sizeMod;
                    Color color = ShipColors.colorJitter(ShipColors.colorBlend(ShipColors.colorBlend(ShipColors.EXPLOSION_COLORS.get(style2), COLOR_MAIN, 0.75f), COLOR_BLACK1, 0.2f), 50.0f);
                    Color color2 = ShipColors.colorJitter(ShipColors.colorBlend(ShipColors.colorBlend(ShipColors.EXPLOSION_COLORS.get(style2), COLOR_MAIN, 0.75f), COLOR_BLACK2, 0.8f), 15.0f);
                    if (BOSS_SHIPS.containsKey(shipHullId)) {
                        size *= BOSS_SHIPS.get(shipHullId).floatValue();
                    }
                    vel.x *= rand;
                    vel.y *= rand;
                    vel2.x *= rand * 0.5f;
                    vel2.y *= rand * 0.5f;
                    this.engine.spawnExplosion(point, vel, color, size, size / 25.0f);
                    this.engine.addSmokeParticle(point, vel2, size, 0.25f, size / 10.0f, color2);
                    if ((double)((float)Math.random()) >= 0.75 || BOSS_SHIPS.containsKey(shipHullId) && (double)((float)Math.random()) >= 0.5) {
                        Global.getSoundPlayer().playSound("explosion_from_damage", 0.95f + (float)Math.random() * 0.05f, sizeMod / 2.0f, point, vel);
                        Color color3 = ShipColors.colorJitter(ShipColors.colorBlend(ShipColors.colorBlend(ShipColors.EXPLOSION_COLORS.get(style2), COLOR_MAIN, 0.75f), COLOR_WHITE1, 0.33f), 75.0f);
                        StandardLight light = new StandardLight(point, shipVel, ZERO, null);
                        light.setSize(size * 6.0f);
                        light.setIntensity(size / 60.0f);
                        light.setColor(color3);
                        light.fadeOut(size / 90.0f);
                        LightShader.addLight(light);
                        if (BOSS_SHIPS.containsKey(shipHullId)) {
                            float intensity = FLARE_BRIGHTNESS.get(shipHullSize2).floatValue() / 50.0f;
                            float intensity22 = FLARE_THICKNESS.get(shipHullSize2).floatValue() * 2.0f;
                            AnamorphicFlare.createFlare(ship2, point, this.engine, intensity, intensity22, 0.0f, 15.0f, 1.0f, color, color3);
                            RippleDistortion ripple = new RippleDistortion(point, shipVel);
                            ripple.setSize(size * 1.0f);
                            ripple.setIntensity(size * 0.1f);
                            ripple.setFrameRate(60.0f / (size / 300.0f));
                            ripple.fadeInSize(size / 300.0f);
                            ripple.fadeOutIntensity(size / 300.0f);
                            DistortionShader.addDistortion(ripple);
                        } else {
                            this.engine.addHitParticle(point, new Vector2f((ReadableVector2f)shipVel), size * 3.0f, 1.0f, size / 60.0f, COLOR_WHITE1);
                            this.engine.spawnExplosion(point, ZERO, color, otherSize * 15.0f * ((float)Math.random() * 0.3f + 0.85f), 0.15f * sizeMod);
                            this.engine.addSmoothParticle(point, new Vector2f((ReadableVector2f)shipVel), otherSize * 30.0f * ((float)Math.random() * 0.3f + 0.85f), 0.075f, 0.15f, color);
                        }
                        float length = EXPLOSION_LENGTH.get(shipHullSize2).floatValue() * ((float)Math.random() * 5.0f + 2.5f);
                        exploder.flamePoints.add(new FlamePoint(new AnchoredEntity((CombatEntityAPI)ship2, point), length, (float)Math.random() * 1.3f + 0.35f));
                        break;
                    }
                    this.engine.addHitParticle(point, new Vector2f((ReadableVector2f)shipVel), size, 0.5f, size / 60.0f, COLOR_WHITE1);
                    break;
                }
            }
            --exploder.count;
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
        this.interval = new IntervalUtil(0.1f / trailScale, 0.1f / trailScale);
    }

    static {
        BOSS_SHIPS.put("swp_arcade_superhyperion", Float.valueOf(4.0f));
        BOSS_SHIPS.put("swp_arcade_oberon", Float.valueOf(2.0f));
        BOSS_SHIPS.put("swp_arcade_ultron", Float.valueOf(2.0f));
        BOSS_SHIPS.put("swp_arcade_zeus", Float.valueOf(2.0f));
        BOSS_SHIPS.put("swp_arcade_ezekiel", Float.valueOf(3.0f));
        BOSS_SHIPS.put("swp_arcade_cristarium", Float.valueOf(2.0f));
        BOSS_SHIPS.put("swp_arcade_zero", Float.valueOf(4.0f));
        BOSS_SHIPS.put("swp_arcade_superzero", Float.valueOf(5.0f));
        BOSS_SHIPS.put("swp_arcade_hyperzero", Float.valueOf(6.0f));
        EXPLOSION_LENGTH.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.5f));
        EXPLOSION_LENGTH.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(2.5f));
        EXPLOSION_LENGTH.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(5.0f));
        EXPLOSION_LENGTH.put(ShipAPI.HullSize.DEFAULT, Float.valueOf(5.0f));
        EXPLOSION_LENGTH.put(ShipAPI.HullSize.CRUISER, Float.valueOf(7.5f));
        EXPLOSION_LENGTH.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(10.0f));
        EXPLOSION_SIZE_MOD.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.5f));
        EXPLOSION_SIZE_MOD.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(0.75f));
        EXPLOSION_SIZE_MOD.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(1.0f));
        EXPLOSION_SIZE_MOD.put(ShipAPI.HullSize.DEFAULT, Float.valueOf(1.0f));
        EXPLOSION_SIZE_MOD.put(ShipAPI.HullSize.CRUISER, Float.valueOf(1.25f));
        EXPLOSION_SIZE_MOD.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(1.5f));
        FLARE_BRIGHTNESS.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(10.0f));
        FLARE_BRIGHTNESS.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(25.0f));
        FLARE_BRIGHTNESS.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(50.0f));
        FLARE_BRIGHTNESS.put(ShipAPI.HullSize.DEFAULT, Float.valueOf(50.0f));
        FLARE_BRIGHTNESS.put(ShipAPI.HullSize.CRUISER, Float.valueOf(100.0f));
        FLARE_BRIGHTNESS.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(150.0f));
        FLARE_THICKNESS.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.33f));
        FLARE_THICKNESS.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(0.1f));
        FLARE_THICKNESS.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(0.06f));
        FLARE_THICKNESS.put(ShipAPI.HullSize.DEFAULT, Float.valueOf(0.06f));
        FLARE_THICKNESS.put(ShipAPI.HullSize.CRUISER, Float.valueOf(0.04f));
        FLARE_THICKNESS.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(0.03f));
        LIGHT_DURATION.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.0f));
        LIGHT_DURATION.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(0.5f));
        LIGHT_DURATION.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(1.0f));
        LIGHT_DURATION.put(ShipAPI.HullSize.DEFAULT, Float.valueOf(1.0f));
        LIGHT_DURATION.put(ShipAPI.HullSize.CRUISER, Float.valueOf(1.5f));
        LIGHT_DURATION.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(2.0f));
        LIGHT_INTENSITY.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.5f));
        LIGHT_INTENSITY.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(1.0f));
        LIGHT_INTENSITY.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(1.5f));
        LIGHT_INTENSITY.put(ShipAPI.HullSize.DEFAULT, Float.valueOf(1.5f));
        LIGHT_INTENSITY.put(ShipAPI.HullSize.CRUISER, Float.valueOf(1.75f));
        LIGHT_INTENSITY.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(2.0f));
        RIPPLE_LENGTH.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.5f));
        RIPPLE_LENGTH.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(0.75f));
        RIPPLE_LENGTH.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(1.0f));
        RIPPLE_LENGTH.put(ShipAPI.HullSize.DEFAULT, Float.valueOf(1.0f));
        RIPPLE_LENGTH.put(ShipAPI.HullSize.CRUISER, Float.valueOf(1.25f));
        RIPPLE_LENGTH.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(1.5f));
        try {
            ShipDestructionEffects.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(ShipDestructionEffects.class).log((Priority)Level.ERROR, (Object)("Failed to load performance settings: " + e.getMessage()));
            enabled = false;
        }
    }

    private static final class LocalData {
        final Set<ShipAPI> deadShips = new LinkedHashSet<ShipAPI>(100);
        final List<ExplodingShip> explodingShips = new LinkedList<ExplodingShip>();

        private LocalData() {
        }
    }

    private static final class FlamePoint {
        private float ticker;
        private final float time;
        AnchoredEntity anchor;
        float scale;

        private FlamePoint(AnchoredEntity anchor, float time, float scale) {
            this.anchor = anchor;
            this.time = time;
            this.scale = scale;
            this.ticker = 0.0f;
        }

        private boolean tick(float amount) {
            this.ticker += amount;
            if (this.ticker >= this.time) {
                this.ticker -= this.time;
                return true;
            }
            return false;
        }
    }

    private static final class ExplodingShip {
        private final float interval;
        private float ticker;
        int count;
        List<FlamePoint> flamePoints;
        ShipAPI ship;

        private ExplodingShip(ShipAPI ship, int count, float interval) {
            this.ship = ship;
            this.count = (int)((float)count * trailScale);
            this.interval = interval / trailScale;
            this.flamePoints = new LinkedList<FlamePoint>();
            this.ticker = 0.0f;
        }

        private boolean tick(float amount) {
            this.ticker += amount;
            if (this.ticker >= this.interval) {
                this.ticker -= this.interval;
                return true;
            }
            return false;
        }
    }
}

