/*
 * Decompiled with CFR 0.152.
 */
package org.dark.graphics.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.ModSpecAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MissileSelfDestruct
extends BaseEveryFrameCombatPlugin {
    private static final Set<String> EXCLUDED_MISSILES = new HashSet<String>(20);
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private static final String SETTINGS_SPREADSHEET = "data/config/glib/no_self_destruct.csv";
    private static boolean enabled = true;
    private CombatEngineAPI engine;

    public static void loadSettings() throws IOException, JSONException {
        for (ModSpecAPI mod : Global.getSettings().getModManager().getEnabledModsCopy()) {
            JSONArray rows;
            try {
                rows = Global.getSettings().getMergedSpreadsheetDataForMod("id", SETTINGS_SPREADSHEET, mod.getId());
            }
            catch (RuntimeException e) {
                continue;
            }
            for (int i = 0; i < rows.length(); ++i) {
                String id = rows.getJSONObject(i).getString("id");
                EXCLUDED_MISSILES.add(id);
            }
        }
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        enabled = settings.getBoolean("enableMissileSelfDestruct");
    }

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null || !enabled) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        List missiles = this.engine.getMissiles();
        int size = missiles.size();
        for (int i = 0; i < size; ++i) {
            MissileAPI missile = (MissileAPI)missiles.get(i);
            if (!missile.isFading() || missile.isFlare() || missile.isMine() || missile.getCollisionClass() == CollisionClass.NONE || !((float)Math.random() > 0.75f) || missile.getProjectileSpecId() != null && EXCLUDED_MISSILES.contains(missile.getProjectileSpecId())) continue;
            this.engine.applyDamage((CombatEntityAPI)missile, missile.getLocation(), missile.getHitpoints() * 2.0f, DamageType.FRAGMENTATION, 0.0f, false, false, (Object)missile);
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }
}

