/*
 * Decompiled with CFR 0.152.
 */
package org.dark.graphics.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.graphics.plugins.ShipDestructionEffects;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class LightInjector
extends BaseEveryFrameCombatPlugin {
    private static final String DATA_KEY = "GLib_LightInjector";
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private static final Vector2f ZERO = new Vector2f();
    private static boolean hyperEnabled;
    private static boolean sunEnabled;
    private CombatEngineAPI engine;

    private static float effectiveRadius(ShipAPI ship) {
        if (ship.getSpriteAPI() == null || ship.isPiece()) {
            return ship.getCollisionRadius();
        }
        float fudgeFactor = 1.5f;
        return (ship.getSpriteAPI().getWidth() / 2.0f + ship.getSpriteAPI().getHeight() / 2.0f) * 0.5f * fudgeFactor;
    }

    private static List<NearbyPlanetData> getNearbyStars(CampaignFleetAPI playerFleet) {
        LocationAPI loc = playerFleet.getContainingLocation();
        ArrayList<NearbyPlanetData> result = new ArrayList<NearbyPlanetData>(2);
        if (loc instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)loc;
            List planets = system.getPlanets();
            for (PlanetAPI planet : planets) {
                if (!planet.isStar()) continue;
                Vector2f vector = Vector2f.sub((Vector2f)playerFleet.getLocation(), (Vector2f)planet.getLocation(), (Vector2f)new Vector2f());
                result.add(new NearbyPlanetData(vector, planet));
            }
        }
        return result;
    }

    private static void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        sunEnabled = settings.getBoolean("enableSunLight");
        hyperEnabled = settings.getBoolean("enableHyperLight");
    }

    public void advance(float amount, List<InputEventAPI> events) {
        StandardLight light;
        Map.Entry<ShipAPI, StandardLight> entry;
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        Map<ShipAPI, StandardLight> lights = localData.lights;
        Map<ShipAPI, StandardLight> travelLights = localData.travelLights;
        List ships = this.engine.getShips();
        int shipsSize = ships.size();
        block14: for (int i = 0; i < shipsSize; ++i) {
            String id;
            ShipAPI ship = (ShipAPI)ships.get(i);
            if (ship.isHulk()) continue;
            float shipRadius = LightInjector.effectiveRadius(ship);
            if (ship.getTravelDrive().isActive() && !ship.isFighter()) {
                StandardLight light2;
                Vector2f location = null;
                if (ship.getEngineController() == null) break;
                List engines = ship.getEngineController().getShipEngines();
                int num = 0;
                int enginesSize = engines.size();
                for (int j = 0; j < enginesSize; ++j) {
                    ShipEngineControllerAPI.ShipEngineAPI eng = (ShipEngineControllerAPI.ShipEngineAPI)engines.get(j);
                    if (!eng.isActive() || eng.isDisabled() || !(eng.getContribution() > 0.0f)) continue;
                    ++num;
                    if (location == null) {
                        location = new Vector2f((ReadableVector2f)eng.getLocation());
                        continue;
                    }
                    Vector2f.add(location, (Vector2f)eng.getLocation(), location);
                }
                if (location == null) break;
                location.scale(1.0f / (float)num);
                if (travelLights.containsKey(ship)) {
                    light2 = travelLights.get(ship);
                    light2.setLocation(location);
                    if ((!ship.getTravelDrive().isActive() || ship.getTravelDrive().isOn()) && !ship.getTravelDrive().isChargedown() || light2.isFadingOut()) continue;
                    light2.fadeOut(1.0f);
                    continue;
                }
                light2 = new StandardLight(location, ZERO, ZERO, null);
                float intensity = (float)Math.sqrt(shipRadius) / 10.0f;
                float size = intensity * 200.0f;
                light2.setIntensity(intensity);
                light2.setSize(size);
                Color color = null;
                if (!ship.getEngineController().getShipEngines().isEmpty()) {
                    color = ((ShipEngineControllerAPI.ShipEngineAPI)ship.getEngineController().getShipEngines().get(0)).getEngineColor();
                }
                if (color != null) {
                    light2.setColor(color);
                }
                if (ship.getTravelDrive().isChargeup()) {
                    light2.fadeIn(2.0f);
                }
                travelLights.put(ship, light2);
                LightShader.addLight(light2);
                continue;
            }
            ShipSystemAPI system = ship.getSystem();
            if (system == null) continue;
            switch (id = system.getId()) {
                case "burndrive": {
                    StandardLight light3;
                    if (!system.isActive()) continue block14;
                    Vector2f location = null;
                    if (ship.getEngineController() == null) continue block14;
                    List engines = ship.getEngineController().getShipEngines();
                    int num = 0;
                    int enginesSize = engines.size();
                    for (int j = 0; j < enginesSize; ++j) {
                        ShipEngineControllerAPI.ShipEngineAPI eng = (ShipEngineControllerAPI.ShipEngineAPI)engines.get(j);
                        if (!eng.isActive() || eng.isDisabled()) continue;
                        ++num;
                        if (location == null) {
                            location = new Vector2f((ReadableVector2f)eng.getLocation());
                            continue;
                        }
                        Vector2f.add((Vector2f)location, (Vector2f)eng.getLocation(), (Vector2f)location);
                    }
                    if (location == null) continue block14;
                    location.scale(1.0f / (float)num);
                    if (lights.containsKey(ship)) {
                        light3 = lights.get(ship);
                        light3.setLocation(location);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light3.isFadingOut()) continue block14;
                        light3.fadeOut(1.0f);
                        continue block14;
                    }
                    light3 = new StandardLight(location, ZERO, ZERO, null);
                    float intensity = (float)Math.sqrt(shipRadius) / 10.0f;
                    float size = intensity * 200.0f;
                    light3.setIntensity(intensity);
                    light3.setSize(size);
                    Color color = null;
                    if (!ship.getEngineController().getShipEngines().isEmpty()) {
                        color = ((ShipEngineControllerAPI.ShipEngineAPI)ship.getEngineController().getShipEngines().get(0)).getEngineColor();
                    }
                    if (color != null) {
                        light3.setColor(color);
                    }
                    light3.fadeIn(2.0f);
                    lights.put(ship, light3);
                    LightShader.addLight(light3);
                    continue block14;
                }
                case "maneuveringjets": {
                    StandardLight light4;
                    if (!system.isActive()) continue block14;
                    Vector2f location = null;
                    if (ship.getEngineController() == null) continue block14;
                    List engines = ship.getEngineController().getShipEngines();
                    int num = 0;
                    int enginesSize = engines.size();
                    for (int j = 0; j < enginesSize; ++j) {
                        ShipEngineControllerAPI.ShipEngineAPI eng = (ShipEngineControllerAPI.ShipEngineAPI)engines.get(j);
                        if (!eng.isActive() || eng.isDisabled()) continue;
                        ++num;
                        if (location == null) {
                            location = new Vector2f((ReadableVector2f)eng.getLocation());
                            continue;
                        }
                        Vector2f.add((Vector2f)location, (Vector2f)eng.getLocation(), (Vector2f)location);
                    }
                    if (location == null) continue block14;
                    location.scale(1.0f / (float)num);
                    if (lights.containsKey(ship)) {
                        light4 = lights.get(ship);
                        light4.setLocation(location);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light4.isFadingOut()) continue block14;
                        light4.fadeOut(1.0f);
                        continue block14;
                    }
                    light4 = new StandardLight(location, ZERO, ZERO, null);
                    float intensity = (float)Math.sqrt(shipRadius) / 40.0f;
                    float size = intensity * 600.0f;
                    light4.setIntensity(intensity);
                    light4.setSize(size);
                    Color color = null;
                    if (!ship.getEngineController().getShipEngines().isEmpty()) {
                        color = ((ShipEngineControllerAPI.ShipEngineAPI)ship.getEngineController().getShipEngines().get(0)).getEngineColor();
                    }
                    if (color != null) {
                        light4.setColor(color);
                    }
                    light4.fadeIn(1.0f);
                    lights.put(ship, light4);
                    LightShader.addLight(light4);
                    continue block14;
                }
                case "plasmajets": {
                    StandardLight light5;
                    if (!system.isActive()) continue block14;
                    Vector2f location = null;
                    if (ship.getEngineController() == null) continue block14;
                    List engines = ship.getEngineController().getShipEngines();
                    int num = 0;
                    int enginesSize = engines.size();
                    for (int j = 0; j < enginesSize; ++j) {
                        ShipEngineControllerAPI.ShipEngineAPI eng = (ShipEngineControllerAPI.ShipEngineAPI)engines.get(j);
                        if (!eng.isActive() || eng.isDisabled()) continue;
                        ++num;
                        if (location == null) {
                            location = new Vector2f((ReadableVector2f)eng.getLocation());
                            continue;
                        }
                        Vector2f.add((Vector2f)location, (Vector2f)eng.getLocation(), (Vector2f)location);
                    }
                    if (location == null) continue block14;
                    location.scale(1.0f / (float)num);
                    if (lights.containsKey(ship)) {
                        light5 = lights.get(ship);
                        light5.setLocation(location);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light5.isFadingOut()) continue block14;
                        light5.fadeOut(2.0f);
                        continue block14;
                    }
                    light5 = new StandardLight(location, ZERO, ZERO, null);
                    float intensity = (float)Math.sqrt(shipRadius) / 25.0f;
                    float size = intensity * 400.0f;
                    light5.setIntensity(intensity);
                    light5.setSize(size);
                    Color color = new Color(100, 255, 100, 255);
                    light5.setColor(color);
                    light5.fadeIn(1.0f);
                    lights.put(ship, light5);
                    LightShader.addLight(light5);
                    continue block14;
                }
                case "microburn": {
                    StandardLight light6;
                    if (!system.isActive()) continue block14;
                    Vector2f location = null;
                    if (ship.getEngineController() == null) continue block14;
                    List engines = ship.getEngineController().getShipEngines();
                    int num = 0;
                    int enginesSize = engines.size();
                    for (int j = 0; j < enginesSize; ++j) {
                        ShipEngineControllerAPI.ShipEngineAPI eng = (ShipEngineControllerAPI.ShipEngineAPI)engines.get(j);
                        if (!eng.isActive() || eng.isDisabled()) continue;
                        ++num;
                        if (location == null) {
                            location = new Vector2f((ReadableVector2f)eng.getLocation());
                            continue;
                        }
                        Vector2f.add((Vector2f)location, (Vector2f)eng.getLocation(), (Vector2f)location);
                    }
                    if (location == null) continue block14;
                    location.scale(1.0f / (float)num);
                    if (lights.containsKey(ship)) {
                        light6 = lights.get(ship);
                        light6.setLocation(location);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light6.isFadingOut()) continue block14;
                        light6.fadeOut(0.5f);
                        continue block14;
                    }
                    light6 = new StandardLight(location, ZERO, ZERO, null);
                    float intensity = (float)Math.sqrt(shipRadius) / 10.0f;
                    float size = intensity * 200.0f;
                    light6.setIntensity(intensity);
                    light6.setSize(size);
                    Color color = new Color(100, 255, 100, 255);
                    light6.setColor(color);
                    light6.fadeIn(0.5f);
                    lights.put(ship, light6);
                    LightShader.addLight(light6);
                    continue block14;
                }
                case "emp": {
                    StandardLight light7;
                    if (!system.isActive()) continue block14;
                    Vector2f location = ship.getLocation();
                    if (lights.containsKey(ship)) {
                        light7 = lights.get(ship);
                        light7.setLocation(location);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light7.isFadingOut()) continue block14;
                        light7.fadeOut(0.5f);
                        continue block14;
                    }
                    light7 = new StandardLight(location, ZERO, ZERO, null);
                    light7.setIntensity(0.3f);
                    light7.setSize(550.0f);
                    light7.setColor(1.0f, 0.65f, 1.0f);
                    light7.fadeIn(0.5f);
                    lights.put(ship, light7);
                    LightShader.addLight(light7);
                    continue block14;
                }
            }
        }
        Iterator<Map.Entry<ShipAPI, StandardLight>> iter = lights.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            ShipAPI ship = entry.getKey();
            if ((ship.getSystem() == null || ship.getSystem().isActive()) && ship.isAlive()) continue;
            light = entry.getValue();
            light.unattach();
            light.fadeOut(0.0f);
            iter.remove();
        }
        iter = travelLights.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            ShipAPI ship = entry.getKey();
            if ((ship.getTravelDrive() == null || ship.getTravelDrive().isActive()) && ship.isAlive()) continue;
            light = entry.getValue();
            light.unattach();
            light.fadeOut(0.0f);
            iter.remove();
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        engine.getCustomData().put(DATA_KEY, new LocalData());
        if (hyperEnabled && engine.isInCampaign() && Global.getSector().getHyperspace() == Global.getSector().getPlayerFleet().getContainingLocation()) {
            engine.addPlugin((EveryFrameCombatPlugin)new HyperPlugin());
        }
        if (sunEnabled && engine.isInCampaign()) {
            List<NearbyPlanetData> stars = LightInjector.getNearbyStars(Global.getSector().getPlayerFleet());
            for (NearbyPlanetData data : stars) {
                engine.addPlugin((EveryFrameCombatPlugin)new SunPlugin(data.offset.length(), data.offset.normalise(data.offset), data.planet));
            }
        }
    }

    static {
        try {
            LightInjector.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(ShipDestructionEffects.class).log((Priority)Level.ERROR, (Object)("Failed to load settings: " + e.getMessage()));
            sunEnabled = false;
            hyperEnabled = false;
        }
    }

    private static class NearbyPlanetData {
        final Vector2f offset;
        final PlanetAPI planet;

        NearbyPlanetData(Vector2f offset, PlanetAPI planet) {
            this.offset = offset;
            this.planet = planet;
        }
    }

    private static final class LocalData {
        final Map<ShipAPI, StandardLight> lights = new LinkedHashMap<ShipAPI, StandardLight>(100);
        final Map<ShipAPI, StandardLight> travelLights = new LinkedHashMap<ShipAPI, StandardLight>(100);

        private LocalData() {
        }
    }

    public static final class SunPlugin
    extends BaseEveryFrameCombatPlugin {
        private boolean started = false;
        private final StandardLight sun;

        public SunPlugin(float distance, Vector2f offset, PlanetAPI star) {
            this(distance, offset, star.getSpec().getCoronaColor(), star.getRadius());
        }

        public SunPlugin(float distance, Vector2f offset, Color color, float radius) {
            float magnitude = (float)Math.sqrt(radius / 500.0f) * radius / (distance + radius) * Global.getSettings().getFloat("sunLightBrightnessScale");
            magnitude = Math.min(Math.max(magnitude * 5.0f, 0.0f), Global.getSettings().getFloat("sunLightBrightnessMax"));
            Vector3f direction = new Vector3f(offset.x, offset.y, -MathUtils.getRandomNumberInRange((float)Global.getSettings().getFloat("sunLightZComponentMin"), (float)Global.getSettings().getFloat("sunLightZComponentMax")));
            direction.normalise();
            this.sun = new StandardLight(direction);
            this.sun.setColor(color);
            this.sun.setIntensity(magnitude);
            this.sun.setSpecularIntensity(magnitude * Global.getSettings().getFloat("sunLightSpecularFactor"));
            this.sun.makePermanent();
        }

        public void advance(float amount, List<InputEventAPI> events) {
            if (!this.started) {
                this.started = true;
                LightShader.addLight(this.sun);
            }
        }

        public void init(CombatEngineAPI engine) {
        }
    }

    public static final class HyperPlugin
    extends BaseEveryFrameCombatPlugin {
        private final Vector3f actualDirection = new Vector3f();
        private final Vector3f baseDirection;
        private final StandardLight hyper;
        private final float sineMScale;
        private float sineTimeM;
        private final float sineTimeMScale;
        private float sineTimeX;
        private final float sineTimeXScale;
        private float sineTimeY;
        private final float sineTimeYScale;
        private float sineTimeZ;
        private final float sineTimeZScale;
        private final float sineXScale;
        private final float sineYScale;
        private final float sineZScale;
        private boolean started = false;

        public HyperPlugin() {
            float magnitude = Global.getSettings().getFloat("sunLightBrightnessScale") / 1.5f;
            magnitude = Math.min(Math.max(magnitude, 0.0f), Global.getSettings().getFloat("sunLightBrightnessMax"));
            Vector2f horizontal = new Vector2f(((float)Math.random() + 1.0E-4f) * 2.0f - 1.0f, ((float)Math.random() + 1.0E-4f) * 2.0f - 1.0f);
            horizontal.normalise();
            this.baseDirection = new Vector3f(horizontal.x, horizontal.y, -0.4f);
            this.baseDirection.normalise();
            this.hyper = new StandardLight(this.baseDirection);
            this.hyper.setColor(new Color(0, 0, 255));
            this.hyper.setIntensity(magnitude);
            this.hyper.setSpecularIntensity(magnitude);
            this.hyper.makePermanent();
            this.sineTimeXScale = (float)Math.random() * 2.0f + 1.0f;
            this.sineTimeYScale = (float)Math.random() * 2.0f + 1.0f;
            this.sineTimeZScale = (float)Math.random() * 2.0f + 1.0f;
            this.sineTimeMScale = (float)Math.random() * 2.0f + 1.0f;
            this.sineTimeX = (float)(Math.random() * Math.PI * 2.0);
            this.sineTimeY = (float)(Math.random() * Math.PI * 2.0);
            this.sineTimeZ = (float)(Math.random() * Math.PI * 2.0);
            this.sineTimeM = (float)(Math.random() * Math.PI * 2.0);
            float r = (float)Math.random();
            if (r < 0.33f) {
                this.sineXScale = (float)Math.random() * 0.4f + 0.4f;
                this.sineYScale = 0.0f;
            } else if (r < 0.67f) {
                this.sineXScale = 0.0f;
                this.sineYScale = (float)Math.random() * 0.4f + 0.4f;
            } else {
                this.sineXScale = (float)Math.random() * 0.4f + 0.4f;
                this.sineYScale = (float)Math.random() * 0.4f + 0.4f;
            }
            this.sineZScale = (float)Math.random() * 0.15f + 0.15f;
            this.sineMScale = (float)Math.random() * 0.1f + 0.1f;
        }

        public void advance(float amount, List<InputEventAPI> events) {
            if (!this.started) {
                this.started = true;
                LightShader.addLight(this.hyper);
            }
            if (!Global.getCombatEngine().isPaused()) {
                this.sineTimeX += amount * this.sineTimeXScale;
                this.sineTimeY += amount * this.sineTimeYScale;
                this.sineTimeZ += amount * this.sineTimeZScale;
                this.sineTimeM += amount * this.sineTimeMScale;
                this.actualDirection.set((ReadableVector3f)this.baseDirection);
                this.actualDirection.x = (float)((double)this.actualDirection.x + Math.sin(this.sineTimeX) * (double)this.sineXScale);
                this.actualDirection.y = (float)((double)this.actualDirection.y + Math.sin(this.sineTimeY) * (double)this.sineYScale);
                this.actualDirection.z = (float)((double)this.actualDirection.z + Math.sin(this.sineTimeZ) * (double)this.sineZScale);
                this.hyper.setDirection(this.actualDirection);
                float magnitude = Global.getSettings().getFloat("sunLightBrightnessScale") * (1.0f + (float)Math.sin(this.sineTimeM) * this.sineMScale) / 1.5f;
                magnitude = Math.min(Math.max(magnitude, 0.0f), Global.getSettings().getFloat("sunLightBrightnessMax"));
                this.hyper.setIntensity(magnitude);
                this.hyper.setSpecularIntensity(magnitude * Global.getSettings().getFloat("sunLightSpecularFactor"));
            }
        }

        public void init(CombatEngineAPI engine) {
        }
    }
}

