/*
 * Decompiled with CFR 0.152.
 */
package org.dark.graphics.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.graphics.plugins.ArcEffectOnOverload;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.Vector2f;

public class InsigniaPlugin
extends BaseEveryFrameCombatPlugin {
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private static boolean enabled = true;
    private CombatEngineAPI engine;

    private static void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        enabled = settings.getBoolean("enableInsignias");
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }

    public void renderInUICoords(ViewportAPI viewport) {
        if (this.engine == null || !enabled) {
            return;
        }
        if (Global.getCombatEngine().isUIShowingHUD()) {
            for (ShipAPI ship : this.engine.getShips()) {
                FleetMemberAPI member;
                DeployedFleetMemberAPI deployedMember;
                CombatFleetManagerAPI manager;
                if (!ship.isAlive() || ship.isFighter() || ship.isDrone() || this.engine.getPlayerShip() == ship || (manager = this.engine.getFleetManager(ship.getOriginalOwner())) == null || (deployedMember = manager.getDeployedFleetMember(ship)) == null || (member = deployedMember.getMember()) == null) continue;
                CaptainTier tier = null;
                PersonAPI captain = member.getCaptain();
                boolean flagship = member.isFlagship();
                if (ship.getOriginalOwner() == 0) {
                    flagship = false;
                }
                if (captain == null) {
                    if (flagship) {
                        tier = CaptainTier.TIER_1;
                    }
                } else if (flagship) {
                    int level = captain.getStats().getLevel();
                    tier = level < 6 ? CaptainTier.TIER_1 : (level < 11 ? CaptainTier.TIER_2 : (level < 16 ? CaptainTier.TIER_3 : CaptainTier.TIER_4));
                } else if (!captain.isDefault()) {
                    int level = captain.getStats().getLevel();
                    tier = level < 6 ? CaptainTier.TIER_1_OFFICER : (level < 11 ? CaptainTier.TIER_2_OFFICER : (level < 16 ? CaptainTier.TIER_3_OFFICER : CaptainTier.TIER_4_OFFICER));
                }
                if (tier == null) continue;
                List corners = new ArrayList<Vector2f>(4);
                corners.add(new Vector2f(ship.getSpriteAPI().getWidth() * -0.5f, ship.getSpriteAPI().getHeight() * 0.5f));
                corners.add(new Vector2f(ship.getSpriteAPI().getWidth() * 0.5f, ship.getSpriteAPI().getHeight() * 0.5f));
                corners.add(new Vector2f(ship.getSpriteAPI().getWidth() * 0.5f, ship.getSpriteAPI().getHeight() * -0.5f));
                corners.add(new Vector2f(ship.getSpriteAPI().getWidth() * -0.5f, ship.getSpriteAPI().getHeight() * -0.5f));
                corners = VectorUtils.rotate(corners, (float)(ship.getFacing() - 90.0f));
                for (Vector2f corner : corners) {
                    Vector2f.add((Vector2f)ship.getLocation(), (Vector2f)corner, (Vector2f)corner);
                    corner.x = viewport.convertWorldXtoScreenX(corner.x);
                    corner.y = viewport.convertWorldYtoScreenY(corner.y);
                }
                Float x = null;
                Float y = null;
                for (Vector2f corner : corners) {
                    x = x == null ? Float.valueOf(corner.x) : Float.valueOf(Math.min(x.floatValue(), corner.x));
                    if (y == null) {
                        y = Float.valueOf(corner.y);
                        continue;
                    }
                    y = Float.valueOf(Math.max(y.floatValue(), corner.y));
                }
                float border = 18.0f;
                float radius = ship.getCollisionRadius() / viewport.getViewMult();
                Vector2f shipLoc = new Vector2f(viewport.convertWorldXtoScreenX(ship.getLocation().x), viewport.convertWorldYtoScreenY(ship.getLocation().y));
                Vector2f loc = new Vector2f(x.floatValue(), y.floatValue());
                Vector2f alternate = MathUtils.getPointOnCircumference((Vector2f)shipLoc, (float)(radius + border), (float)VectorUtils.getAngleStrict((Vector2f)shipLoc, (Vector2f)loc));
                x = Float.valueOf(alternate.x);
                y = Float.valueOf(alternate.y);
                CaptainTier.insignias.renderRegionAtCenter(x.floatValue() + tier.offsetX, y.floatValue() + tier.offsetY, tier.uvLeft, tier.uvBottom, tier.uvRight - tier.uvLeft, tier.uvTop - tier.uvBottom);
            }
        }
    }

    static {
        try {
            InsigniaPlugin.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(ArcEffectOnOverload.class).log((Priority)Level.ERROR, (Object)("Failed to load insignia settings: " + e.getMessage()));
            enabled = false;
        }
    }

    private static enum CaptainTier {
        TIER_1(1.0f, 0.6666667f, 0.0f, 0.33333334f, 26.0f, -26.0f),
        TIER_2(1.0f, 0.6666667f, 0.33333334f, 0.6666667f, 0.0f, -26.0f),
        TIER_3(1.0f, 0.6666667f, 0.6666667f, 1.0f, -26.0f, -26.0f),
        TIER_4(0.6666667f, 0.33333334f, 0.0f, 0.33333334f, 26.0f, 0.0f),
        TIER_1_OFFICER(0.6666667f, 0.33333334f, 0.33333334f, 0.6666667f, 0.0f, 0.0f),
        TIER_2_OFFICER(0.6666667f, 0.33333334f, 0.6666667f, 1.0f, -26.0f, 0.0f),
        TIER_3_OFFICER(0.33333334f, 0.0f, 0.0f, 0.33333334f, 26.0f, 26.0f),
        TIER_4_OFFICER(0.33333334f, 0.0f, 0.33333334f, 0.6666667f, 0.0f, 26.0f);

        static final SpriteAPI insignias;
        final float uvTop;
        final float uvBottom;
        final float uvLeft;
        final float uvRight;
        final float offsetX;
        final float offsetY;

        private CaptainTier(float uvTop, float uvBottom, float uvLeft, float uvRight, float offsetX, float offsetY) {
            this.uvTop = uvTop;
            this.uvBottom = uvBottom;
            this.uvLeft = uvLeft;
            this.uvRight = uvRight;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        static {
            insignias = Global.getSettings().getSprite("icons", "glib_insignia");
        }
    }
}

