/*
 * Decompiled with CFR 0.152.
 */
package org.dark.graphics.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import data.scripts.hullmods.TEM_LatticeShield;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.ShaderModPlugin;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.dark.shaders.distortion.WaveDistortion;
import org.dark.shaders.util.ShaderLib;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.Vector2f;

public class DistortionsPlugin
extends BaseEveryFrameCombatPlugin {
    private static final String DATA_KEY = "GLib_Distortions";
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private static final Vector2f ZERO = new Vector2f();
    private static boolean enabled = true;
    private static boolean mjolnirEnabled = true;
    private static boolean shieldEnabled = true;
    private CombatEngineAPI engine;

    private static void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        shieldEnabled = settings.getBoolean("enableShieldRipples");
        mjolnirEnabled = settings.getBoolean("enableMjolnirRipples");
        enabled = shieldEnabled || mjolnirEnabled;
    }

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null || !enabled) {
            return;
        }
        if (this.engine.isPaused() || !ShaderLib.areShadersAllowed() || !ShaderLib.areBuffersAllowed()) {
            return;
        }
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        Map<DamagingProjectileAPI, ProjectileInfo> projectiles = localData.projectiles;
        List activeProjectiles = this.engine.getProjectiles();
        int size = activeProjectiles.size();
        for (int i = 0; i < size; ++i) {
            DamagingProjectileAPI projectile = (DamagingProjectileAPI)activeProjectiles.get(i);
            if (projectile.didDamage() || projectile.getElapsed() > 0.2f || projectiles.containsKey(projectile)) continue;
            if (projectile.getProjectileSpecId() != null && projectile.getProjectileSpecId().contentEquals("mjolnir_shot") && mjolnirEnabled) {
                WaveDistortion wave = new WaveDistortion(projectile.getLocation(), ZERO);
                wave.setIntensity(5.0f);
                wave.setSize(50.0f);
                wave.flip(true);
                DistortionShader.addDistortion(wave);
                projectiles.put(projectile, new ProjectileInfo(wave, projectile.getDamageAmount()));
                continue;
            }
            if (!shieldEnabled) continue;
            projectiles.put(projectile, new ProjectileInfo(projectile.getDamageAmount()));
        }
        Iterator<Map.Entry<DamagingProjectileAPI, ProjectileInfo>> iter = projectiles.entrySet().iterator();
        while (iter.hasNext()) {
            WaveDistortion wave;
            Map.Entry<DamagingProjectileAPI, ProjectileInfo> entry = iter.next();
            DamagingProjectileAPI projectile = entry.getKey();
            ProjectileInfo info = entry.getValue();
            if (Math.random() > 0.8) {
                info.damage = Math.max(info.damage, projectile.getDamageAmount());
            }
            if (projectile.didDamage()) {
                WaveDistortion wave2;
                CombatEntityAPI target = projectile.getDamageTarget();
                if (target instanceof ShipAPI && shieldEnabled) {
                    ShipAPI ship = (ShipAPI)target;
                    float distanceFromShieldBorder = 0.0f;
                    if (ship.getShield() != null) {
                        distanceFromShieldBorder = Math.abs(MathUtils.getDistance((Vector2f)projectile.getLocation(), (Vector2f)ship.getShield().getLocation()) - ship.getShield().getRadius());
                    }
                    if (ship.getShield() != null && (ship.getShield().isOn() && ship.getShield().isWithinArc(projectile.getLocation()) || ship.getFluxTracker().isOverloaded() && ship.getFluxTracker().getFluxLevel() >= 0.98f && distanceFromShieldBorder <= 10.0f)) {
                        Vector2f position = VectorUtils.getDirectionalVector((Vector2f)ship.getShield().getLocation(), (Vector2f)projectile.getLocation());
                        position.scale(ship.getShield().getRadius());
                        Vector2f.add((Vector2f)position, (Vector2f)ship.getShield().getLocation(), (Vector2f)position);
                        float fader = 1.0f;
                        if (!(projectile instanceof MissileAPI) && projectile.getWeapon() != null) {
                            float lifetime = projectile.getWeapon().getRange() / projectile.getWeapon().getProjectileSpeed();
                            float fadetime = 400.0f / projectile.getWeapon().getProjectileSpeed();
                            fader = Math.max(0.25f, 1.0f - Math.max(0.0f, projectile.getElapsed() / lifetime - 1.0f) / fadetime);
                            if (fader < 0.99f) {
                                fader *= 0.5f;
                            }
                        }
                        float factor = ship.getMutableStats().getShieldDamageTakenMult().getModifiedValue();
                        this.createHitRipple(position, ship.getVelocity(), info.damage * fader * factor, projectile.getDamageType(), VectorUtils.getFacing((Vector2f)VectorUtils.getDirectionalVector((Vector2f)ship.getShield().getLocation(), (Vector2f)projectile.getLocation())), ship.getShield().getRadius());
                    } else if (ShaderModPlugin.templarsExists && TEM_LatticeShield.shieldLevel((ShipAPI)ship) > 0.0f) {
                        float fader = 1.0f;
                        if (!(projectile instanceof MissileAPI) && projectile.getWeapon() != null) {
                            float lifetime = projectile.getWeapon().getRange() / projectile.getWeapon().getProjectileSpeed();
                            float fadetime = 400.0f / projectile.getWeapon().getProjectileSpeed();
                            fader = Math.max(0.25f, 1.0f - Math.max(0.0f, projectile.getElapsed() / lifetime - 1.0f) / fadetime);
                            if (fader < 0.99f) {
                                fader *= 0.5f;
                            }
                        }
                        float factor = ship.getMutableStats().getShieldDamageTakenMult().getModifiedValue();
                        this.createHitRipple(projectile.getLocation(), ship.getVelocity(), info.damage * fader * factor, projectile.getDamageType(), VectorUtils.getFacing((Vector2f)VectorUtils.getDirectionalVector((Vector2f)ship.getLocation(), (Vector2f)projectile.getLocation())), ship.getCollisionRadius());
                    }
                }
                if (info.distortion != null && projectile.getProjectileSpecId().contentEquals("mjolnir_shot") && !(wave2 = (WaveDistortion)info.distortion).isFading()) {
                    wave2.fadeOutIntensity(0.2f);
                }
                iter.remove();
                continue;
            }
            if (!this.engine.isEntityInPlay((CombatEntityAPI)projectile)) {
                if (info.distortion != null && projectile.getProjectileSpecId().contentEquals("mjolnir_shot")) {
                    wave = (WaveDistortion)info.distortion;
                    wave.setLifetime(0.0f);
                }
                iter.remove();
                continue;
            }
            if (info.distortion != null) {
                if (!projectile.getProjectileSpecId().contentEquals("mjolnir_shot")) continue;
                wave = (WaveDistortion)info.distortion;
                wave.setLocation(projectile.getLocation());
                continue;
            }
            if (!projectile.isFading() || info.distortion == null || !projectile.getProjectileSpecId().contentEquals("mjolnir_shot") || (wave = (WaveDistortion)info.distortion).isFading()) continue;
            wave.fadeOutIntensity(0.2f);
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
    }

    private void createHitRipple(Vector2f location, Vector2f velocity, float damage, DamageType type, float direction, float shieldRadius) {
        float end2;
        float start2;
        float end1;
        float dmg = damage;
        if (type == DamageType.FRAGMENTATION) {
            dmg *= 0.25f;
        }
        if (type == DamageType.HIGH_EXPLOSIVE) {
            dmg *= 0.5f;
        }
        if (type == DamageType.KINETIC) {
            dmg *= 2.0f;
        }
        if (dmg < 25.0f) {
            return;
        }
        float fadeTime = (float)Math.pow(dmg, 0.25) * 0.1f;
        float size = (float)Math.pow(dmg, 0.3333333) * 15.0f;
        float ratio = Math.min(size / shieldRadius, 1.0f);
        float arc = 90.0f - ratio * 14.54136f;
        float start1 = direction - arc;
        if (start1 < 0.0f) {
            start1 += 360.0f;
        }
        if ((end1 = direction + arc) >= 360.0f) {
            end1 -= 360.0f;
        }
        if ((start2 = direction + arc) < 0.0f) {
            start2 += 360.0f;
        }
        if ((end2 = direction - arc) >= 360.0f) {
            end2 -= 360.0f;
        }
        RippleDistortion ripple = new RippleDistortion(location, velocity);
        ripple.setSize(size);
        ripple.setIntensity(size * 0.3f);
        ripple.setFrameRate(60.0f / fadeTime);
        ripple.fadeInSize(fadeTime * 1.2f);
        ripple.fadeOutIntensity(fadeTime);
        ripple.setSize(size * 0.2f);
        ripple.setArc(start1, end1);
        DistortionShader.addDistortion(ripple);
        ripple = new RippleDistortion(location, velocity);
        ripple.setSize(size);
        ripple.setIntensity(size * 0.075f);
        ripple.setFrameRate(60.0f / fadeTime);
        ripple.fadeInSize(fadeTime * 1.2f);
        ripple.fadeOutIntensity(fadeTime);
        ripple.setSize(size * 0.2f);
        ripple.setArc(start2, end2);
        DistortionShader.addDistortion(ripple);
    }

    private float getAdjustedDamage(DamagingProjectileAPI proj, float baseDamage, boolean shields) {
        DamageAPI damage = proj.getDamage();
        MutableShipStatsAPI stats = damage.getStats();
        WeaponAPI weapon = proj.getWeapon();
        float dmg = baseDamage;
        if (weapon == null) {
            return dmg;
        }
        if (proj instanceof MissileAPI || weapon.getType() == WeaponAPI.WeaponType.MISSILE) {
            dmg *= stats.getMissileWeaponDamageMult().getModifiedValue();
        }
        if (weapon.getType() == WeaponAPI.WeaponType.BALLISTIC) {
            dmg *= stats.getBallisticWeaponDamageMult().getModifiedValue();
        }
        if (weapon.getType() == WeaponAPI.WeaponType.ENERGY) {
            dmg *= stats.getEnergyWeaponDamageMult().getModifiedValue();
        }
        if (shields) {
            dmg *= stats.getDamageToTargetShieldsMult().getModifiedValue();
        }
        return dmg;
    }

    static {
        try {
            DistortionsPlugin.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(DistortionsPlugin.class).log((Priority)Level.ERROR, (Object)("Failed to load performance settings: " + e.getMessage()));
            enabled = false;
        }
    }

    private static class ProjectileInfo {
        float damage;
        DistortionAPI distortion;

        ProjectileInfo(DistortionAPI distortion, float damage) {
            this.distortion = distortion;
            this.damage = damage;
        }

        ProjectileInfo(float damage) {
            this.distortion = null;
            this.damage = damage;
        }
    }

    private static final class LocalData {
        final Map<DamagingProjectileAPI, ProjectileInfo> projectiles = new LinkedHashMap<DamagingProjectileAPI, ProjectileInfo>(1000);

        private LocalData() {
        }
    }
}

