/*
 * Decompiled with CFR 0.152.
 */
package org.dark.graphics.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.util.ShaderLib;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ArcEffectOnOverload
extends BaseEveryFrameCombatPlugin {
    private static final float OFFSCREEN_GRACE_CONSTANT = 500.0f;
    private static final float OFFSCREEN_GRACE_FACTOR = 2.0f;
    private static final String SETTINGS_FILE = "GRAPHICS_OPTIONS.ini";
    private static boolean enabled = true;
    private static boolean offscreen = false;
    private CombatEngineAPI engine;
    private final IntervalUtil interval = new IntervalUtil(0.25f, 0.5f);

    private static void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        enabled = settings.getBoolean("enableOverloadArcs");
        offscreen = settings.getBoolean("drawOffscreenParticles");
    }

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null || !enabled) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.interval.advance(amount);
        if (this.interval.intervalElapsed()) {
            List ships = this.engine.getShips();
            int size = ships.size();
            for (int i = 0; i < size; ++i) {
                ShipAPI ship = (ShipAPI)ships.get(i);
                if (ship.isHulk() || !ship.getFluxTracker().isOverloaded() || !offscreen && !ShaderLib.isOnScreen(ship.getLocation(), ship.getCollisionRadius() * 2.0f + 500.0f)) continue;
                int arcs = 1;
                if (ship.getHullSize() == ShipAPI.HullSize.FIGHTER) {
                    arcs = 0;
                } else if (ship.getHullSize() == ShipAPI.HullSize.FRIGATE || ship.getHullSize() == ShipAPI.HullSize.DEFAULT) {
                    arcs = 1;
                } else if (ship.getHullSize() == ShipAPI.HullSize.DESTROYER) {
                    arcs = 1;
                } else if (ship.getHullSize() == ShipAPI.HullSize.CRUISER) {
                    arcs = 2;
                } else if (ship.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
                    arcs = 3;
                }
                ShipAPI empTarget = ship;
                for (int a = 0; a < arcs; ++a) {
                    Vector2f point = new Vector2f((ReadableVector2f)ship.getLocation());
                    float angle = MathUtils.getRandomNumberInRange((float)0.0f, (float)360.0f);
                    Vector2f test = new Vector2f(ship.getCollisionRadius(), 0.0f);
                    VectorUtils.rotate((Vector2f)test, (float)angle, (Vector2f)test);
                    Vector2f.add((Vector2f)test, (Vector2f)point, (Vector2f)test);
                    float radiusAtAngle = Misc.getTargetingRadius((Vector2f)test, (CombatEntityAPI)empTarget, (boolean)false);
                    Vector2f add = new Vector2f(radiusAtAngle * (float)Math.random(), 0.0f);
                    VectorUtils.rotate((Vector2f)add, (float)angle, (Vector2f)add);
                    Vector2f.add((Vector2f)add, (Vector2f)point, (Vector2f)point);
                    this.engine.spawnEmpArc(ship, point, (CombatEntityAPI)empTarget, (CombatEntityAPI)empTarget, DamageType.OTHER, 0.0f, 0.0f, ship.getCollisionRadius(), null, 12.0f, ship.getVentFringeColor(), ship.getVentCoreColor());
                }
            }
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }

    static {
        try {
            ArcEffectOnOverload.loadSettings();
        }
        catch (IOException | JSONException e) {
            Global.getLogger(ArcEffectOnOverload.class).log((Priority)Level.ERROR, (Object)("Failed to load performance settings: " + e.getMessage()));
            enabled = false;
        }
    }
}

