/*
 * Decompiled with CFR 0.152.
 */
package data.missions.gl_sectormark;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public class MissionDefinition
implements MissionDefinitionPlugin {
    public static final Logger log = Global.getLogger(MissionDefinition.class);
    private final List<String> ships = new ArrayList<String>(188);

    public void defineMission(MissionDefinitionAPI api) {
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_stalker_sta");
        this.addShip("dominator_Outdated");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_stalker_sta");
        this.addShip("dominator_Outdated");
        this.addShip("uw_victory_ass");
        this.addShip("onslaught_Standard");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_stalker_sta");
        this.addShip("dominator_Outdated");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_stalker_sta");
        this.addShip("dominator_Outdated");
        this.addShip("uw_victory_ass");
        this.addShip("onslaught_Standard");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_stalker_sta");
        this.addShip("dominator_Outdated");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_stalker_sta");
        this.addShip("dominator_Outdated");
        this.addShip("uw_victory_ass");
        this.addShip("onslaught_Standard");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_stalker_sta");
        this.addShip("dominator_Outdated");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_tiger_str");
        this.addShip("wolf_Assault");
        this.addShip("uw_boar_eli");
        this.addShip("sunder_Assault");
        this.addShip("uw_stalker_sta");
        this.addShip("dominator_Outdated");
        this.addShip("uw_victory_ass");
        this.addShip("onslaught_Standard");
        api.initFleet(FleetSide.PLAYER, "Green", FleetGoal.ATTACK, true, 20);
        api.initFleet(FleetSide.ENEMY, "Red", FleetGoal.ATTACK, true, 20);
        api.setFleetTagline(FleetSide.PLAYER, "Green fleet");
        api.setFleetTagline(FleetSide.ENEMY, "Red fleet");
        api.addBriefingItem("Use this mission for official benchmarks!");
        api.addBriefingItem("This mission automatically enables dev mode");
        this.generateFleet(FleetSide.PLAYER, this.ships, api);
        this.generateFleet(FleetSide.ENEMY, this.ships, api);
        float width = 4000.0f;
        float height = 4000.0f;
        api.initMap(-width / 2.0f, width / 2.0f, -height / 2.0f, height / 2.0f);
        float minX = -width / 2.0f;
        float minY = -height / 2.0f;
        api.addNebula(minX + width * 0.25f, minY + height * 0.25f, 150.0f);
        api.addNebula(minX + width * 0.75f, minY + height * 0.25f, 150.0f);
        api.addNebula(minX + width * 0.75f, minY + height * 0.75f, 150.0f);
        api.addNebula(minX + width * 0.25f, minY + height * 0.75f, 150.0f);
        api.addNebula(minX + width * 0.5f, minY + height * 0.5f, 150.0f);
        api.addAsteroidField(minX + width * 0.5f, minY + height * 0.5f, 45.0f, 500.0f + height / 2.0f, 50.0f, 100.0f, 50);
        api.addObjective(minX + width * 0.25f, minY + height * 0.25f, "comm_relay");
        api.addObjective(minX + width * 0.75f, minY + height * 0.25f, "comm_relay");
        api.addObjective(minX + width * 0.75f, minY + height * 0.75f, "comm_relay");
        api.addObjective(minX + width * 0.25f, minY + height * 0.75f, "comm_relay");
        api.addObjective(minX + width * 0.5f, minY + height * 0.5f, "comm_relay");
        api.addPlugin((EveryFrameCombatPlugin)new Plugin());
    }

    private void addShip(String variant) {
        this.ships.add(variant);
    }

    private void generateFleet(FleetSide side, List<String> ships, MissionDefinitionAPI api) {
        for (String ship : ships) {
            try {
                api.addToFleet(side, ship, FleetMemberType.SHIP, false);
            }
            catch (Exception exception) {}
        }
    }

    private static final class Plugin
    extends BaseEveryFrameCombatPlugin {
        private double advanced = 0.0;
        private double advancedShort = 0.0;
        private float clearanceEnemy = 0.0f;
        private float clearancePlayer = 0.0f;
        private boolean clearanceRightEnemy = true;
        private boolean clearanceRightPlayer = false;
        private boolean ended;
        private long epoch;
        private long epochInfo;
        private long epochMicro;
        private long epochShort;
        private final List<Double> frameTimes = new LinkedList<Double>();
        private int frames = 0;
        private int framesShort = 0;
        private float height = 16000.0f;
        private int maxDP = 0;
        private double memsGB = 0.0;
        private double minimums = 0.0;
        private long score;
        private double variances = 0.0;
        private float width = 8000.0f;

        private Plugin() {
        }

        public void advance(float amount, List<InputEventAPI> events) {
            ShipAPI ship;
            FleetMemberAPI member;
            List ships = Global.getCombatEngine().getShips();
            int playerDP = 0;
            int enemyDP = 0;
            for (ShipAPI ship2 : ships) {
                DeployedFleetMemberAPI deployed;
                if (ship2.isFighter()) continue;
                if (ship2.getLocation().x <= -20000.0f || ship2.getLocation().x >= 20000.0f || ship2.getLocation().y <= -40000.0f || ship2.getLocation().y >= 40000.0f) {
                    Global.getCombatEngine().applyDamage((CombatEntityAPI)ship2, ship2.getLocation(), 10000.0f, DamageType.OTHER, 0.0f, true, false, (Object)ship2);
                }
                if (!ship2.isAlive()) continue;
                if (ship2.getOwner() == 0) {
                    deployed = Global.getCombatEngine().getFleetManager(0).getDeployedFleetMemberEvenIfDisabled(ship2);
                    if (deployed == null) continue;
                    playerDP = (int)((float)playerDP + deployed.getMember().getDeploymentCostSupplies());
                    continue;
                }
                if (ship2.getOwner() != 1 || (deployed = Global.getCombatEngine().getFleetManager(1).getDeployedFleetMemberEvenIfDisabled(ship2)) == null) continue;
                enemyDP = (int)((float)enemyDP + deployed.getMember().getDeploymentCostSupplies());
            }
            int playerTotalDP = playerDP;
            int enemyTotalDP = enemyDP;
            for (FleetMemberAPI member2 : Global.getCombatEngine().getFleetManager(0).getReservesCopy()) {
                playerTotalDP = (int)((float)playerTotalDP + member2.getDeploymentCostSupplies());
            }
            for (FleetMemberAPI member2 : Global.getCombatEngine().getFleetManager(1).getReservesCopy()) {
                enemyTotalDP = (int)((float)enemyTotalDP + member2.getDeploymentCostSupplies());
            }
            this.maxDP = Math.max(this.maxDP, Math.max(playerTotalDP, enemyTotalDP));
            while (playerDP < Global.getSettings().getBattleSize() / 2 && !Global.getCombatEngine().getFleetManager(0).getReservesCopy().isEmpty()) {
                member = (FleetMemberAPI)Global.getCombatEngine().getFleetManager(0).getReservesCopy().get(0);
                playerDP = (int)((float)playerDP + member.getDeploymentCostSupplies());
                log.info((Object)String.format("Spawning %s", member.getSpecId()));
                ship = Global.getCombatEngine().getFleetManager(0).spawnFleetMember(member, new Vector2f(this.clearancePlayer, -3000.0f), 90.0f, 1.0f);
                Global.getCombatEngine().getFleetManager(0).removeFromReserves(member);
                if (this.clearanceRightPlayer) {
                    this.clearancePlayer += ship.getCollisionRadius() * 3.0f;
                    if (!(this.clearancePlayer >= 2000.0f)) continue;
                    this.clearancePlayer -= ship.getCollisionRadius() * 5.0f;
                    this.clearanceRightPlayer = false;
                    continue;
                }
                this.clearancePlayer -= ship.getCollisionRadius() * 3.0f;
                if (!(this.clearancePlayer <= -2000.0f)) continue;
                this.clearancePlayer += ship.getCollisionRadius() * 5.0f;
                this.clearanceRightPlayer = true;
            }
            while (enemyDP < Global.getSettings().getBattleSize() / 2 && !Global.getCombatEngine().getFleetManager(1).getReservesCopy().isEmpty()) {
                member = (FleetMemberAPI)Global.getCombatEngine().getFleetManager(1).getReservesCopy().get(Global.getCombatEngine().getFleetManager(1).getReservesCopy().size() - 1);
                enemyDP = (int)((float)enemyDP + member.getDeploymentCostSupplies());
                log.info((Object)String.format("Spawning %s", member.getSpecId()));
                ship = Global.getCombatEngine().getFleetManager(1).spawnFleetMember(member, new Vector2f(this.clearanceEnemy, 3000.0f), 270.0f, 1.0f);
                Global.getCombatEngine().getFleetManager(1).removeFromReserves(member);
                if (this.clearanceRightEnemy) {
                    this.clearanceEnemy += ship.getCollisionRadius() * 3.0f;
                    if (!(this.clearanceEnemy >= 2000.0f)) continue;
                    this.clearanceEnemy -= ship.getCollisionRadius() * 5.0f;
                    this.clearanceRightEnemy = false;
                    continue;
                }
                this.clearanceEnemy -= ship.getCollisionRadius() * 3.0f;
                if (!(this.clearanceEnemy <= -2000.0f)) continue;
                this.clearanceEnemy += ship.getCollisionRadius() * 5.0f;
                this.clearanceRightEnemy = true;
            }
            if (Global.getCombatEngine().getFleetManager(FleetSide.ENEMY).getTaskManager(false).isInFullRetreat() || Global.getCombatEngine().getFleetManager(FleetSide.PLAYER).getTaskManager(false).isInFullRetreat() || Global.getCombatEngine().getFleetManager(0).getReservesCopy().isEmpty() || Global.getCombatEngine().getFleetManager(1).getReservesCopy().isEmpty()) {
                if (!this.ended) {
                    this.ended = true;
                    double intervalAvg = (double)(System.currentTimeMillis() - this.epoch) / 1000.0;
                    double fpsAvg = (double)this.frames / intervalAvg;
                    double minimumFPS = this.minimums / (intervalAvg / 10.0);
                    double variancesAvg = this.variances / (intervalAvg / 10.0);
                    double gameSpeed = this.advanced / intervalAvg;
                    double gameSpeedFactor = 1.0 + Math.min(minimumFPS / 30.0, 1.0);
                    double stabilityFactor = (minimumFPS / fpsAvg + (1.0 - variancesAvg / (1000.0 / fpsAvg)) + gameSpeed * gameSpeedFactor) / (2.0 + gameSpeedFactor);
                    this.score = Math.round(fpsAvg * Math.sqrt(Math.pow(2.0, stabilityFactor) / 2.0) * 100.0);
                    log.info((Object)String.format("********************************", new Object[0]));
                    log.info((Object)String.format("Benchmark Results (%.1f minute run):", (double)(System.currentTimeMillis() - this.epoch) / 60000.0));
                    log.info((Object)String.format("  Average FPS: %.1f", fpsAvg));
                    log.info((Object)String.format("  Minimum FPS: %.1f", minimumFPS));
                    log.info((Object)String.format("  Average Frame Variance: %.2fms", variancesAvg));
                    log.info((Object)String.format("  Perceived Game Speed: %d%%", Math.round(gameSpeed * 100.0)));
                    log.info((Object)String.format("  SectorMarks: %d", this.score));
                    log.info((Object)String.format("********************************", new Object[0]));
                    Global.getSoundPlayer().playUISound("cr_playership_critical", 1.0f, 2.0f);
                }
                Global.getCombatEngine().addFloatingText(new Vector2f(0.0f, 0.0f), String.format("SectorMarks: %d", this.score), 200.0f, Color.yellow, null, 1.0f, 0.0f);
                return;
            }
            if (Global.getCombatEngine().isPaused()) {
                this.epoch += System.currentTimeMillis() - this.epochMicro;
                this.epochShort += System.currentTimeMillis() - this.epochMicro;
                this.epochInfo += System.currentTimeMillis() - this.epochMicro;
                this.epochMicro = System.currentTimeMillis();
                return;
            }
            double frameTime = (double)(System.currentTimeMillis() - this.epochMicro) / 1000.0;
            this.advanced += (double)amount;
            this.advancedShort += (double)amount;
            this.frameTimes.add(frameTime);
            this.epochMicro = System.currentTimeMillis();
            ++this.frames;
            ++this.framesShort;
            if (System.currentTimeMillis() - this.epochShort >= 1000L) {
                double interval = (double)(System.currentTimeMillis() - this.epochShort) / 1000.0;
                double fps = (double)this.framesShort / interval;
                double progress = 1.0 - (double)Math.min(playerTotalDP - 200, enemyTotalDP - 200) / (double)(this.maxDP - Math.max(200, 200));
                double intervalAvg = (double)(System.currentTimeMillis() - this.epoch) / 1000.0;
                double fpsAvg = (double)this.frames / intervalAvg;
                double usedMemGB = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1.073741824E9;
                this.memsGB += usedMemGB;
                log.info((Object)String.format("Benchmark [%s] - %.1f FPS - %.2fGB Memory Used", new SimpleDateFormat("HH.mm.ss").format(new Date()), fps, usedMemGB));
                Global.getCombatEngine().addFloatingText(new Vector2f(0.0f, 87.5f), String.format("Progress: %d%%", (int)(progress * 100.0)), 75.0f, Color.yellow, null, 1.0f, 0.0f);
                Global.getCombatEngine().addFloatingText(new Vector2f(0.0f, 0.0f), String.format("Average FPS: %.1f", fpsAvg), 100.0f, Color.yellow, null, 1.0f, 0.0f);
                if (progress > 0.0 && System.currentTimeMillis() - this.epoch >= 120000L) {
                    double speed = progress / ((double)(System.currentTimeMillis() - this.epoch) / 60000.0);
                    double eta = (1.0 - progress) / speed;
                    Global.getCombatEngine().addFloatingText(new Vector2f(0.0f, -75.0f), String.format("Time Remaining: %d minutes", Math.round(eta)), 50.0f, Color.yellow, null, 1.0f, 0.0f);
                }
                this.epochShort = System.currentTimeMillis();
                this.framesShort = 0;
                for (ShipAPI ship3 : ships) {
                    if (ship3.isAlive()) continue;
                    Global.getCombatEngine().applyDamage((CombatEntityAPI)ship3, ship3.getLocation(), 0.025f * ship3.getMaxHitpoints(), DamageType.HIGH_EXPLOSIVE, 0.0f, true, false, (Object)ship3);
                }
            }
            if (System.currentTimeMillis() - this.epochInfo >= 10000L) {
                double mean = 0.0;
                for (double frame : this.frameTimes) {
                    mean += frame;
                }
                mean /= (double)this.frameTimes.size();
                double variance = 0.0;
                for (double frame : this.frameTimes) {
                    variance += (frame - mean) * (frame - mean);
                }
                double stdevMs = Math.sqrt(variance /= (double)this.frameTimes.size()) * 1000.0;
                this.variances += stdevMs;
                double min = Double.MAX_VALUE;
                for (double frame : this.frameTimes) {
                    min = Math.min(min, 1.0 / frame);
                }
                this.minimums += min;
                double intervalAvg = (double)(System.currentTimeMillis() - this.epoch) / 1000.0;
                double fpsAvg = (double)this.frames / intervalAvg;
                double minimumFPS = this.minimums / (intervalAvg / 10.0);
                double variancesAvg = this.variances / (intervalAvg / 10.0);
                double progress = 1.0 - (double)Math.min(playerTotalDP - 200, enemyTotalDP - 200) / (double)(this.maxDP - Math.max(200, 200));
                double memoryAvg = this.memsGB / intervalAvg;
                double intervalInfo = (double)(System.currentTimeMillis() - this.epochInfo) / 1000.0;
                double gameSpeed = this.advancedShort / intervalInfo;
                log.info((Object)String.format("Benchmark Stats [%s] (Progress: %d%%):", new SimpleDateFormat("HH:mm:ss").format(new Date()), (int)(progress * 100.0)));
                log.info((Object)String.format("  Average FPS: %.1f", fpsAvg));
                log.info((Object)String.format("  Minimum FPS: %.1f", minimumFPS));
                log.info((Object)String.format("  Frame Variance: %.2fms", stdevMs));
                log.info((Object)String.format("  Average Frame Variance: %.2fms", variancesAvg));
                log.info((Object)String.format("  Average Memory Used: %.2fGB", memoryAvg));
                log.info((Object)String.format("  Game Speed: %.1f%%", gameSpeed * 100.0));
                this.frameTimes.clear();
                this.advancedShort = 0.0;
                this.epochInfo = System.currentTimeMillis();
            }
        }

        public void init(CombatEngineAPI engine) {
            log.setLevel(Level.INFO);
            engine.getContext().setStandoffRange(8000.0f);
            engine.getContext().setInitialDeploymentBurnDuration(0.5f);
            engine.getContext().setNormalDeploymentBurnDuration(0.5f);
            float ratio = Global.getSettings().getScreenWidth() / Global.getSettings().getScreenHeight();
            if (ratio < 1.0f) {
                this.width *= ratio;
            } else {
                this.height /= ratio;
            }
            Global.getSettings().setDevMode(true);
            engine.getViewport().setExternalControl(true);
            engine.getViewport().set(-this.width / 3.0f, -this.height / 6.0f, this.width / 1.5f, this.height / 3.0f);
            this.epoch = System.currentTimeMillis();
            this.epochShort = System.currentTimeMillis();
            this.epochMicro = System.currentTimeMillis();
            this.epochInfo = System.currentTimeMillis();
        }
    }
}

