/*
 * Decompiled with CFR 0.152.
 */
package data.missions.gl_performance;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import java.util.LinkedList;
import java.util.List;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class MissionDefinition
implements MissionDefinitionPlugin {
    private static final Vector2f ZERO = new Vector2f();

    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "", FleetGoal.ATTACK, false, 0);
        api.initFleet(FleetSide.ENEMY, "", FleetGoal.ATTACK, false, 0);
        List ids = Global.getSector().getAllEmptyVariantIds();
        api.addToFleet(FleetSide.PLAYER, (String)ids.get((int)((double)ids.size() * Math.random())), FleetMemberType.SHIP, true);
        api.addToFleet(FleetSide.ENEMY, (String)ids.get((int)((double)ids.size() * Math.random())), FleetMemberType.SHIP, true);
        api.setFleetTagline(FleetSide.PLAYER, "You");
        api.setFleetTagline(FleetSide.ENEMY, "Them");
        api.addBriefingItem("This mission automatically enables dev mode");
        float width = 12000.0f;
        float height = 12000.0f;
        api.initMap(-width / 2.0f, width / 2.0f, -height / 2.0f, height / 2.0f);
        api.addPlugin((EveryFrameCombatPlugin)new Plugin());
    }

    private static final class Plugin
    extends BaseEveryFrameCombatPlugin {
        private static final List<DistortionAPI> distortionList = new LinkedList<DistortionAPI>();
        private static final List<LightAPI> lightList = new LinkedList<LightAPI>();

        private Plugin() {
        }

        public void advance(float amount, List<InputEventAPI> events) {
            Global.getCombatEngine().setDoNotEndCombat(true);
            ShipAPI player = Global.getCombatEngine().getPlayerShip();
            if (player == null) {
                return;
            }
            for (InputEventAPI event : events) {
                if (event.isConsumed()) continue;
                if (event.isKeyDownEvent() && event.getEventValue() == 79) {
                    Vector2f loc = player.getMouseTarget();
                    StandardLight light = new StandardLight(loc, ZERO, ZERO, null);
                    light.setSize((float)Math.random() * 1000.0f + 100.0f);
                    light.setIntensity((float)Math.random() * 1.9f + 0.1f);
                    light.setHeight((float)Math.random() * 400.0f + 100.0f);
                    light.setColor((float)Math.random(), (float)Math.random(), (float)Math.random());
                    light.makePermanent();
                    light.fadeIn(0.5f);
                    lightList.add(light);
                    LightShader.addLight(light);
                    event.consume();
                    break;
                }
                if (event.isKeyDownEvent() && event.getEventValue() == 80) {
                    Vector2f loc = player.getMouseTarget();
                    Vector2f loc2 = player.getLocation();
                    StandardLight light = new StandardLight(loc, loc2, ZERO, ZERO, null);
                    light.setSize((float)Math.random() * 1000.0f + 100.0f);
                    light.setIntensity((float)Math.random() * 1.9f + 0.1f);
                    light.setHeight((float)Math.random() * 400.0f + 100.0f);
                    light.setColor((float)Math.random(), (float)Math.random(), (float)Math.random());
                    light.makePermanent();
                    light.fadeIn(0.5f);
                    lightList.add(light);
                    LightShader.addLight(light);
                    event.consume();
                    break;
                }
                if (event.isKeyDownEvent() && event.getEventValue() == 81) {
                    Vector2f loc = player.getMouseTarget();
                    float width = (float)Math.random() * 340.0f + 10.0f;
                    Vector2f dir = Vector2f.sub((Vector2f)player.getLocation(), (Vector2f)loc, null);
                    float angle = (float)Math.toDegrees(Math.atan2(dir.y, dir.x));
                    StandardLight light = new StandardLight(loc, ZERO, angle + width * 0.5f, angle - width * 0.5f);
                    light.setSize((float)Math.random() * 1000.0f + 100.0f);
                    light.setIntensity((float)Math.random() * 1.9f + 0.1f);
                    light.setHeight((float)Math.random() * 400.0f + 100.0f);
                    light.setColor((float)Math.random(), (float)Math.random(), (float)Math.random());
                    light.makePermanent();
                    light.fadeIn(0.5f);
                    lightList.add(light);
                    LightShader.addLight(light);
                    event.consume();
                    break;
                }
                if (event.isKeyDownEvent() && event.getEventValue() == 75) {
                    Vector3f dir = new Vector3f((float)Math.random(), (float)Math.random(), -1.0f);
                    StandardLight light = new StandardLight(dir);
                    light.setIntensity((float)Math.random() * 0.9f + 0.1f);
                    light.setSpecularIntensity((float)Math.random() * 2.9f + 0.1f);
                    light.setColor((float)Math.random(), (float)Math.random(), (float)Math.random());
                    light.makePermanent();
                    light.fadeIn(0.5f);
                    lightList.add(light);
                    LightShader.addLight(light);
                    event.consume();
                    break;
                }
                if (event.isKeyDownEvent() && event.getEventValue() == 76) {
                    Vector2f loc = player.getMouseTarget();
                    RippleDistortion distortion = new RippleDistortion(loc, ZERO);
                    distortion.setSize((float)Math.random() * 450.0f + 50.0f);
                    distortion.setIntensity((float)Math.random() * 450.0f + 50.0f);
                    distortion.flip(Math.random() < 0.5);
                    distortion.setCurrentFrame((float)Math.random() * 59.0f);
                    if (Math.random() < 0.5) {
                        float width = (float)Math.random() * 340.0f + 10.0f;
                        Vector2f dir = Vector2f.sub((Vector2f)player.getLocation(), (Vector2f)loc, null);
                        float angle = (float)Math.toDegrees(Math.atan2(dir.y, dir.x));
                        distortion.setArc(angle - width * 0.5f, angle + width * 0.5f);
                        distortion.setArcAttenuationWidth((float)Math.random() * 180.0f);
                    }
                    distortion.fadeInIntensity(0.5f);
                    distortionList.add(distortion);
                    DistortionShader.addDistortion(distortion);
                    event.consume();
                    break;
                }
                if (!event.isKeyDownEvent() || event.getEventValue() != 77) continue;
                for (DistortionAPI distortion : distortionList) {
                    DistortionShader.removeDistortion(distortion);
                }
                for (LightAPI light : lightList) {
                    LightShader.removeLight(light);
                }
                event.consume();
                break;
            }
        }

        public void init(CombatEngineAPI engine) {
            Global.getSettings().setDevMode(true);
        }
    }
}

