package data.missions.scripts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class FleetTester_utils {
    
    private static Logger log = Global.getLogger(FleetTester_utils.class); 
    
    ////////////////////////////////////
    //                                //
    //         FLEET CREATION         //
    //                                //
    ////////////////////////////////////
    
    public static List<FleetMemberAPI> addShip(MissionDefinitionAPI api, FleetSide side, String PATH){
        List<FleetMemberAPI>members=new ArrayList<>();
        
        int sideNb=0;
        if(side==FleetSide.ENEMY){
            sideNb=1;
        }
                
        String theFleet=PATH+"player"+sideNb+"_fleet.csv";
        
        //read playerX_fleet.csv
        try {
            JSONArray fleet = Global.getSettings().getMergedSpreadsheetDataForMod("rowNumber", theFleet, "FleetTester");
            for(int i = 0; i < fleet.length(); i++) {
                JSONObject row = fleet.getJSONObject(i);
                String variant = row.getString("variant");
                String personality = row.getString("personality");
                boolean flagship = row.getBoolean("flagship");
                FleetMemberAPI member = api.addToFleet(side, variant, FleetMemberType.SHIP, flagship);
                member.updateStats();
                member.getCaptain().setPersonality(personality);  
                members.add(member);
            }
        } catch (IOException | JSONException ex) {
            log.error("unable to read player"+sideNb+"_fleet.csv");
        }
        return members;
    }
    
    ////////////////////////////////////
    //                                //
    //   NEW FLEET COST CALCULATION   //
    //                                //
    //////////////////////////////////// 
    
    /**
     * 
     * @param engine
     * Combat Engine 
     * 
     * @param side 
     * fleet side
     * 
     * @param FLEET 
     * List of FleetMember 
     * 
     * @return 
     */
    
    public static Vector3f FleetCost(
        CombatEngineAPI engine,
        FleetSide side,
        List<FleetMemberAPI> FLEET){
        

        log.info(" ");
        log.info(" ");
        log.info("____________________________");
        log.info(" ");
        log.info(side.toString()+"'s budget breakdown");
        log.info("____________________________");       
        log.info(" ");
        
        float totalValue=0;
        float maintenance=0;
        float fleetPoints=0;
        List <String> HULLMOD_LIST=new ArrayList<>();

        log.info(" ");
        log.info("SHIPS:");
        log.info(" ");


        for(FleetMemberAPI s : FLEET){

            //skip fighters                    
            if(s.isFighterWing()){         
                continue;
            }            

            log.info(" ");
            log.info(s.getVariant().getHullVariantId()+"'s cost:");


            //maintenance cost
            float deploy=s.getStats().getSuppliesToRecover().getModifiedValue();
            log.info(" ");
            log.info("      "+s.getVariant().getHullVariantId()+"'s maintenance:");
            

            //regular hull cost
            float hull=0;
            float weapons=0;    
            float wings=0;        
            
            
            //HULL price
            hull=s.getHullSpec().getBaseValue();
            log.info("      "+s.getVariant().getHullVariantId()+"'s base hull price: "+(int)hull);

            
            //WEAPONS prices (except built-in ones)
            if(!s.getVariant().getNonBuiltInWeaponSlots().isEmpty()){
                for(String slot : s.getVariant().getNonBuiltInWeaponSlots()){
                    weapons+=s.getVariant().getWeaponSpec(slot).getBaseValue();
                }
            }
            log.info("      "+s.getVariant().getHullVariantId()+"'s weapons price: "+(int)weapons);
                
            
            //WINGS prices (except built-in ones)                  
            List<String>BIwings=s.getHullSpec().getBuiltInWings();
            if(s.getStats().getNumFighterBays().getModifiedValue()>0){
                for(int i=0; i<s.getStats().getNumFighterBays().getModifiedValue(); i++){
                    //skip empty slots
                    if(s.getVariant().getWing(i)!=null){
                        //skip built-in
                        if(!BIwings.isEmpty() && BIwings.contains(s.getVariant().getWingId(i))){
                            log.info("      "+"Skipping built-in"+s.getVariant().getWing(i).getId());
                        } else {
                            //add the cost
                            wings+=s.getVariant().getWing(i).getBaseValue();
                        }
                    }
                }
                log.info("      "+s.getVariant().getHullVariantId()+"'s wings price: "+(int)wings);
            }

            //HULLMODS
            log.info(" ");                
            for (String h : s.getVariant().getNonBuiltInHullmods()){
                if(!HULLMOD_LIST.contains(h)){
                    log.info("      "+Global.getSettings().getHullModSpec(h).getDisplayName()+" added to buying list.");
                    //add the hullmod with a multiplier
                    HULLMOD_LIST.add(h);
                } else {
                    log.info("      "+Global.getSettings().getHullModSpec(h).getDisplayName()+" already bought.");
                }
            }
            

            //COMPUTE SHIP COST   
            
            float shipValue=0;
            
            //NEW REGULAR SHIP  
            log.info(" ");
            log.info("      "+s.getVariant().getHullVariantId()+" total cost: ");
            log.info("      "+" hull price: "+hull);
            log.info("      "+" + weapons: "+weapons);
            log.info("      "+" + wings: "+wings);
            shipValue+=hull;
            shipValue+=weapons;
            shipValue+=wings;
            log.info("      "+" = "+shipValue);
            log.info(" ");
            log.info("      "+" Deployment cost = "+deploy);
            log.info(" ");
            log.info("      "+" Fleet Points used = "+s.getFleetPointCost());
            log.info(" ");

            totalValue+=shipValue;
            maintenance+=deploy;
            fleetPoints+=s.getFleetPointCost();
            
            log.info("      "+"______________");     
        }
        
        //COMPUTE HULLMODS

        log.info(" ");
        log.info("HULLMODS:");
        log.info(" ");

        float hullmodsValue=0;
        for(String h : HULLMOD_LIST){
            float price = Global.getSettings().getHullModSpec(h).getBaseValue();
            log.info("      "+Global.getSettings().getHullModSpec(h).getDisplayName()+" hullmod bought this round for " + (int)price);
            hullmodsValue+=price;
        }
        
        log.info(" ");
        log.info("____________________________");  
        log.info(" ");
        log.info("TOTAL HULLMODS EXPENSES: "+(int)hullmodsValue);
        log.info(" ");
        log.info("TOTAL SHIPS VALUE: "+(int)totalValue);
        log.info(" ");
        log.info("____________________________");   

        totalValue+=hullmodsValue;
        
        log.info(" "); 
        log.info("____________________________");    
        log.info(" ");   
        log.info("TOTAL FLEET VALUE: "+(int)totalValue);
        log.info(" ");   
        log.info("TOTAL DEPLOYMENT COST: "+(int)maintenance);
        log.info(" ");     
        log.info("____________________________");       

        return new Vector3f(totalValue,maintenance,fleetPoints);
    }

    
    ////////////////////////////////////
    //                                //
    //     FORCED FLEET SPAWNING      //
    //                                //
    //////////////////////////////////// 
    
     /**
     * @param engine
     * Combat Engine.
     * 
     * @param side
     * FleetSide to deploy.
     * 
     * @param mapX
     * Map width.
     * 
     * @param mapY
     * Map height.
     * 
     * @param suppressMessage
     * Suppress UI spawning message on the side.
     */
    
    public static void ForcedSpawn(CombatEngineAPI engine, FleetSide side, float mapX, float mapY, boolean suppressMessage){
        
        if(suppressMessage){
            engine.getFleetManager(side).setSuppressDeploymentMessages(true);
        }

        if(engine.getFleetManager(side).getReservesCopy().size()>0){
            
            //start by the middle
            float angle=-90, spawnX=0, spawnY=mapY/2;
            
            //reverse for player side
            if(side==FleetSide.PLAYER){
                spawnY*=-1;
                angle*=-1;
            }

            for(FleetMemberAPI member : engine.getFleetManager(side).getReservesCopy()){
                //ignore fighter wings
                if(member.isFighterWing()){
                    continue;
                }

                //spawn location
                Vector2f loc = new Vector2f(spawnX,spawnY);

                //add ship
                engine.getFleetManager(side).spawnFleetMember(member, loc, angle, 3);
                log.info("Spawning "+side.name()+"'s "+member.getHullId()+ " at "+(int)spawnX+"x"+(int)spawnY);

                //set new location
                if(spawnX>0){
                    //switch to the left
                    spawnX*=-1;
                } else {
                    //switch back to the right
                    spawnX*=-1;
                    //add offset
                    spawnX+=500;
                }
                if(spawnX>=mapX/4){
                    //if the line of ships is too wide, get back to the center and a row behind
                    spawnX=0;
                    
                    //reverse for player side
                    if(side==FleetSide.PLAYER){
                        spawnY-=600;
                    } else {                        
                        spawnY+=600;
                    }
                }
            }                                     
        }        
        
        if(suppressMessage){
            engine.getFleetManager(side).setSuppressDeploymentMessages(false);
        }
    }
    
}