package data.missions.FleetTester;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.missions.scripts.FleetTester_utils;
import data.scripts.plugins.FleetTester_freeCamPlugin;
import java.util.List;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector3f;

public class MissionDefinition implements MissionDefinitionPlugin {
        
    public static Logger log = Global.getLogger(MissionDefinition.class);
    
    private static boolean deploy=false;
    
    public static final String PATH = "data/missions/FleetTester/";
    
    private static float mapX, mapY;

    @Override
    public void defineMission(MissionDefinitionAPI api) {
        
        api.initFleet(FleetSide.PLAYER, "TEST", FleetGoal.ATTACK, true, 1);
        api.setFleetTagline(FleetSide.PLAYER, "Test Fleet"); 
        List<FleetMemberAPI>PLAYER_FLEET=FleetTester_utils.addShip(api, FleetSide.PLAYER, PATH);
        
        api.initFleet(FleetSide.ENEMY, "AI", FleetGoal.ATTACK, true, 1);
        api.setFleetTagline(FleetSide.ENEMY, "Enemy Fleet"); 
        List<FleetMemberAPI>ENEMY_FLEET=FleetTester_utils.addShip(api, FleetSide.ENEMY, PATH);
        
        
        Vector3f playerCost = FleetTester_utils.FleetCost(
                Global.getCombatEngine(),
                FleetSide.PLAYER,
                PLAYER_FLEET
        );  
        
        Vector3f enemyCost = FleetTester_utils.FleetCost(
                Global.getCombatEngine(),
                FleetSide.ENEMY,
                ENEMY_FLEET
        ); 
        
        //setup Briefing
        api.addBriefingItem("Test fleet cost : "+playerCost.x+", deployment cost : "+playerCost.y+", fleet points used: "+playerCost.z);
        api.addBriefingItem("  VERSUS");
        api.addBriefingItem("Enemy fleet cost : "+enemyCost.x+", deployment cost : "+enemyCost.y+", fleet points used: "+enemyCost.z);
        
        //setup the terrain
        float WIDTH=10000;
        float HEIGHT=10000;
        api.initMap(-WIDTH/2, WIDTH/2, -HEIGHT/2, HEIGHT/2);
        api.addObjective(0, 0, "comm_relay");
        api.addObjective(-0.25f*WIDTH, -0.25f*HEIGHT, "nav_buoy");
        api.addObjective(0.25f*WIDTH, 0.25f*HEIGHT, "nav_buoy");
        api.addObjective(-0.25f*WIDTH, 0.25f*HEIGHT, "sensor_array");
        api.addObjective(0.25f*WIDTH, -0.25f*HEIGHT, "sensor_array");
        
        //add the price check and anti-retreat plugin
        api.addPlugin(new Plugin());
    }

    public final static class Plugin extends BaseEveryFrameCombatPlugin {        
        
        ////////////////////////////////////
        //                                //
        //      BATTLE INITIALISATION     //
        //                                //
        ////////////////////////////////////        

        @Override
        public void init(CombatEngineAPI engine) {
            
            
            ////////////////////////////////////
            //                                //
            //    CAMERA AND TIME CONTROLS    //
            //                                //
            ////////////////////////////////////
            
            EveryFrameCombatPlugin free_cam = new FleetTester_freeCamPlugin();
            engine.removePlugin(free_cam);
            engine.addPlugin(free_cam);
            
            //add loads of deployment points to preven the AI from holding ships
            Global.getCombatEngine().setMaxFleetPoints(FleetSide.ENEMY, 9999);
            Global.getCombatEngine().setMaxFleetPoints(FleetSide.PLAYER, 9999);
            
            mapX=engine.getMapWidth();
            mapY=engine.getMapHeight();            
            
            deploy=false;
        }

        ////////////////////////////////////
        //                                //
        //         ADVANCE PLUGIN         //
        //                                //
        ////////////////////////////////////     
        
        @Override
        public void advance(float amount, List<InputEventAPI> events) {
            CombatEngineAPI engine = Global.getCombatEngine();   
            
            ////////////////////////////////////
            //                                //
            //          FORCED SPAWN          //
            //                                //
            ////////////////////////////////////  
            
            if(!deploy){
                
                deploy=true;                
                    
                log.info("Map size: "+(int)mapX+"x"+(int)mapY);  
                
                //public static void ForcedSpawn(CombatEngineAPI engine, FleetSide side, float mapX, float mapY, boolean suppressMessage)
//                FleetTester_utils.ForcedSpawn(engine, FleetSide.PLAYER, mapX, mapY, true);                
//                FleetTester_utils.ForcedSpawn(engine, FleetSide.ENEMY, mapX, mapY, true);                
                return;      
            }
            
            if(engine.isPaused()){return;}
            
            ////////////////////////////////////
            //                                //
            //         TICKING CLOCK          //
            //                                //
            ////////////////////////////////////
            engine.maintainStatusForPlayerShip(
                    "clock",
                    null,
                    "Timer",
                    (int)engine.getTotalElapsedTime(false)+" seconds",
                    true
            );
        }
    }
}