/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import data.scripts.util.MagicRender;
import java.awt.Color;
import java.util.List;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class FleetTester_freeCamPlugin
extends BaseEveryFrameCombatPlugin {
    private final String ID = "freeCam";
    private Logger log = Global.getLogger(FleetTester_freeCamPlugin.class);
    private CombatEngineAPI engine;
    private int freeCam = 0;
    private boolean camToggle = false;
    private boolean zoomIn = false;
    private boolean zoomOut = false;
    private boolean message = false;
    private float mapX;
    private float mapY;
    private float screenX;
    private float screenY;
    private float scale = 5.0f;
    private float zoomX = 0.0f;
    private float zoomY = 0.0f;
    private Vector2f target = new Vector2f();

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            this.engine = Global.getCombatEngine();
            this.screenX = Global.getSettings().getScreenWidth();
            this.screenY = Global.getSettings().getScreenHeight();
            this.zoomX = this.screenX;
            this.zoomY = this.screenY;
            this.mapX = this.engine.getMapWidth();
            this.mapY = this.engine.getMapHeight();
            this.freeCam = 0;
        }
        if (Keyboard.isKeyDown((int)42)) {
            if (!this.message) {
                this.message = true;
                this.engine.getCombatUI().addMessage(0, new Object[]{"Engaged x4 speed-up."});
            }
            this.engine.getTimeMult().modifyMult("freeCam", 4.0f);
        } else if (Keyboard.isKeyDown((int)29)) {
            if (!this.message) {
                this.message = true;
                this.engine.getCombatUI().addMessage(0, new Object[]{"Engaged /4 slo-mo."});
            }
            this.engine.getTimeMult().modifyMult("freeCam", 0.25f);
        } else {
            if (this.message) {
                this.message = false;
                this.engine.getCombatUI().addMessage(0, new Object[]{"Resumed normal time flow."});
            }
            this.engine.getTimeMult().unmodify("freeCam");
        }
        if (Keyboard.isKeyDown((int)157)) {
            this.camToggle = true;
        } else if (this.camToggle) {
            this.camToggle = false;
            ++this.freeCam;
            switch (this.freeCam) {
                case 1: {
                    this.log.info((Object)"CURSOR FREECAM MODE");
                    break;
                }
                case 2: {
                    this.log.info((Object)"SCREENSPACE FREECAM MODE");
                    break;
                }
                case 3: {
                    this.freeCam = 1;
                    this.log.info((Object)"CURSOR FREECAM MODE");
                    break;
                }
            }
            this.engine.getViewport().setExternalControl(this.freeCam > 0);
            this.target = new Vector2f();
            this.scale = this.mapY / this.screenY;
            this.zoomX = this.engine.getViewport().getVisibleWidth();
            this.zoomY = this.engine.getViewport().getVisibleHeight();
            this.log.info((Object)("Mouse mult: " + this.scale));
            this.log.info((Object)("Screen size: " + this.screenX + " x " + this.screenY));
            this.log.info((Object)("Battle size " + this.mapX + " x " + this.mapY));
            MagicRender.screenspace((SpriteAPI)Global.getSettings().getSprite("misc", "AI_cam" + this.freeCam), (MagicRender.positioning)MagicRender.positioning.CENTER, (Vector2f)new Vector2f(0.0f, this.screenY / 2.0f - 48.0f), (Vector2f)new Vector2f(), (Vector2f)new Vector2f(96.0f, 48.0f), (Vector2f)new Vector2f(), (float)0.0f, (float)0.0f, (Color)Color.WHITE, (boolean)false, (float)0.1f, (float)1.3f, (float)0.1f);
        }
        if (this.freeCam == 2) {
            for (InputEventAPI i : events) {
                if (i.isRMBDownEvent()) {
                    this.log.info((Object)"Right-click down");
                    this.zoomOut = true;
                }
                if (i.isRMBUpEvent()) {
                    this.log.info((Object)"Right-click up.");
                    this.zoomOut = false;
                }
                if (i.isLMBDownEvent()) {
                    this.log.info((Object)"Left-click down");
                    this.zoomIn = true;
                }
                if (i.isLMBUpEvent()) {
                    this.log.info((Object)"Left-click up.");
                    this.zoomIn = false;
                }
                if (i.isAltDown()) {
                    this.freeCam = 0;
                    this.camToggle = true;
                    this.log.info((Object)"Reset cam.");
                }
                if (!i.isMouseMoveEvent()) continue;
                this.target = new Vector2f((float)i.getX() - this.screenX / 2.0f, (float)i.getY() - this.screenY / 2.0f);
                this.target.scale(this.scale);
            }
            Vector2f move = new Vector2f((ReadableVector2f)this.engine.getViewport().getCenter());
            Vector2f.sub((Vector2f)this.target, (Vector2f)move, (Vector2f)move);
            move.scale(amount * 7.0f);
            Vector2f.add((Vector2f)move, (Vector2f)this.engine.getViewport().getCenter(), (Vector2f)move);
            if (this.zoomIn) {
                this.zoomX -= this.screenX * amount * 3.0f;
                this.zoomX = Math.max(this.screenX / 2.0f, this.zoomX);
                this.zoomY -= this.screenY * amount * 3.0f;
                this.zoomY = Math.max(this.screenY / 2.0f, this.zoomY);
                this.engine.getViewport().set(this.engine.getViewport().getLLX(), this.engine.getViewport().getLLY(), this.zoomX, this.zoomY);
            } else if (this.zoomOut) {
                this.zoomX += this.screenX * amount * 3.0f;
                this.zoomX = Math.min(this.screenX * 10.0f, this.zoomX);
                this.zoomY += this.screenY * amount * 3.0f;
                this.zoomY = Math.min(this.screenY * 10.0f, this.zoomY);
                this.engine.getViewport().set(this.engine.getViewport().getLLX(), this.engine.getViewport().getLLY(), this.zoomX, this.zoomY);
            }
            this.engine.getViewport().setCenter(move);
        } else if (this.freeCam == 1) {
            for (InputEventAPI i : events) {
                if (i.isRMBDownEvent()) {
                    this.log.info((Object)"Right-click down");
                    this.zoomOut = true;
                }
                if (i.isRMBUpEvent()) {
                    this.log.info((Object)"Right-click up.");
                    this.zoomOut = false;
                }
                if (i.isLMBDownEvent()) {
                    this.log.info((Object)"Left-click down");
                    this.zoomIn = true;
                }
                if (i.isLMBUpEvent()) {
                    this.log.info((Object)"Left-click up.");
                    this.zoomIn = false;
                }
                if (i.isAltDown()) {
                    this.freeCam = -1;
                    this.camToggle = true;
                    this.log.info((Object)"Reset cam.");
                }
                if (!i.isMouseMoveEvent()) continue;
                this.target = new Vector2f((float)i.getX() - this.screenX / 2.0f, (float)i.getY() - this.screenY / 2.0f);
                if (!((double)this.target.lengthSquared() > Math.pow(this.screenY / 2.0f, 2.0))) continue;
                this.target = MathUtils.getPointOnCircumference(null, (float)(this.screenY / 2.0f), (float)VectorUtils.getFacing((Vector2f)this.target));
            }
            float smooth = this.target.lengthSquared() / (float)Math.pow(this.screenY / 4.0f, 2.0);
            Vector2f move = new Vector2f((ReadableVector2f)this.target);
            move.scale(amount * smooth);
            Vector2f.add((Vector2f)move, (Vector2f)this.engine.getViewport().getCenter(), (Vector2f)move);
            move = new Vector2f(Math.max(-this.mapX / 2.0f, Math.min(this.mapX / 2.0f, move.x)), Math.max(-this.mapY / 2.0f, Math.min(this.mapY / 2.0f, move.y)));
            if (this.zoomIn) {
                this.zoomX -= this.screenX * amount * 3.0f;
                this.zoomX = Math.max(this.screenX / 2.0f, this.zoomX);
                this.zoomY -= this.screenY * amount * 3.0f;
                this.zoomY = Math.max(this.screenY / 2.0f, this.zoomY);
                this.engine.getViewport().set(this.engine.getViewport().getLLX(), this.engine.getViewport().getLLY(), this.zoomX, this.zoomY);
            } else if (this.zoomOut) {
                this.zoomX += this.screenX * amount * 3.0f;
                this.zoomX = Math.min(this.screenX * 10.0f, this.zoomX);
                this.zoomY += this.screenY * amount * 3.0f;
                this.zoomY = Math.min(this.screenY * 10.0f, this.zoomY);
                this.engine.getViewport().set(this.engine.getViewport().getLLX(), this.engine.getViewport().getLLY(), this.zoomX, this.zoomY);
            }
            this.engine.getViewport().setCenter(move);
        }
    }
}

