/*
 * Decompiled with CFR 0.152.
 */
package data.missions.scripts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class FleetTester_utils {
    private static Logger log = Global.getLogger(FleetTester_utils.class);

    public static List<FleetMemberAPI> addShip(MissionDefinitionAPI api, FleetSide side, String PATH) {
        ArrayList<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>();
        int sideNb = 0;
        if (side == FleetSide.ENEMY) {
            sideNb = 1;
        }
        String theFleet = PATH + "player" + sideNb + "_fleet.csv";
        try {
            JSONArray fleet = Global.getSettings().getMergedSpreadsheetDataForMod("rowNumber", theFleet, "FleetTester");
            for (int i = 0; i < fleet.length(); ++i) {
                JSONObject row = fleet.getJSONObject(i);
                String variant = row.getString("variant");
                String personality = row.getString("personality");
                boolean flagship = row.getBoolean("flagship");
                FleetMemberAPI member = api.addToFleet(side, variant, FleetMemberType.SHIP, flagship);
                member.updateStats();
                member.getCaptain().setPersonality(personality);
                members.add(member);
            }
        }
        catch (IOException | JSONException ex) {
            log.error((Object)("unable to read player" + sideNb + "_fleet.csv"));
        }
        return members;
    }

    public static Vector3f FleetCost(CombatEngineAPI engine, FleetSide side, List<FleetMemberAPI> FLEET) {
        log.info((Object)" ");
        log.info((Object)" ");
        log.info((Object)"____________________________");
        log.info((Object)" ");
        log.info((Object)(side.toString() + "'s budget breakdown"));
        log.info((Object)"____________________________");
        log.info((Object)" ");
        float totalValue = 0.0f;
        float maintenance = 0.0f;
        float fleetPoints = 0.0f;
        ArrayList<String> HULLMOD_LIST = new ArrayList<String>();
        log.info((Object)" ");
        log.info((Object)"SHIPS:");
        log.info((Object)" ");
        for (FleetMemberAPI s : FLEET) {
            if (s.isFighterWing()) continue;
            log.info((Object)" ");
            log.info((Object)(s.getVariant().getHullVariantId() + "'s cost:"));
            float deploy = s.getStats().getSuppliesToRecover().getModifiedValue();
            log.info((Object)" ");
            log.info((Object)("      " + s.getVariant().getHullVariantId() + "'s maintenance:"));
            float hull = 0.0f;
            float weapons = 0.0f;
            float wings = 0.0f;
            hull = s.getHullSpec().getBaseValue();
            log.info((Object)("      " + s.getVariant().getHullVariantId() + "'s base hull price: " + (int)hull));
            if (!s.getVariant().getNonBuiltInWeaponSlots().isEmpty()) {
                for (String slot : s.getVariant().getNonBuiltInWeaponSlots()) {
                    weapons += s.getVariant().getWeaponSpec(slot).getBaseValue();
                }
            }
            log.info((Object)("      " + s.getVariant().getHullVariantId() + "'s weapons price: " + (int)weapons));
            List BIwings = s.getHullSpec().getBuiltInWings();
            if (s.getStats().getNumFighterBays().getModifiedValue() > 0.0f) {
                int i = 0;
                while ((float)i < s.getStats().getNumFighterBays().getModifiedValue()) {
                    if (s.getVariant().getWing(i) != null) {
                        if (!BIwings.isEmpty() && BIwings.contains(s.getVariant().getWingId(i))) {
                            log.info((Object)("      Skipping built-in" + s.getVariant().getWing(i).getId()));
                        } else {
                            wings += s.getVariant().getWing(i).getBaseValue();
                        }
                    }
                    ++i;
                }
                log.info((Object)("      " + s.getVariant().getHullVariantId() + "'s wings price: " + (int)wings));
            }
            log.info((Object)" ");
            for (String h : s.getVariant().getNonBuiltInHullmods()) {
                if (!HULLMOD_LIST.contains(h)) {
                    log.info((Object)("      " + Global.getSettings().getHullModSpec(h).getDisplayName() + " added to buying list."));
                    HULLMOD_LIST.add(h);
                    continue;
                }
                log.info((Object)("      " + Global.getSettings().getHullModSpec(h).getDisplayName() + " already bought."));
            }
            float shipValue = 0.0f;
            log.info((Object)" ");
            log.info((Object)("      " + s.getVariant().getHullVariantId() + " total cost: "));
            log.info((Object)("       hull price: " + hull));
            log.info((Object)("       + weapons: " + weapons));
            log.info((Object)("       + wings: " + wings));
            shipValue += hull;
            shipValue += weapons;
            log.info((Object)("       = " + (shipValue += wings)));
            log.info((Object)" ");
            log.info((Object)("       Deployment cost = " + deploy));
            log.info((Object)" ");
            log.info((Object)("       Fleet Points used = " + s.getFleetPointCost()));
            log.info((Object)" ");
            totalValue += shipValue;
            maintenance += deploy;
            fleetPoints += (float)s.getFleetPointCost();
            log.info((Object)"      ______________");
        }
        log.info((Object)" ");
        log.info((Object)"HULLMODS:");
        log.info((Object)" ");
        float hullmodsValue = 0.0f;
        for (String h : HULLMOD_LIST) {
            float price = Global.getSettings().getHullModSpec(h).getBaseValue();
            log.info((Object)("      " + Global.getSettings().getHullModSpec(h).getDisplayName() + " hullmod bought this round for " + (int)price));
            hullmodsValue += price;
        }
        log.info((Object)" ");
        log.info((Object)"____________________________");
        log.info((Object)" ");
        log.info((Object)("TOTAL HULLMODS EXPENSES: " + (int)hullmodsValue));
        log.info((Object)" ");
        log.info((Object)("TOTAL SHIPS VALUE: " + (int)totalValue));
        log.info((Object)" ");
        log.info((Object)"____________________________");
        log.info((Object)" ");
        log.info((Object)"____________________________");
        log.info((Object)" ");
        log.info((Object)("TOTAL FLEET VALUE: " + (int)(totalValue += hullmodsValue)));
        log.info((Object)" ");
        log.info((Object)("TOTAL DEPLOYMENT COST: " + (int)maintenance));
        log.info((Object)" ");
        log.info((Object)"____________________________");
        return new Vector3f(totalValue, maintenance, fleetPoints);
    }

    public static void ForcedSpawn(CombatEngineAPI engine, FleetSide side, float mapX, float mapY, boolean suppressMessage) {
        if (suppressMessage) {
            engine.getFleetManager(side).setSuppressDeploymentMessages(true);
        }
        if (engine.getFleetManager(side).getReservesCopy().size() > 0) {
            float angle = -90.0f;
            float spawnX = 0.0f;
            float spawnY = mapY / 2.0f;
            if (side == FleetSide.PLAYER) {
                spawnY *= -1.0f;
                angle *= -1.0f;
            }
            for (FleetMemberAPI member : engine.getFleetManager(side).getReservesCopy()) {
                if (member.isFighterWing()) continue;
                Vector2f loc = new Vector2f(spawnX, spawnY);
                engine.getFleetManager(side).spawnFleetMember(member, loc, angle, 3.0f);
                log.info((Object)("Spawning " + side.name() + "'s " + member.getHullId() + " at " + (int)spawnX + "x" + (int)spawnY));
                if (spawnX > 0.0f) {
                    spawnX *= -1.0f;
                } else {
                    spawnX *= -1.0f;
                    spawnX += 500.0f;
                }
                if (!(spawnX >= mapX / 4.0f)) continue;
                spawnX = 0.0f;
                if (side == FleetSide.PLAYER) {
                    spawnY -= 600.0f;
                    continue;
                }
                spawnY += 600.0f;
            }
        }
        if (suppressMessage) {
            engine.getFleetManager(side).setSuppressDeploymentMessages(false);
        }
    }
}

