/*
 * Decompiled with CFR 0.152.
 */
package data.missions.FleetTester;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.missions.scripts.FleetTester_utils;
import data.scripts.plugins.FleetTester_freeCamPlugin;
import java.util.List;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector3f;

public class MissionDefinition
implements MissionDefinitionPlugin {
    public static Logger log = Global.getLogger(MissionDefinition.class);
    private static boolean deploy = false;
    public static final String PATH = "data/missions/FleetTester/";
    private static float mapX;
    private static float mapY;

    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "TEST", FleetGoal.ATTACK, false, 1);
        api.setFleetTagline(FleetSide.PLAYER, "Test Fleet");
        List<FleetMemberAPI> PLAYER_FLEET = FleetTester_utils.addShip(api, FleetSide.PLAYER, PATH);
        api.initFleet(FleetSide.ENEMY, "AI", FleetGoal.ATTACK, true, 1);
        api.setFleetTagline(FleetSide.ENEMY, "Enemy Fleet");
        List<FleetMemberAPI> ENEMY_FLEET = FleetTester_utils.addShip(api, FleetSide.ENEMY, PATH);
        Vector3f playerCost = FleetTester_utils.FleetCost(Global.getCombatEngine(), FleetSide.PLAYER, PLAYER_FLEET);
        Vector3f enemyCost = FleetTester_utils.FleetCost(Global.getCombatEngine(), FleetSide.ENEMY, ENEMY_FLEET);
        api.addBriefingItem("Test fleet cost : " + playerCost.x + ", deployment cost : " + playerCost.y + ", fleet points used: " + playerCost.z);
        api.addBriefingItem("  VERSUS");
        api.addBriefingItem("Enemy fleet cost : " + enemyCost.x + ", deployment cost : " + enemyCost.y + ", fleet points used: " + enemyCost.z);
        float WIDTH = 10000.0f;
        float HEIGHT = 10000.0f;
        api.initMap(-WIDTH / 2.0f, WIDTH / 2.0f, -HEIGHT / 2.0f, HEIGHT / 2.0f);
        api.addObjective(0.0f, 0.0f, "comm_relay");
        api.addObjective(-0.25f * WIDTH, -0.25f * HEIGHT, "nav_buoy");
        api.addObjective(0.25f * WIDTH, 0.25f * HEIGHT, "nav_buoy");
        api.addObjective(-0.25f * WIDTH, 0.25f * HEIGHT, "sensor_array");
        api.addObjective(0.25f * WIDTH, -0.25f * HEIGHT, "sensor_array");
        api.addPlugin((EveryFrameCombatPlugin)new Plugin());
    }

    public static final class Plugin
    extends BaseEveryFrameCombatPlugin {
        public void init(CombatEngineAPI engine) {
            FleetTester_freeCamPlugin free_cam = new FleetTester_freeCamPlugin();
            engine.removePlugin((EveryFrameCombatPlugin)free_cam);
            engine.addPlugin((EveryFrameCombatPlugin)free_cam);
            Global.getCombatEngine().setMaxFleetPoints(FleetSide.ENEMY, 9999);
            Global.getCombatEngine().setMaxFleetPoints(FleetSide.PLAYER, 9999);
            mapX = engine.getMapWidth();
            mapY = engine.getMapHeight();
            deploy = false;
        }

        public void advance(float amount, List<InputEventAPI> events) {
            CombatEngineAPI engine = Global.getCombatEngine();
            if (!deploy) {
                deploy = true;
                log.info((Object)("Map size: " + (int)mapX + "x" + (int)mapY));
                return;
            }
            if (engine.isPaused()) {
                return;
            }
            engine.maintainStatusForPlayerShip((Object)"clock", null, "Timer", (int)engine.getTotalElapsedTime(false) + " seconds", true);
        }
    }
}

