package org.lazywizard.console.commands;

import com.fs.starfarer.api.Global;
import org.json.JSONArray;
import org.json.JSONObject;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.Console;

public class ShowMerging implements BaseCommand
{
    private static CommandResult showCSV(String filePath, String idColumn, String masterMod)
    {
        try
        {
            final JSONArray csv = Global.getSettings().getMergedSpreadsheetDataForMod(idColumn, filePath, masterMod);
            return CommandResult.SUCCESS;
        }
        catch (Exception ex)
        {
            Console.showException("Failed to parse CSV: ", ex);
            return CommandResult.ERROR;
        }
    }

    private static CommandResult showJSON(String filePath, String masterMod)
    {
        try
        {
            final JSONObject json = Global.getSettings().getMergedJSONForMod(filePath, masterMod);
            return CommandResult.SUCCESS;
        }
        catch (Exception ex)
        {
            Console.showException("Failed to parse as JSON: ", ex);
            return CommandResult.ERROR;
        }
    }

    @Override
    public CommandResult runCommand(String args, CommandContext context)
    {
        if (args.isEmpty())
        {
            return CommandResult.BAD_SYNTAX;
        }

        if (args.endsWith(".csv"))
        {
            final String[] tmp = args.split(" ", 3);
            if (tmp.length != 3)
            {
                return CommandResult.BAD_SYNTAX;
            }

            final String masterMod = tmp[0], idColumn = tmp[1], filePath = tmp[2];
            Console.showMessage("Parsing \"" + filePath + "\" as CSV with '" + masterMod + "' as the master mod and '"
                    + idColumn + "' as the ID column.");
            return showCSV(filePath, idColumn, masterMod);
        }

        final String[] tmp = args.split(" ", 2);
        if (tmp.length != 2)
        {
            return CommandResult.BAD_SYNTAX;
        }

        final String masterMod = tmp[0], filePath = tmp[1];
        Console.showMessage("Parsing \"" + filePath + "\" as JSON with " + masterMod + " as the master mod.");
        return showJSON(filePath, masterMod);
    }
}
